/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.alignways;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import javax.swing.JLabel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.plugins.alignways.AlignWaysAlgnSegment;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSegmentMgr;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AlignWaysRotateCommand
extends Command {
    private final AlignWaysAlgnSegment algnSeg;
    private Collection<Node> nodes = new HashSet<Node>();
    private final EastNorth pivot;
    private final double rotationAngle;
    private final Map<Node, OldState> oldState = new HashMap<Node, OldState>();
    private final Stack<WaySegment> oldWS = new Stack();

    public AlignWaysRotateCommand() {
        this.algnSeg = AlignWaysSegmentMgr.getInstance(Main.map.mapView).getAlgnSeg();
        WaySegment algnWS = this.algnSeg.getSegment();
        WaySegment refWS = AlignWaysSegmentMgr.getInstance(Main.map.mapView).getRefSeg().getSegment();
        this.pivot = this.algnSeg.getCurrPivotCoord();
        this.nodes = this.algnSeg.getSegmentEndPoints();
        EastNorth enRefNode1 = refWS.way.getNode(refWS.lowerIndex).getEastNorth();
        EastNorth enRefNode2 = refWS.way.getNode(refWS.lowerIndex + 1).getEastNorth();
        EastNorth enAlgnNode1 = algnWS.way.getNode(algnWS.lowerIndex).getEastNorth();
        EastNorth enAlgnNode2 = algnWS.way.getNode(algnWS.lowerIndex + 1).getEastNorth();
        double refAngle = Math.atan2(enRefNode1.north() - enRefNode2.north(), enRefNode1.east() - enRefNode2.east());
        double algnAngle = Math.atan2(enAlgnNode1.north() - enAlgnNode2.north(), enAlgnNode1.east() - enAlgnNode2.east());
        this.rotationAngle = AlignWaysRotateCommand.normalise_angle(refAngle - algnAngle);
    }

    private void rotateNodes(boolean setModified) {
        WaySegment algnWS = this.algnSeg.getSegment();
        for (Node n : this.nodes) {
            OldState os = new OldState();
            os.latlon = new LatLon(n.getCoor());
            os.eastNorth = n.getEastNorth();
            os.ws = algnWS;
            os.modified = n.isModified();
            this.oldState.put(n, os);
        }
        this.oldWS.push(algnWS);
        for (Node n : this.nodes) {
            double cosPhi = Math.cos(this.rotationAngle);
            double sinPhi = Math.sin(this.rotationAngle);
            EastNorth oldEastNorth = this.oldState.get((Object)n).eastNorth;
            double x = oldEastNorth.east() - this.pivot.east();
            double y = oldEastNorth.north() - this.pivot.north();
            double nx = cosPhi * x - sinPhi * y + this.pivot.east();
            double ny = sinPhi * x + cosPhi * y + this.pivot.north();
            n.setEastNorth(new EastNorth(nx, ny));
            if (!setModified) continue;
            n.setModified(true);
        }
        this.algnSeg.updatePivotsEndpoints();
    }

    private static double normalise_angle(double a) {
        while (a > Math.PI) {
            a -= Math.PI * 2;
        }
        while (a <= -Math.PI) {
            a += Math.PI * 2;
        }
        if (a > 1.5707963267948966) {
            a -= Math.PI;
        } else if (a < -1.5707963267948966) {
            a += Math.PI;
        }
        return a;
    }

    public JLabel getDescription() {
        return new JLabel(I18n.tr((String)"Align way segment"), ImageProvider.get((String)"", (String)"alignways"), 0);
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        for (OsmPrimitive osmPrimitive : this.nodes) {
            modified.add(osmPrimitive);
        }
    }

    public boolean executeCommand() {
        this.rotateNodes(true);
        return true;
    }

    public void undoCommand() {
        for (Node n : this.nodes) {
            OldState os = this.oldState.get(n);
            n.setCoor(os.latlon);
            n.setModified(os.modified);
        }
        this.algnSeg.updatePivotsEndpoints();
    }

    public Collection<Node> getRotatedNodes() {
        return this.nodes;
    }

    public boolean areSegsAlignable() {
        Collection<Node> algnNodes = this.nodes;
        Collection<Node> refNodes = AlignWaysSegmentMgr.getInstance(Main.map.mapView).getRefSeg().getSegmentEndPoints();
        for (Node nR : refNodes) {
            if (!nR.getEastNorth().equals((Object)this.pivot)) continue;
            return true;
        }
        for (Node nA : algnNodes) {
            for (Node nR : refNodes) {
                if (!nA.equals((Object)nR)) continue;
                return false;
            }
        }
        return true;
    }

    public static class OldState {
        LatLon latlon;
        EastNorth eastNorth;
        WaySegment ws;
        boolean modified;
    }
}

