/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.image.BufferedImage;
import wmsplugin.GeorefImage;

public class WMSRequest
implements Comparable<WMSRequest> {
    private final int xIndex;
    private final int yIndex;
    private final double pixelPerDegree;
    private final boolean real;
    private int priority;
    private GeorefImage.State state;
    private BufferedImage image;

    public WMSRequest(int xIndex, int yIndex, double pixelPerDegree, boolean real) {
        this.xIndex = xIndex;
        this.yIndex = yIndex;
        this.pixelPerDegree = pixelPerDegree;
        this.real = real;
    }

    public void finish(GeorefImage.State state, BufferedImage image) {
        this.state = state;
        this.image = image;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    public double getPixelPerDegree() {
        return this.pixelPerDegree;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.pixelPerDegree);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.xIndex;
        result = 31 * result + this.yIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WMSRequest other = (WMSRequest)obj;
        if (Double.doubleToLongBits(this.pixelPerDegree) != Double.doubleToLongBits(other.pixelPerDegree)) {
            return false;
        }
        if (this.xIndex != other.xIndex) {
            return false;
        }
        return this.yIndex == other.yIndex;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(WMSRequest o) {
        return this.priority - o.priority;
    }

    public GeorefImage.State getState() {
        return this.state;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public String toString() {
        return "WMSRequest [xIndex=" + this.xIndex + ", yIndex=" + this.yIndex + ", pixelPerDegree=" + this.pixelPerDegree + "]";
    }

    public boolean isReal() {
        return this.real;
    }
}

