/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.io.CacheFiles;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.Grabber;
import wmsplugin.HTMLGrabber;
import wmsplugin.Map_Rectifier_WMSmenuAction;
import wmsplugin.WMSAdjustAction;
import wmsplugin.WMSDownloadAction;
import wmsplugin.WMSGrabber;
import wmsplugin.WMSInfo;
import wmsplugin.WMSLayer;
import wmsplugin.WMSPreferenceEditor;
import wmsplugin.WMSRemoteHandler;
import wmsplugin.io.WMSLayerExporter;
import wmsplugin.io.WMSLayerImporter;

public class WMSPlugin
extends Plugin {
    static CacheFiles cache = new CacheFiles("wmsplugin");
    public static final IntegerProperty PROP_SIMULTANEOUS_CONNECTIONS = new IntegerProperty("wmsplugin.simultaneousConnections", 3);
    public static final BooleanProperty PROP_OVERLAP = new BooleanProperty("wmsplugin.url.overlap", false);
    public static final IntegerProperty PROP_OVERLAP_EAST = new IntegerProperty("wmsplugin.url.overlapEast", 14);
    public static final IntegerProperty PROP_OVERLAP_NORTH = new IntegerProperty("wmsplugin.url.overlapNorth", 4);
    WMSLayer wmsLayer;
    static JMenu wmsJMenu;
    static ArrayList<WMSInfo> wmsList;
    static TreeMap<String, String> wmsListDefault;
    private static boolean menuEnabled;
    private static final String REMOTECONTROL_NAME = "remotecontrol";
    static final int REMOTECONTROL_MIN_REVISION = 22734;
    static final int REMOTECONTROL_NEED_API_MAJOR = 1;
    static final int REMOTECONTROL_MIN_API_MINOR = 0;
    boolean remoteControlAvailable = false;
    boolean remoteControlCompatible = true;
    boolean remoteControlInitialized = false;
    int remoteControlRevision = 0;
    int remoteControlApiMajor = 0;
    int remoteControlApiMinor = 0;
    int remoteControlProtocolMajor = 0;
    int remoteControlProtocolMinor = 0;

    static {
        wmsList = new ArrayList();
        wmsListDefault = new TreeMap();
        menuEnabled = false;
    }

    private void initRemoteControl() {
        for (PluginProxy pp : PluginHandler.pluginList) {
            PluginInformation info = pp.getPluginInformation();
            if (!REMOTECONTROL_NAME.equals(info.name)) continue;
            this.remoteControlAvailable = true;
            this.remoteControlRevision = Integer.parseInt(info.version);
            if (22734 <= this.remoteControlRevision) continue;
            this.remoteControlCompatible = false;
        }
        if (this.remoteControlAvailable && this.remoteControlCompatible) {
            Plugin plugin = (Plugin)PluginHandler.getPlugin((String)REMOTECONTROL_NAME);
            try {
                int[] versions;
                Method method = plugin.getClass().getMethod("getVersion", new Class[0]);
                Object obj = method.invoke((Object)plugin, new Object[0]);
                if (obj != null && obj instanceof int[] && (versions = (int[])obj).length >= 4) {
                    this.remoteControlApiMajor = versions[0];
                    this.remoteControlApiMinor = versions[1];
                    this.remoteControlProtocolMajor = versions[2];
                    this.remoteControlProtocolMinor = versions[3];
                }
                if (this.remoteControlApiMajor != 1 || this.remoteControlApiMinor < 0) {
                    this.remoteControlCompatible = false;
                }
                if (this.remoteControlCompatible) {
                    System.out.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": initializing remote control");
                    method = plugin.getClass().getMethod("addRequestHandler", String.class, Class.class);
                    method.invoke((Object)plugin, "/wms", WMSRemoteHandler.class);
                    this.remoteControlInitialized = true;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (this.remoteControlAvailable) {
            String msg = null;
            if (this.remoteControlCompatible) {
                if (!this.remoteControlInitialized) {
                    msg = I18n.tr((String)"Could not initialize remote control.");
                }
            } else {
                msg = I18n.tr((String)"Remote control plugin is not compatible with {0}.", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
            }
            if (msg != null) {
                String additionalMessage = I18n.tr((String)"{0} will work but remote control for this plugin is disabled.\nYou should update the plugins.", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
                String versionMessage = I18n.tr((String)"Current version of \"{1}\": {2}, internal version {3}. Need version {4}, internal version {5}.\nIf updating the plugins does not help report a bug for \"{0}\".", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), REMOTECONTROL_NAME, "" + this.remoteControlRevision, this.remoteControlApiMajor != 0 ? this.remoteControlApiMajor + "." + this.remoteControlApiMinor : I18n.tr((String)"unknown"), "22734", "1.0"});
                String title = I18n.tr((String)"{0}: Problem with remote control", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + msg + "\n" + versionMessage);
                JOptionPane.showMessageDialog(Main.parent, String.valueOf(msg) + "\n" + additionalMessage, title, 2);
            }
        }
        if (!this.remoteControlAvailable) {
            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": remote control not available");
        }
    }

    protected void initExporterAndImporter() {
        ExtensionFileFilter.exporters.add(new WMSLayerExporter());
        ExtensionFileFilter.importers.add(new WMSLayerImporter());
    }

    public WMSPlugin(PluginInformation info) {
        super(info);
        WMSPlugin.refreshMenu();
        cache.setExpire(2419200, false);
        cache.setMaxSize(70, false);
        this.initExporterAndImporter();
        this.initRemoteControl();
    }

    public void copy(String from, String to) throws FileNotFoundException, IOException {
        File pluginDir = new File(WMSPlugin.getPrefsPath());
        if (!pluginDir.exists()) {
            pluginDir.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(String.valueOf(WMSPlugin.getPrefsPath()) + to);
        InputStream in = WMSPlugin.class.getResourceAsStream(from);
        byte[] buffer = new byte[8192];
        int len = in.read(buffer);
        while (len > 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        out.close();
    }

    public static void refreshMenu() {
        wmsList.clear();
        Map prefs = Main.pref.getAllPrefix("wmsplugin.url.");
        TreeSet keys = new TreeSet(prefs.keySet());
        int prefid = 0;
        String name = null;
        String url = null;
        String cookies = "";
        int lastid = -1;
        for (String key : keys) {
            String[] elements = key.split("\\.");
            if (elements.length != 4) continue;
            try {
                prefid = Integer.parseInt(elements[2]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (prefid != lastid) {
                url = null;
                name = null;
                lastid = prefid;
            }
            if (elements[3].equals("name")) {
                name = (String)prefs.get(key);
            } else if (elements[3].equals("url")) {
                if (!((String)prefs.get(key)).startsWith("yahoo:")) {
                    url = (String)prefs.get(key);
                }
            } else if (elements[3].equals("cookies")) {
                cookies = (String)prefs.get(key);
            }
            if (name == null || url == null) continue;
            wmsList.add(new WMSInfo(name, url, cookies, prefid));
        }
        String source = "http://svn.openstreetmap.org/applications/editors/josm/plugins/wmsplugin/sources.cfg";
        try {
            String line;
            InputStreamReader r;
            MirroredInputStream s = new MirroredInputStream(source, String.valueOf(Main.pref.getPreferencesDir()) + "plugins/wmsplugin/", -1L);
            try {
                r = new InputStreamReader((InputStream)s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                r = new InputStreamReader((InputStream)s);
            }
            BufferedReader reader = new BufferedReader(r);
            while ((line = reader.readLine()) != null) {
                String[] val = line.split(";");
                if (line.startsWith("#") || val.length != 3) continue;
                WMSPlugin.setDefault("true".equals(val[0]), I18n.tr((String)val[1]), val[2]);
            }
        }
        catch (IOException s) {
            // empty catch block
        }
        Collections.sort(wmsList);
        MainMenu menu = Main.main.menu;
        if (wmsJMenu == null) {
            String string = I18n.marktr((String)"WMS");
            menu.getClass();
            wmsJMenu = menu.addMenu(string, 87, 5, HelpUtil.ht((String)"/Plugin/WMS"));
        } else {
            wmsJMenu.removeAll();
        }
        for (WMSInfo u : wmsList) {
            wmsJMenu.add(new JMenuItem((Action)((Object)new WMSDownloadAction(u))));
        }
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem((Action)((Object)new Map_Rectifier_WMSmenuAction())));
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem((Action)new JosmAction(I18n.tr((String)"Blank Layer"), "blankmenu", I18n.tr((String)"Open a blank WMS layer to load data from a file"), null, false){

            public void actionPerformed(ActionEvent ev) {
                Main.main.addLayer((Layer)new WMSLayer());
            }
        }));
        WMSPlugin.setEnabledAll(menuEnabled);
    }

    private static void setDefault(Boolean force, String name, String url) {
        String testurl = url.replaceAll("=", "_");
        wmsListDefault.put(name, url);
        if (force.booleanValue() && !Main.pref.getBoolean("wmsplugin.default." + testurl)) {
            Main.pref.put("wmsplugin.default." + testurl, true);
            int id = -1;
            for (WMSInfo i : wmsList) {
                if (url.equals(i.url)) {
                    return;
                }
                if (i.prefid <= id) continue;
                id = i.prefid;
            }
            WMSInfo newinfo = new WMSInfo(name, url, id + 1);
            newinfo.save();
            wmsList.add(newinfo);
        }
    }

    public static Grabber getGrabber(MapView mv, WMSLayer layer) {
        if (layer.baseURL.startsWith("html:")) {
            return new HTMLGrabber(mv, layer, cache);
        }
        return new WMSGrabber(mv, layer, cache);
    }

    private static void setEnabledAll(boolean isEnabled) {
        int i = 0;
        while (i < wmsJMenu.getItemCount()) {
            JMenuItem item = wmsJMenu.getItem(i);
            if (item != null) {
                item.setEnabled(isEnabled);
            }
            ++i;
        }
        menuEnabled = isEnabled;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            WMSPlugin.setEnabledAll(true);
            Main.map.addMapMode(new IconToggleButton((Action)((Object)new WMSAdjustAction(Main.map))));
        } else if (oldFrame != null && newFrame == null) {
            WMSPlugin.setEnabledAll(false);
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new WMSPreferenceEditor();
    }

    public static String getPrefsPath() {
        return String.valueOf(Main.pref.getPluginsDirectory().getPath()) + "/wmsplugin/";
    }
}

