/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UrlLabel;
import wmsplugin.WMSLayer;

public class Map_Rectifier_WMSmenuAction
extends JosmAction {
    public ArrayList<RectifierService> services = new ArrayList();

    public Map_Rectifier_WMSmenuAction() {
        super(I18n.tr((String)"Rectified Image..."), "OLmarker", I18n.tr((String)"Download Rectified Images From Various Services"), Shortcut.registerShortcut((String)"wms:rectimg", (String)I18n.tr((String)"WMS: {0}", (Object[])new Object[]{I18n.tr((String)"Rectified Image...")}), (int)82, (int)0), true);
        this.services.add(new RectifierService("Metacarta Map Rectifier", "http://labs.metacarta.com/rectifier/", "http://labs.metacarta.com/rectifier/wms.cgi?id=__s__&srs=EPSG:4326&Service=WMS&Version=1.1.0&Request=GetMap&format=image/png&", "labs\\.metacarta\\.com/(?:.*?)(?:/|=)([0-9]+)(?:\\?|/|\\.|$)", "^[0-9]+$"));
        this.services.add(new RectifierService("Geothings Map Warper", "http://warper.geothings.net/", "http://warper.geothings.net/maps/wms/__s__?request=GetMap&version=1.1.1&styles=&format=image/png&srs=epsg:4326&exceptions=application/vnd.ogc.se_inimage&", "(?:mapwarper\\.net|warper\\.geothings\\.net)/(?:.*?)/([0-9]+)(?:\\?|/|\\.|$)", "^[0-9]+$"));
        this.services.add(new RectifierService(I18n.tr((String)"Custom WMS Link"), "", "", "^\\s+$", ""));
    }

    public void actionPerformed(ActionEvent e) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(I18n.tr((String)"Supported Rectifier Services:")), GBC.eol());
        JTextField tfWmsUrl = new JTextField(30);
        String clip = this.getClipboardContents();
        ButtonGroup group = new ButtonGroup();
        AbstractButton firstBtn = null;
        for (RectifierService s : this.services) {
            JRadioButton serviceBtn = new JRadioButton(s.name);
            if (firstBtn == null) {
                firstBtn = serviceBtn;
            }
            if (!clip.equals("") && tfWmsUrl.getText().equals("") && (s.urlRegEx.matcher(clip).find() || s.idValidator.matcher(clip).matches())) {
                serviceBtn.setSelected(true);
                tfWmsUrl.setText(clip);
            }
            s.btn = serviceBtn;
            group.add(serviceBtn);
            if (!s.url.equals("")) {
                panel.add((Component)serviceBtn, GBC.std());
                panel.add((Component)new UrlLabel(s.url, I18n.tr((String)"Visit Homepage")), GBC.eol().anchor(13));
                continue;
            }
            panel.add((Component)serviceBtn, GBC.eol().anchor(17));
        }
        if (tfWmsUrl.getText().equals("") && firstBtn != null) {
            firstBtn.setSelected(true);
        }
        panel.add((Component)new JLabel(I18n.tr((String)"WMS URL or Image ID:")), GBC.eol());
        panel.add((Component)tfWmsUrl, GBC.eol().fill(2));
        ExtendedDialog diag = new ExtendedDialog(Main.parent, I18n.tr((String)"Add Rectified Image"), new String[]{I18n.tr((String)"Add Rectified Image"), I18n.tr((String)"Cancel")});
        diag.setContent((Component)panel);
        diag.setButtonIcons(new String[]{"OLmarker.png", "cancel.png"});
        block1: while (true) {
            diag.showDialog();
            int answer = diag.getValue();
            if (answer != 1) break;
            String text = tfWmsUrl.getText().trim();
            for (RectifierService s : this.services) {
                if (!s.isSelected()) continue;
                if (s.wmsUrl.equals("")) {
                    this.addWMSLayer(String.valueOf(s.name) + " (" + text + ")", text);
                    break block1;
                }
                Matcher m = s.urlRegEx.matcher(text);
                if (m.find()) {
                    String id = m.group(1);
                    String newURL = s.wmsUrl.replaceAll("__s__", id);
                    String title = String.valueOf(s.name) + " (" + id + ")";
                    this.addWMSLayer(title, newURL);
                    break block1;
                }
                if (!s.idValidator.matcher(text).matches()) break;
                String newURL = s.wmsUrl.replaceAll("__s__", text);
                String title = String.valueOf(s.name) + " (" + text + ")";
                this.addWMSLayer(title, newURL);
                break block1;
            }
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Couldn't match the entered link or id to the selected service. Please try again."), I18n.tr((String)"No valid WMS URL or id"), 0);
            diag.setVisible(true);
        }
    }

    private void addWMSLayer(String title, String url, String cookies) {
        WMSLayer wmsLayer = new WMSLayer(title, url, cookies);
        Main.main.addLayer((Layer)wmsLayer);
    }

    private void addWMSLayer(String title, String url) {
        this.addWMSLayer(title, url, "");
    }

    private String getClipboardContents() {
        String result = "";
        Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (contents == null || !contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return "";
        }
        try {
            result = (String)contents.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception ex) {
            return "";
        }
        return result.trim();
    }

    public static class RectifierService {
        private final String name;
        private final String url;
        private final String wmsUrl;
        private final Pattern urlRegEx;
        private final Pattern idValidator;
        public JRadioButton btn;

        public RectifierService(String name, String url, String wmsUrl, String urlRegEx, String idValidator) {
            this.name = name;
            this.url = url;
            this.wmsUrl = wmsUrl;
            this.urlRegEx = Pattern.compile(urlRegEx);
            this.idValidator = Pattern.compile(idValidator);
        }

        public boolean isSelected() {
            return this.btn.isSelected();
        }
    }
}

