/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import wmsplugin.GeorefImage;
import wmsplugin.Grabber;
import wmsplugin.WMSGrabber;
import wmsplugin.WMSPlugin;
import wmsplugin.WMSRequest;

public class WMSLayer
extends Layer
implements Preferences.PreferenceChangedListener {
    protected static final Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSPlugin.class.getResource("/images/wms_small.png")));
    public static final BooleanProperty PROP_ALPHA_CHANNEL = new BooleanProperty("wmsplugin.alpha_channel", true);
    public int messageNum = 5;
    protected MapView mv;
    protected String resolution;
    protected int imageSize = 500;
    protected int dax = 10;
    protected int day = 10;
    protected int daStep = 5;
    protected int minZoom = 3;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected double pixelPerDegree;
    protected GeorefImage[][] images;
    protected String baseURL;
    protected String cookies;
    protected final int serializeFormatVersion = 5;
    protected boolean autoDownloadEnabled = true;
    protected boolean settingsChanged;
    private volatile int bminx;
    private volatile int bminy;
    private volatile int bmaxx;
    private volatile int bmaxy;
    private volatile int leftEdge;
    private volatile int bottomEdge;
    private final List<WMSRequest> requestQueue = new ArrayList<WMSRequest>();
    private final List<WMSRequest> finishedRequests = new ArrayList<WMSRequest>();
    private final Lock requestQueueLock = new ReentrantLock();
    private final Condition queueEmpty = this.requestQueueLock.newCondition();
    private final List<Grabber> grabbers = new ArrayList<Grabber>();
    private final List<Thread> grabberThreads = new ArrayList<Thread>();
    private int threadCount;
    private int workingThreadCount;
    private boolean canceled;
    private boolean usesInvalidUrl = false;
    private boolean isInvalidUrlConfirmed = false;

    public WMSLayer() {
        this(I18n.tr((String)"Blank Layer"), null, null);
        this.initializeImages();
        this.mv = Main.map.mapView;
    }

    public WMSLayer(String name, String baseURL, String cookies) {
        super(name);
        this.setBackgroundLayer(true);
        this.initializeImages();
        this.baseURL = baseURL;
        this.cookies = cookies;
        WMSGrabber.getProjection(baseURL, true);
        this.mv = Main.map.mapView;
        int codeIndex = this.getName().indexOf("#PPD=");
        this.pixelPerDegree = codeIndex != -1 ? Double.valueOf(this.getName().substring(codeIndex + 5)).doubleValue() : this.getPPD();
        this.resolution = this.mv.getDist100PixelText();
        this.startGrabberThreads();
        if (!(baseURL == null || baseURL.startsWith("html:") || WMSGrabber.isUrlWithPatterns(baseURL) || baseURL.endsWith("&") || baseURL.endsWith("?"))) {
            if (!this.confirmMalformedUrl(baseURL)) {
                System.out.println(I18n.tr((String)"Warning: WMS layer deactivated because of malformed base url ''{0}''", (Object[])new Object[]{baseURL}));
                this.usesInvalidUrl = true;
                this.setName(String.valueOf(this.getName()) + I18n.tr((String)"(deactivated)"));
                return;
            }
            this.isInvalidUrlConfirmed = true;
        }
        Main.pref.addPreferenceChangeListener((Preferences.PreferenceChangedListener)this);
    }

    public boolean hasAutoDownload() {
        return this.autoDownloadEnabled;
    }

    public void destroy() {
        this.cancelGrabberThreads(false);
        Main.pref.removePreferenceChangeListener((Preferences.PreferenceChangedListener)this);
    }

    public void initializeImages() {
        GeorefImage[][] old = this.images;
        this.images = new GeorefImage[this.dax][this.day];
        if (old != null) {
            int i = 0;
            while (i < old.length) {
                int k = 0;
                while (k < old[i].length) {
                    GeorefImage o = old[i][k];
                    this.images[this.modulo((int)o.getXIndex(), (int)this.dax)][this.modulo((int)o.getYIndex(), (int)this.day)] = old[i][k];
                    ++k;
                }
                ++i;
            }
        }
        int x = 0;
        while (x < this.dax) {
            int y = 0;
            while (y < this.day) {
                if (this.images[x][y] == null) {
                    this.images[x][y] = new GeorefImage(this);
                }
                ++y;
            }
            ++x;
        }
    }

    public Icon getIcon() {
        return icon;
    }

    public String getToolTipText() {
        if (this.autoDownloadEnabled) {
            return I18n.tr((String)"WMS layer ({0}), automatically downloading in zoom {1}", (Object[])new Object[]{this.getName(), this.resolution});
        }
        return I18n.tr((String)"WMS layer ({0}), downloading in zoom {1}", (Object[])new Object[]{this.getName(), this.resolution});
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    private int modulo(int a, int b) {
        return a % b >= 0 ? a % b : a % b + b;
    }

    private boolean zoomIsTooBig() {
        return this.pixelPerDegree / this.getPPD() > (double)this.minZoom;
    }

    public void paint(Graphics2D g, MapView mv, Bounds b) {
        if (this.baseURL == null) {
            return;
        }
        if (this.usesInvalidUrl && !this.isInvalidUrlConfirmed) {
            return;
        }
        this.settingsChanged = false;
        ProjectionBounds bounds = mv.getProjectionBounds();
        this.bminx = this.getImageXIndex(bounds.min.east());
        this.bminy = this.getImageYIndex(bounds.min.north());
        this.bmaxx = this.getImageXIndex(bounds.max.east());
        this.bmaxy = this.getImageYIndex(bounds.max.north());
        this.leftEdge = (int)(bounds.min.east() * this.getPPD());
        this.bottomEdge = (int)(bounds.min.north() * this.getPPD());
        if (this.zoomIsTooBig()) {
            int x = this.bminx;
            while (x <= this.bmaxx) {
                int y = this.bminy;
                while (y <= this.bmaxy) {
                    this.images[this.modulo(x, this.dax)][this.modulo(y, this.day)].paint(g, (NavigatableComponent)mv, x, y, this.leftEdge, this.bottomEdge);
                    ++y;
                }
                ++x;
            }
        } else {
            this.downloadAndPaintVisible(g, mv, false);
        }
    }

    protected boolean confirmMalformedUrl(String url) {
        if (this.isInvalidUrlConfirmed) {
            return true;
        }
        String msg = I18n.tr((String)"<html>The base URL<br>''{0}''<br>for this WMS layer does neither end with a ''&'' nor with a ''?''.<br>This is likely to lead to invalid WMS request. You should check your<br>preference settings.<br>Do you want to fetch WMS tiles anyway?", (Object[])new Object[]{url});
        Object[] options = new String[]{I18n.tr((String)"Yes, fetch images"), I18n.tr((String)"No, abort")};
        int ret = JOptionPane.showOptionDialog(Main.parent, msg, I18n.tr((String)"Invalid URL?"), 0, 2, null, options, options[1]);
        switch (ret) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public double getPPD() {
        ProjectionBounds bounds = this.mv.getProjectionBounds();
        return (double)this.mv.getWidth() / (bounds.max.east() - bounds.min.east());
    }

    public void displace(double dx, double dy) {
        this.settingsChanged = true;
        this.dx += dx;
        this.dy += dy;
    }

    public int getImageXIndex(double coord) {
        return (int)Math.floor((coord - this.dx) * this.pixelPerDegree / (double)this.imageSize);
    }

    public int getImageYIndex(double coord) {
        return (int)Math.floor((coord - this.dy) * this.pixelPerDegree / (double)this.imageSize);
    }

    public int getImageX(int imageIndex) {
        return (int)((double)(imageIndex * this.imageSize) * (this.getPPD() / this.pixelPerDegree) + this.dx * this.getPPD());
    }

    public int getImageY(int imageIndex) {
        return (int)((double)(imageIndex * this.imageSize) * (this.getPPD() / this.pixelPerDegree) + this.dy * this.getPPD());
    }

    public int getImageWidth(int xIndex) {
        int overlap = (int)(WMSPlugin.PROP_OVERLAP.get() ? (double)(WMSPlugin.PROP_OVERLAP_EAST.get() * this.imageSize) * this.getPPD() / this.pixelPerDegree / 100.0 : 0.0);
        return this.getImageX(xIndex + 1) - this.getImageX(xIndex) + overlap;
    }

    public int getImageHeight(int yIndex) {
        int overlap = (int)(WMSPlugin.PROP_OVERLAP.get() ? (double)(WMSPlugin.PROP_OVERLAP_NORTH.get() * this.imageSize) * this.getPPD() / this.pixelPerDegree / 100.0 : 0.0);
        return this.getImageY(yIndex + 1) - this.getImageY(yIndex) + overlap;
    }

    public int getBaseImageWidth() {
        int overlap = WMSPlugin.PROP_OVERLAP.get() ? WMSPlugin.PROP_OVERLAP_EAST.get() * this.imageSize / 100 : 0;
        return this.imageSize + overlap;
    }

    public int getBaseImageHeight() {
        int overlap = WMSPlugin.PROP_OVERLAP.get() ? WMSPlugin.PROP_OVERLAP_NORTH.get() * this.imageSize / 100 : 0;
        return this.imageSize + overlap;
    }

    public EastNorth getEastNorth(int xIndex, int yIndex) {
        return new EastNorth((double)(xIndex * this.imageSize) / this.pixelPerDegree, (double)(yIndex * this.imageSize) / this.pixelPerDegree);
    }

    protected void downloadAndPaintVisible(Graphics g, MapView mv, boolean real) {
        int y;
        int newDax = this.dax;
        int newDay = this.day;
        if (this.bmaxx - this.bminx >= this.dax || this.bmaxx - this.bminx < this.dax - 2 * this.daStep) {
            newDax = ((this.bmaxx - this.bminx) / this.daStep + 1) * this.daStep;
        }
        if (this.bmaxy - this.bminy >= this.day || this.bmaxy - this.bminx < this.day - 2 * this.daStep) {
            newDay = ((this.bmaxy - this.bminy) / this.daStep + 1) * this.daStep;
        }
        if (newDax != this.dax || newDay != this.day) {
            this.dax = newDax;
            this.day = newDay;
            this.initializeImages();
        }
        int x = this.bminx;
        while (x <= this.bmaxx) {
            y = this.bminy;
            while (y <= this.bmaxy) {
                this.images[this.modulo(x, this.dax)][this.modulo(y, this.day)].changePosition(x, y);
                ++y;
            }
            ++x;
        }
        this.gatherFinishedRequests();
        x = this.bminx;
        while (x <= this.bmaxx) {
            y = this.bminy;
            while (y <= this.bmaxy) {
                GeorefImage img = this.images[this.modulo(x, this.dax)][this.modulo(y, this.day)];
                if (!img.paint(g, (NavigatableComponent)mv, x, y, this.leftEdge, this.bottomEdge)) {
                    WMSRequest request = new WMSRequest(x, y, this.pixelPerDegree, real);
                    this.addRequest(request);
                }
                ++y;
            }
            ++x;
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        int x = 0;
        while (x < this.dax) {
            int y = 0;
            while (y < this.day) {
                if (this.images[x][y].getImage() != null) {
                    v.visit(this.images[x][y].getMin());
                    v.visit(this.images[x][y].getMax());
                }
                ++y;
            }
            ++x;
        }
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createActivateLayerAction((Layer)this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new LoadWmsAction(), new SaveWmsAction(), new BookmarkWmsAction(), Layer.SeparatorLayerAction.INSTANCE, new StartStopAction(), new ToggleAlphaAction(), new ChangeResolutionAction(), new ReloadErrorTilesAction(), new DownloadAction(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public GeorefImage findImage(EastNorth eastNorth) {
        int xIndex = this.getImageXIndex(eastNorth.east());
        int yIndex = this.getImageYIndex(eastNorth.north());
        GeorefImage result = this.images[this.modulo(xIndex, this.dax)][this.modulo(yIndex, this.day)];
        if (result.getXIndex() == xIndex && result.getYIndex() == yIndex) {
            return result;
        }
        return null;
    }

    private int getRequestPriority(WMSRequest request) {
        if (request.getPixelPerDegree() != this.pixelPerDegree) {
            return -1;
        }
        if (this.bminx > request.getXIndex() || this.bmaxx < request.getXIndex() || this.bminy > request.getYIndex() || this.bmaxy < request.getYIndex()) {
            return -1;
        }
        EastNorth cursorEastNorth = this.mv.getEastNorth(this.mv.lastMEvent.getX(), this.mv.lastMEvent.getY());
        int mouseX = this.getImageXIndex(cursorEastNorth.east());
        int mouseY = this.getImageYIndex(cursorEastNorth.north());
        int dx = request.getXIndex() - mouseX;
        int dy = request.getYIndex() - mouseY;
        return dx * dx + dy * dy;
    }

    public WMSRequest getRequest() {
        this.requestQueueLock.lock();
        try {
            --this.workingThreadCount;
            Iterator<WMSRequest> it = this.requestQueue.iterator();
            while (it.hasNext()) {
                WMSRequest item = it.next();
                int priority = this.getRequestPriority(item);
                if (priority == -1) {
                    it.remove();
                    continue;
                }
                item.setPriority(priority);
            }
            Collections.sort(this.requestQueue);
            EastNorth cursorEastNorth = this.mv.getEastNorth(this.mv.lastMEvent.getX(), this.mv.lastMEvent.getY());
            int mouseX = this.getImageXIndex(cursorEastNorth.east());
            int mouseY = this.getImageYIndex(cursorEastNorth.north());
            boolean isOnMouse = this.requestQueue.size() > 0 && this.requestQueue.get(0).getXIndex() == mouseX && this.requestQueue.get(0).getYIndex() == mouseY;
            while (!this.canceled && (this.requestQueue.isEmpty() || !isOnMouse && this.threadCount - this.workingThreadCount == 0 && this.threadCount > 1)) {
                try {
                    this.queueEmpty.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this.workingThreadCount;
            if (this.canceled) {
                return null;
            }
            WMSRequest wMSRequest = this.requestQueue.remove(0);
            return wMSRequest;
        }
        finally {
            this.requestQueueLock.unlock();
        }
    }

    public void finishRequest(WMSRequest request) {
        if (request.getState() == null) {
            throw new IllegalArgumentException("Finished request without state");
        }
        this.requestQueueLock.lock();
        try {
            this.finishedRequests.add(request);
        }
        finally {
            this.requestQueueLock.unlock();
        }
    }

    public void addRequest(WMSRequest request) {
        this.requestQueueLock.lock();
        try {
            if (!this.requestQueue.contains(request)) {
                this.requestQueue.add(request);
                this.queueEmpty.signalAll();
            }
        }
        finally {
            this.requestQueueLock.unlock();
        }
    }

    public boolean requestIsValid(WMSRequest request) {
        return this.bminx <= request.getXIndex() && this.bmaxx >= request.getXIndex() && this.bminy <= request.getYIndex() && this.bmaxy >= request.getYIndex();
    }

    private void gatherFinishedRequests() {
        this.requestQueueLock.lock();
        try {
            for (WMSRequest request : this.finishedRequests) {
                GeorefImage img = this.images[this.modulo(request.getXIndex(), this.dax)][this.modulo(request.getYIndex(), this.day)];
                if (!img.equalPosition(request.getXIndex(), request.getYIndex())) continue;
                img.changeImage(request.getState(), request.getImage());
            }
        }
        finally {
            this.finishedRequests.clear();
            this.requestQueueLock.unlock();
        }
    }

    private void cancelGrabberThreads(boolean wait) {
        this.requestQueueLock.lock();
        try {
            this.canceled = true;
            for (Grabber grabber : this.grabbers) {
                grabber.cancel();
            }
            this.queueEmpty.signalAll();
        }
        finally {
            this.requestQueueLock.unlock();
        }
        if (wait) {
            for (Thread t : this.grabberThreads) {
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void startGrabberThreads() {
        int threadCount = WMSPlugin.PROP_SIMULTANEOUS_CONNECTIONS.get();
        this.requestQueueLock.lock();
        try {
            this.canceled = false;
            this.grabbers.clear();
            this.grabberThreads.clear();
            int i = 0;
            while (i < threadCount) {
                Grabber grabber = WMSPlugin.getGrabber(this.mv, this);
                this.grabbers.add(grabber);
                Thread t = new Thread((Runnable)grabber, "WMS " + this.getName() + " " + i);
                t.setDaemon(true);
                t.start();
                this.grabberThreads.add(t);
                ++i;
            }
            this.workingThreadCount = this.grabbers.size();
            this.threadCount = this.grabbers.size();
        }
        finally {
            this.requestQueueLock.unlock();
        }
    }

    public boolean isChanged() {
        this.requestQueueLock.lock();
        try {
            boolean bl = !this.finishedRequests.isEmpty() || this.settingsChanged;
            return bl;
        }
        finally {
            this.requestQueueLock.unlock();
        }
    }

    public void preferenceChanged(Preferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(WMSPlugin.PROP_SIMULTANEOUS_CONNECTIONS.getKey())) {
            this.cancelGrabberThreads(true);
            this.startGrabberThreads();
        } else if (event.getKey().equals(WMSPlugin.PROP_OVERLAP.getKey()) || event.getKey().equals(WMSPlugin.PROP_OVERLAP_EAST.getKey()) || event.getKey().equals(WMSPlugin.PROP_OVERLAP_NORTH.getKey())) {
            int i = 0;
            while (i < this.images.length) {
                int k = 0;
                while (k < this.images[i].length) {
                    this.images[i][k] = new GeorefImage(this);
                    ++k;
                }
                ++i;
            }
            this.settingsChanged = true;
        }
    }

    public class BookmarkWmsAction
    extends AbstractAction {
        public BookmarkWmsAction() {
            super(I18n.tr((String)"Set WMS Bookmark"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int i = 0;
            while (Main.pref.hasKey("wmsplugin.url." + i + ".url")) {
                ++i;
            }
            int parameterIndex = WMSLayer.this.getName().indexOf("#PPD=");
            String baseName = parameterIndex != -1 ? WMSLayer.this.getName().substring(0, parameterIndex) : WMSLayer.this.getName();
            Main.pref.put("wmsplugin.url." + i + ".url", WMSLayer.this.baseURL);
            Main.pref.put("wmsplugin.url." + String.valueOf(i) + ".name", String.valueOf(baseName) + "#PPD=" + WMSLayer.this.pixelPerDegree);
            WMSPlugin.refreshMenu();
        }
    }

    public class ChangeResolutionAction
    extends AbstractAction {
        public ChangeResolutionAction() {
            super(I18n.tr((String)"Change resolution"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WMSLayer.this.initializeImages();
            WMSLayer.this.resolution = WMSLayer.this.mv.getDist100PixelText();
            WMSLayer.this.pixelPerDegree = WMSLayer.this.getPPD();
            WMSLayer.this.settingsChanged = true;
            WMSLayer.this.mv.repaint();
        }
    }

    public class DownloadAction
    extends AbstractAction {
        private static final long serialVersionUID = -7183852461015284020L;

        public DownloadAction() {
            super(I18n.tr((String)"Download visible tiles"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (WMSLayer.this.zoomIsTooBig()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The requested area is too big. Please zoom in a little, or change resolution"), I18n.tr((String)"Error"), 0);
            } else {
                WMSLayer.this.downloadAndPaintVisible(WMSLayer.this.mv.getGraphics(), WMSLayer.this.mv, true);
            }
        }
    }

    public class LoadWmsAction
    extends AbstractAction {
        public LoadWmsAction() {
            super(I18n.tr((String)"Load WMS layer from file"), ImageProvider.get((String)"load"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            JFileChooser fc = DiskAccessAction.createAndOpenFileChooser((boolean)true, (boolean)false, (String)I18n.tr((String)"Load WMS layer"), (String)"wms");
            if (fc == null) {
                return;
            }
            File f = fc.getSelectedFile();
            if (f == null) {
                return;
            }
            try {
                FileInputStream fis = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(fis);
                int sfv = ois.readInt();
                if (sfv != 5) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unsupported WMS file version; found {0}, expected {1}", (Object[])new Object[]{sfv, 5}), I18n.tr((String)"File Format Error"), 0);
                    return;
                }
                WMSLayer.this.autoDownloadEnabled = false;
                WMSLayer.this.dax = ois.readInt();
                WMSLayer.this.day = ois.readInt();
                WMSLayer.this.imageSize = ois.readInt();
                WMSLayer.this.pixelPerDegree = ois.readDouble();
                WMSLayer.this.setName((String)ois.readObject());
                WMSLayer.this.baseURL = (String)ois.readObject();
                WMSLayer.this.images = (GeorefImage[][])ois.readObject();
                ois.close();
                fis.close();
                GeorefImage[][] georefImageArray = WMSLayer.this.images;
                int n = WMSLayer.this.images.length;
                int n2 = 0;
                while (n2 < n) {
                    GeorefImage[] imgs;
                    GeorefImage[] georefImageArray2 = imgs = georefImageArray[n2];
                    int n3 = imgs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        GeorefImage img = georefImageArray2[n4];
                        if (img != null) {
                            img.setLayer(WMSLayer.this);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                WMSLayer.this.settingsChanged = true;
                WMSLayer.this.mv.repaint();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error loading file"), I18n.tr((String)"Error"), 0);
                return;
            }
        }
    }

    public class ReloadErrorTilesAction
    extends AbstractAction {
        public ReloadErrorTilesAction() {
            super(I18n.tr((String)"Reload erroneous tiles"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WMSPlugin.cache.customCleanUp(1, 4096);
            int x = 0;
            while (x < WMSLayer.this.dax) {
                int y = 0;
                while (y < WMSLayer.this.day) {
                    GeorefImage img = WMSLayer.this.images[WMSLayer.this.modulo(x, WMSLayer.this.dax)][WMSLayer.this.modulo(y, WMSLayer.this.day)];
                    if (img.getState() == GeorefImage.State.FAILED) {
                        WMSLayer.this.addRequest(new WMSRequest(img.getXIndex(), img.getYIndex(), WMSLayer.this.pixelPerDegree, true));
                        WMSLayer.this.mv.repaint();
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public class SaveWmsAction
    extends AbstractAction {
        public SaveWmsAction() {
            super(I18n.tr((String)"Save WMS layer to file"), ImageProvider.get((String)"save"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            File f = SaveActionBase.createAndOpenSaveFileChooser((String)I18n.tr((String)"Save WMS layer"), (String)".wms");
            try {
                if (f != null) {
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
                    oos.writeInt(5);
                    oos.writeInt(WMSLayer.this.dax);
                    oos.writeInt(WMSLayer.this.day);
                    oos.writeInt(WMSLayer.this.imageSize);
                    oos.writeDouble(WMSLayer.this.pixelPerDegree);
                    oos.writeObject(WMSLayer.this.getName());
                    oos.writeObject(WMSLayer.this.baseURL);
                    oos.writeObject(WMSLayer.this.images);
                    oos.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }

    private class StartStopAction
    extends AbstractAction
    implements Layer.LayerAction {
        public StartStopAction() {
            super(I18n.tr((String)"Automatic downloading"));
        }

        public Component createMenuComponent() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(this);
            item.setSelected(WMSLayer.this.autoDownloadEnabled);
            return item;
        }

        public boolean supportLayers(List<Layer> layers) {
            return layers.size() == 1 && layers.get(0) instanceof WMSLayer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean bl = WMSLayer.this.autoDownloadEnabled = !WMSLayer.this.autoDownloadEnabled;
            if (WMSLayer.this.autoDownloadEnabled) {
                WMSLayer.this.mv.repaint();
            }
        }
    }

    public class ToggleAlphaAction
    extends AbstractAction
    implements Layer.LayerAction {
        public ToggleAlphaAction() {
            super(I18n.tr((String)"Alpha channel"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)ev.getSource();
            boolean alphaChannel = checkbox.isSelected();
            PROP_ALPHA_CHANNEL.put(alphaChannel);
            int x = 0;
            while (x < WMSLayer.this.dax) {
                int y = 0;
                while (y < WMSLayer.this.day) {
                    GeorefImage img = WMSLayer.this.images[WMSLayer.this.modulo(x, WMSLayer.this.dax)][WMSLayer.this.modulo(y, WMSLayer.this.day)];
                    img.flushedResizedCachedInstance();
                    ++y;
                }
                ++x;
            }
            WMSLayer.this.mv.repaint();
        }

        public Component createMenuComponent() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(this);
            item.setSelected(PROP_ALPHA_CHANNEL.get());
            return item;
        }

        public boolean supportLayers(List<Layer> layers) {
            return layers.size() == 1 && layers.get(0) instanceof WMSLayer;
        }
    }
}

