/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoySaw
extends Buoy {
    public BuoySaw(SmpDialogAction dia, Node node) {
        super(dia);
        String str;
        Map keys = node.getKeys();
        this.setNode(node);
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem("Not set");
        this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Sphere Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Beacon");
        this.dlg.cbM01StyleOfMark.addItem("Float");
        this.dlg.cbM01Kennung.removeAllItems();
        this.dlg.cbM01Kennung.addItem("Not set");
        this.dlg.cbM01Kennung.addItem("Iso");
        this.dlg.cbM01Kennung.addItem("Oc");
        this.dlg.cbM01Kennung.addItem("LFl");
        this.dlg.cbM01Kennung.addItem("Mo()");
        this.dlg.cM01Fired.setSelected(false);
        this.dlg.cM01TopMark.setSelected(false);
        this.dlg.tbM01Region.setEnabled(false);
        this.setColour(5);
        this.setLightColour("W");
        this.setBuoyIndex(5);
        this.setRegion(Main.pref.get("tomsplugin.IALA").equals("B"));
        if (keys.containsKey("name")) {
            this.setName((String)keys.get("name"));
        }
        if (keys.containsKey("seamark:name")) {
            this.setName((String)keys.get("seamark:name"));
        }
        if (keys.containsKey("seamark:buoy_safe_water:name")) {
            this.setName((String)keys.get("seamark:buoy_safe_water:name"));
        } else if (keys.containsKey("seamark:beacon_safe_water:name")) {
            this.setName((String)keys.get("seamark:beacon_safe_water:name"));
        } else if (keys.containsKey("seamark:light_float:name")) {
            this.setName((String)keys.get("seamark:light_float:name"));
        }
        if (keys.containsKey("seamark:buoy_safe_water:shape")) {
            str = (String)keys.get("seamark:buoy_safe_water:shape");
            if (str.equals("pillar")) {
                this.setStyleIndex(1);
            } else if (str.equals("spar")) {
                this.setStyleIndex(2);
            } else if (str.equals("sphere")) {
                this.setStyleIndex(3);
            }
        } else if (keys.containsKey("seamark:type") && ((String)keys.get("seamark:type")).equals("light_float")) {
            this.setStyleIndex(5);
        } else if (keys.containsKey("seamark:type") && ((String)keys.get("seamark:type")).equals("beacon_safe_water")) {
            this.setStyleIndex(4);
        }
        if (keys.containsKey("seamark:light:colour")) {
            str = (String)keys.get("seamark:light:colour");
            if (keys.containsKey("seamark:light:character")) {
                this.setLightGroup(keys);
                String c = (String)keys.get("seamark:light:character");
                if (this.getLightGroup() != "") {
                    c = c + "(" + this.getLightGroup() + ")";
                }
                this.setLightChar(c);
                this.setLightPeriod(keys);
            }
            if (str.equals("white")) {
                this.setFired(true);
                this.setLightColour("W");
            }
        }
        if (keys.containsKey("seamark:topmark:shape") || keys.containsKey("seamark:topmark:colour")) {
            this.setTopMark(true);
        }
    }

    public void paintSign() {
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        this.dlg.lM01Icon02.setIcon(null);
        this.dlg.tfM01Name.setEnabled(true);
        this.dlg.tfM01Name.setText(this.getName());
        this.dlg.cM01Fired.setEnabled(true);
        this.dlg.cM01TopMark.setEnabled(true);
        String image = "/images/Safe_Water";
        switch (this.getStyleIndex()) {
            case 1: {
                image = image + "_Pillar";
                break;
            }
            case 2: {
                image = image + "_Spar";
                break;
            }
            case 3: {
                image = image + "_Sphere";
                break;
            }
            case 4: {
                image = image + "_Beacon";
                break;
            }
            case 5: {
                image = image + "_Float";
                break;
            }
        }
        if (!image.equals("/images/Safe_Water")) {
            image = image + ".png";
            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource(image)));
            if (this.hasTopMark()) {
                image = image + "_Sphere";
            }
            if (this.isFired()) {
                this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_White_240.png")));
                if (this.getLightChar() != "") {
                    String c = this.getLightChar();
                    this.dlg.cbM01Kennung.setSelectedItem(c);
                    if (this.dlg.cbM01Kennung.getSelectedItem().equals("Not set")) {
                        String string = "";
                    }
                }
            }
        } else {
            this.dlg.lM01Icon01.setIcon(null);
        }
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        switch (this.getStyleIndex()) {
            case 1: {
                super.saveSign("buoy_safe_water");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_safe_water:shape", "pillar"));
                break;
            }
            case 2: {
                super.saveSign("buoy_safe_water");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_safe_water:shape", "spar"));
                break;
            }
            case 3: {
                super.saveSign("buoy_safe_water");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_safe_water:shape", "sphere"));
                break;
            }
            case 4: {
                super.saveSign("beacon_safe_water");
                break;
            }
            case 5: {
                super.saveSign("light_float");
                break;
            }
        }
        switch (this.getStyleIndex()) {
            case 1: 
            case 2: 
            case 3: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_safe_water:colour_pattern", "vertical stripes"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_safe_water:colour", "red;white"));
                break;
            }
            case 4: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_safe_water:colour_pattern", "vertical stripes"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_safe_water:colour", "red;white"));
                break;
            }
            case 5: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour_pattern", "vertical stripes"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "red;white"));
                break;
            }
        }
        this.saveTopMarkData("spherical", "red");
        this.saveLightData("white");
    }

    public void setLightColour() {
        super.setLightColour("W");
    }
}

