/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoyLat
extends Buoy {
    public BuoyLat(SmpDialogAction dia, Node node) {
        super(dia);
        Map keys = node.getKeys();
        this.setNode(node);
        this.dlg.cbM01Kennung.removeAllItems();
        this.dlg.cbM01Kennung.addItem("Not set");
        this.dlg.cbM01Kennung.addItem("Fl");
        this.dlg.cbM01Kennung.addItem("Fl(2)");
        this.dlg.cbM01Kennung.addItem("Fl(3)");
        this.dlg.cbM01Kennung.addItem("Fl(4)");
        this.dlg.cbM01Kennung.addItem("Fl(5)");
        this.dlg.cbM01Kennung.addItem("Oc(2)");
        this.dlg.cbM01Kennung.addItem("Oc(3)");
        this.dlg.cbM01Kennung.addItem("Q");
        this.dlg.cbM01Kennung.addItem("IQ");
        this.dlg.cbM01Kennung.setSelectedIndex(0);
        this.setStyleIndex(0);
        this.setLightColour();
        this.setFired(false);
        this.setTopMark(false);
        this.setRegion(Main.pref.get("tomsplugin.IALA").equals("B"));
        this.dlg.cM01Fired.setSelected(false);
        this.dlg.cM01TopMark.setSelected(false);
        this.dlg.tbM01Region.setEnabled(true);
        if (keys.containsKey("name")) {
            this.setName((String)keys.get("name"));
        }
        if (keys.containsKey("seamark:name")) {
            this.setName((String)keys.get("seamark:name"));
        }
        if (keys.containsKey("seamark:buoy_lateral:name")) {
            this.setName((String)keys.get("seamark:buoy_lateral:name"));
        } else if (keys.containsKey("seamark:beacon_lateral:name")) {
            this.setName((String)keys.get("seamark:beacon_lateral:name"));
        } else if (keys.containsKey("seamark:light_float:name")) {
            this.setName((String)keys.get("seamark:light_float:name"));
        }
        String cat = "";
        String col = "";
        if (keys.containsKey("seamark:buoy_lateral:category")) {
            cat = (String)keys.get("seamark:buoy_lateral:category");
        } else if (keys.containsKey("seamark:beacon_lateral:category")) {
            cat = (String)keys.get("seamark:beacon_lateral:category");
        }
        if (keys.containsKey("seamark:buoy_lateral:colour")) {
            col = (String)keys.get("seamark:buoy_lateral:colour");
        } else if (keys.containsKey("seamark:beacon_lateral:colour")) {
            col = (String)keys.get("seamark:beacon_lateral:colour");
        } else if (keys.containsKey("seamark:light_float:colour")) {
            col = (String)keys.get("seamark:light_float:colour");
        }
        if (cat.equals("")) {
            if (col.equals("red")) {
                this.setColour(1);
                if (!this.getRegion()) {
                    this.setBuoyIndex(1);
                } else {
                    this.setBuoyIndex(2);
                }
            } else if (col.equals("green")) {
                this.setColour(2);
                if (!this.getRegion()) {
                    this.setBuoyIndex(2);
                } else {
                    this.setBuoyIndex(1);
                }
            } else if (col.equals("red;green;red")) {
                this.setColour(3);
                if (!this.getRegion()) {
                    this.setBuoyIndex(3);
                } else {
                    this.setBuoyIndex(4);
                }
            } else if (col.equals("green;red;green")) {
                this.setColour(4);
                if (!this.getRegion()) {
                    this.setBuoyIndex(4);
                } else {
                    this.setBuoyIndex(3);
                }
            }
        } else if (cat.equals("port")) {
            this.setBuoyIndex(1);
            if (col.equals("red")) {
                this.setRegion(false);
                this.setColour(1);
            } else if (col.equals("green")) {
                this.setRegion(true);
                this.setColour(2);
            } else if (!this.getRegion()) {
                this.setColour(1);
            } else {
                this.setColour(2);
            }
        } else if (cat.equals("starboard")) {
            this.setBuoyIndex(2);
            if (col.equals("green")) {
                this.setRegion(false);
                this.setColour(2);
            } else if (col.equals("red")) {
                this.setRegion(true);
                this.setColour(1);
            } else if (!this.getRegion()) {
                this.setColour(2);
            } else {
                this.setColour(1);
            }
        } else if (cat.equals("preferred_channel_port")) {
            this.setBuoyIndex(3);
            if (col.equals("red;green;red")) {
                this.setRegion(false);
                this.setColour(3);
            } else if (col.equals("green;red;green")) {
                this.setRegion(true);
                this.setColour(4);
            } else if (!this.getRegion()) {
                this.setColour(3);
            } else {
                this.setColour(4);
            }
        } else if (cat.equals("preferred_channel_starboard")) {
            this.setBuoyIndex(4);
            if (col.equals("green;red;green")) {
                this.setRegion(false);
                this.setColour(4);
            } else if (col.equals("red;green;red")) {
                this.setRegion(true);
                this.setColour(3);
            } else if (!this.getRegion()) {
                this.setColour(4);
            } else {
                this.setColour(3);
            }
        }
        if (keys.containsKey("seamark:buoy_lateral:shape")) {
            String str = (String)keys.get("seamark:buoy_lateral:shape");
            switch (this.getBuoyIndex()) {
                case 1: {
                    if (str.equals("can")) {
                        this.setStyleIndex(1);
                        break;
                    }
                    if (str.equals("pillar")) {
                        this.setStyleIndex(2);
                        break;
                    }
                    if (!str.equals("spar")) break;
                    this.setStyleIndex(3);
                    break;
                }
                case 3: {
                    if (str.equals("can")) {
                        this.setStyleIndex(1);
                        break;
                    }
                    if (str.equals("pillar")) {
                        this.setStyleIndex(2);
                        break;
                    }
                    if (!str.equals("spar")) break;
                    this.setStyleIndex(3);
                    break;
                }
                case 2: {
                    if (str.equals("conical")) {
                        this.setStyleIndex(1);
                        break;
                    }
                    if (str.equals("pillar")) {
                        this.setStyleIndex(2);
                        break;
                    }
                    if (!str.equals("spar")) break;
                    this.setStyleIndex(3);
                    break;
                }
                case 4: {
                    if (str.equals("conical")) {
                        this.setStyleIndex(1);
                        break;
                    }
                    if (str.equals("pillar")) {
                        this.setStyleIndex(2);
                        break;
                    }
                    if (!str.equals("spar")) break;
                    this.setStyleIndex(3);
                }
            }
        } else if (keys.containsKey("seamark:beacon_lateral:shape")) {
            String str = (String)keys.get("seamark:beacon_lateral:shape");
            if (str.equals("tower")) {
                this.setStyleIndex(5);
            } else if (str.equals("perch")) {
                this.setStyleIndex(7);
            } else {
                this.setStyleIndex(4);
            }
        } else if (keys.containsKey("seamark:type") && ((String)keys.get("seamark:type")).equals("beacon_lateral")) {
            this.setStyleIndex(4);
        } else if (keys.containsKey("seamark:type") && ((String)keys.get("seamark:type")).equals("light_float")) {
            this.setStyleIndex(6);
        }
        this.refreshStyles();
        if (this.getStyleIndex() != 7) {
            if (keys.containsKey("seamark:topmark:shape") || keys.containsKey("seamark:topmark:colour")) {
                this.setTopMark(true);
            }
            if (keys.containsKey("seamark:light:colour")) {
                this.setLightColour((String)keys.get("seamark:light:colour"));
                this.setFired(true);
            }
            if (keys.containsKey("seamark:light:character")) {
                this.setLightGroup(keys);
                this.setLightChar((String)keys.get("seamark:light:character"));
                this.setLightPeriod(keys);
            }
        }
    }

    public void refreshStyles() {
        int type = this.getBuoyIndex();
        int style = this.getStyleIndex();
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem("Not set");
        switch (type) {
            case 1: {
                this.dlg.cbM01StyleOfMark.addItem("Can Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Beacon");
                this.dlg.cbM01StyleOfMark.addItem("Tower");
                this.dlg.cbM01StyleOfMark.addItem("Float");
                this.dlg.cbM01StyleOfMark.addItem("Perch");
                break;
            }
            case 2: {
                this.dlg.cbM01StyleOfMark.addItem("Cone Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Beacon");
                this.dlg.cbM01StyleOfMark.addItem("Tower");
                this.dlg.cbM01StyleOfMark.addItem("Float");
                this.dlg.cbM01StyleOfMark.addItem("Perch");
                break;
            }
            case 3: {
                this.dlg.cbM01StyleOfMark.addItem("Can Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Beacon");
                this.dlg.cbM01StyleOfMark.addItem("Tower");
                this.dlg.cbM01StyleOfMark.addItem("Float");
                break;
            }
            case 4: {
                this.dlg.cbM01StyleOfMark.addItem("Cone Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
                this.dlg.cbM01StyleOfMark.addItem("Beacon");
                this.dlg.cbM01StyleOfMark.addItem("Tower");
                this.dlg.cbM01StyleOfMark.addItem("Float");
                break;
            }
        }
        if (style >= this.dlg.cbM01StyleOfMark.getItemCount()) {
            style = 0;
        }
        this.setStyleIndex(style);
        this.dlg.cbM01StyleOfMark.setSelectedIndex(style);
    }

    public void paintSign() {
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        this.dlg.lM01Icon02.setIcon(null);
        this.dlg.tfM01Name.setEnabled(true);
        this.dlg.tfM01Name.setText(this.getName());
        this.dlg.cM01Fired.setEnabled(true);
        this.dlg.cM01TopMark.setEnabled(true);
        String image = "/images/Lateral";
        int cat = this.getBuoyIndex();
        boolean region = this.getRegion();
        int style = this.getStyleIndex();
        if (style == 7) {
            this.dlg.cM01Fired.setSelected(false);
            this.dlg.cM01TopMark.setSelected(false);
            this.dlg.cM01Fired.setEnabled(false);
            this.dlg.cM01TopMark.setEnabled(false);
        } else {
            this.dlg.cM01Fired.setEnabled(true);
            this.dlg.cM01TopMark.setEnabled(true);
        }
        block0 : switch (this.getBuoyIndex()) {
            case 1: {
                if (!region) {
                    switch (style) {
                        case 1: {
                            image = image + "_Can_Red";
                            break block0;
                        }
                        case 2: {
                            image = image + "_Pillar_Red";
                            break block0;
                        }
                        case 3: {
                            image = image + "_Spar_Red";
                            break block0;
                        }
                        case 4: {
                            image = image + "_Beacon_Red";
                            break block0;
                        }
                        case 5: {
                            image = image + "_Tower_Red";
                            break block0;
                        }
                        case 6: {
                            image = image + "_Float_Red";
                            break block0;
                        }
                        case 7: {
                            image = image + "_Perch_Port";
                            break block0;
                        }
                    }
                    break;
                }
                switch (style) {
                    case 1: {
                        image = image + "_Can_Green";
                        break block0;
                    }
                    case 2: {
                        image = image + "_Pillar_Green";
                        break block0;
                    }
                    case 3: {
                        image = image + "_Spar_Green";
                        break block0;
                    }
                    case 4: {
                        image = image + "_Beacon_Green";
                        break block0;
                    }
                    case 5: {
                        image = image + "_Tower_Green";
                        break block0;
                    }
                    case 6: {
                        image = image + "_Float_Green";
                        break block0;
                    }
                    case 7: {
                        image = image + "_Perch_Port";
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                if (!region) {
                    switch (style) {
                        case 1: {
                            image = image + "_Cone_Green";
                            break block0;
                        }
                        case 2: {
                            image = image + "_Pillar_Green";
                            break block0;
                        }
                        case 3: {
                            image = image + "_Spar_Green";
                            break block0;
                        }
                        case 4: {
                            image = image + "_Beacon_Green";
                            break block0;
                        }
                        case 5: {
                            image = image + "_Tower_Green";
                            break block0;
                        }
                        case 6: {
                            image = image + "_Float_Green";
                            break block0;
                        }
                        case 7: {
                            image = image + "_Perch_Starboard";
                            break block0;
                        }
                    }
                    break;
                }
                switch (style) {
                    case 1: {
                        image = image + "_Cone_Red";
                        break block0;
                    }
                    case 2: {
                        image = image + "_Pillar_Red";
                        break block0;
                    }
                    case 3: {
                        image = image + "_Spar_Red";
                        break block0;
                    }
                    case 4: {
                        image = image + "_Beacon_Red";
                        break block0;
                    }
                    case 5: {
                        image = image + "_Tower_Red";
                        break block0;
                    }
                    case 6: {
                        image = image + "_Float_Red";
                        break block0;
                    }
                    case 7: {
                        image = image + "_Perch_Starboard";
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                if (!region) {
                    switch (style) {
                        case 1: {
                            image = image + "_Can_Red_Green_Red";
                            break block0;
                        }
                        case 2: {
                            image = image + "_Pillar_Red_Green_Red";
                            break block0;
                        }
                        case 3: {
                            image = image + "_Spar_Red_Green_Red";
                            break block0;
                        }
                        case 4: {
                            image = image + "_Beacon_Red_Green_Red";
                            break block0;
                        }
                        case 5: {
                            image = image + "_Tower_Red_Green_Red";
                            break block0;
                        }
                        case 6: {
                            image = image + "_Float_Red_Green_Red";
                            break block0;
                        }
                    }
                    break;
                }
                switch (style) {
                    case 1: {
                        image = image + "_Can_Green_Red_Green";
                        break block0;
                    }
                    case 2: {
                        image = image + "_Pillar_Green_Red_Green";
                        break block0;
                    }
                    case 3: {
                        image = image + "_Spar_Green_Red_Green";
                        break block0;
                    }
                    case 4: {
                        image = image + "_Beacon_Green_Red_Green";
                        break block0;
                    }
                    case 5: {
                        image = image + "_Tower_Green_Red_Green";
                        break block0;
                    }
                    case 6: {
                        image = image + "_Float_Green_Red_Green";
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                if (!region) {
                    switch (style) {
                        case 1: {
                            image = image + "_Cone_Green_Red_Green";
                            break block0;
                        }
                        case 2: {
                            image = image + "_Pillar_Green_Red_Green";
                            break block0;
                        }
                        case 3: {
                            image = image + "_Spar_Green_Red_Green";
                            break block0;
                        }
                        case 4: {
                            image = image + "_Beacon_Green_Red_Green";
                            break block0;
                        }
                        case 5: {
                            image = image + "_Tower_Green_Red_Green";
                            break block0;
                        }
                        case 6: {
                            image = image + "_Float_Green_Red_Green";
                            break block0;
                        }
                    }
                    break;
                }
                switch (style) {
                    case 1: {
                        image = image + "_Cone_Red_Green_Red";
                        break block0;
                    }
                    case 2: {
                        image = image + "_Pillar_Red_Green_Red";
                        break block0;
                    }
                    case 3: {
                        image = image + "_Spar_Red_Green_Red";
                        break block0;
                    }
                    case 4: {
                        image = image + "_Beacon_Red_Green_Red";
                        break block0;
                    }
                    case 5: {
                        image = image + "_Tower_Red_Green_Red";
                        break block0;
                    }
                    case 6: {
                        image = image + "_Float_Red_Green_Red";
                        break block0;
                    }
                }
                break;
            }
        }
        if (!image.equals("/images/Lateral")) {
            if (this.hasTopMark()) {
                image = cat == 1 || cat == 3 ? image + "_Can" : image + "_Cone";
            }
            image = image + ".png";
            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource(image)));
            if (this.isFired()) {
                if (this.getLightColour().equals("R")) {
                    this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_Red_240.png")));
                } else {
                    this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_Green_240.png")));
                }
            }
            if (this.getLightChar() != "") {
                String c = this.getLightChar();
                if (this.getLightGroup() != "") {
                    c = c + "(" + this.getLightGroup() + ")";
                }
                this.dlg.cbM01Kennung.setSelectedItem(c);
                if (this.dlg.cbM01Kennung.getSelectedItem().equals("Not set")) {
                    c = "";
                }
            }
        } else {
            this.dlg.lM01Icon01.setIcon(null);
        }
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        int cat = this.getBuoyIndex();
        String shape = "";
        String colour = "";
        switch (cat) {
            case 1: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "can"));
                        break;
                    }
                    case 2: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "pillar"));
                        break;
                    }
                    case 3: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "spar"));
                        break;
                    }
                    case 4: {
                        super.saveSign("beacon_lateral");
                        break;
                    }
                    case 5: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "tower"));
                        break;
                    }
                    case 6: {
                        super.saveSign("light_float");
                        break;
                    }
                    case 7: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "perch"));
                        break;
                    }
                }
                switch (this.getStyleIndex()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:category", "port"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "green"));
                        colour = "green";
                        break;
                    }
                    case 7: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "port"));
                        break;
                    }
                    case 4: 
                    case 5: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "port"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "green"));
                        colour = "green";
                        break;
                    }
                    case 6: {
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "green"));
                        colour = "green";
                    }
                }
                shape = "cylinder";
                break;
            }
            case 3: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "can"));
                        break;
                    }
                    case 2: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "pillar"));
                        break;
                    }
                    case 3: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "spar"));
                        break;
                    }
                    case 4: {
                        super.saveSign("beacon_lateral");
                        break;
                    }
                    case 5: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "tower"));
                        break;
                    }
                    case 6: {
                        super.saveSign("light_float");
                        break;
                    }
                }
                switch (this.getStyleIndex()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:category", "preferred_channel_port"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour_pattern", "horizontal stripes"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "red;green;red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "green;red;green"));
                        colour = "green";
                        break;
                    }
                    case 4: 
                    case 5: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "preferred_channel_port"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour_pattern", "horizontal stripes"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "red;green;red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "green;red;green"));
                        colour = "green";
                        break;
                    }
                    case 6: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour_pattern", "horizontal stripes"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "red;green;red"));
                            colour = "red";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "green;red;green"));
                        colour = "green";
                    }
                }
                shape = "cylinder";
                break;
            }
            case 2: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "conical"));
                        break;
                    }
                    case 2: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "pillar"));
                        break;
                    }
                    case 3: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "spar"));
                        break;
                    }
                    case 4: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "stake"));
                        break;
                    }
                    case 5: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "tower"));
                        break;
                    }
                    case 6: {
                        super.saveSign("light_float");
                        break;
                    }
                    case 7: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "perch"));
                        break;
                    }
                }
                switch (this.getStyleIndex()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:category", "starboard"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "red"));
                        colour = "red";
                        break;
                    }
                    case 4: 
                    case 5: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "starboard"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "red"));
                        colour = "red";
                        break;
                    }
                    case 6: {
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "red"));
                        colour = "red";
                        break;
                    }
                    case 7: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "starboard"));
                    }
                }
                shape = "cone, point up";
                break;
            }
            case 4: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "conical"));
                        break;
                    }
                    case 2: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "pillar"));
                        break;
                    }
                    case 3: {
                        super.saveSign("buoy_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:shape", "spar"));
                        break;
                    }
                    case 4: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "stake"));
                        break;
                    }
                    case 5: {
                        super.saveSign("beacon_lateral");
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:shape", "tower"));
                        break;
                    }
                    case 6: {
                        super.saveSign("light_float");
                        break;
                    }
                }
                switch (this.getStyleIndex()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:category", "preferred_channel_starboard"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour_pattern", "horizontal stripes"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "green;red;green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_lateral:colour", "red;green;red"));
                        colour = "red";
                        break;
                    }
                    case 4: 
                    case 5: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:category", "preferred_channel_starboard"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour_pattern", "horizontal stripes"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "green;red;green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_lateral:colour", "red;green;red"));
                        colour = "red";
                        break;
                    }
                    case 6: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour_pattern", "horizontal stripes"));
                        if (!this.getRegion()) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "green;red;green"));
                            colour = "green";
                            break;
                        }
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "red;green;red"));
                        colour = "red";
                    }
                }
                shape = "cone, point up";
                break;
            }
        }
        this.saveTopMarkData(shape, colour);
        this.saveLightData(colour);
        Main.pref.put("tomsplugin.IALA", this.getRegion() ? "B" : "A");
    }

    public void setLightColour() {
        if (!(this.getRegion() || this.getBuoyIndex() != 1 && this.getBuoyIndex() != 3)) {
            super.setLightColour("R");
        } else {
            super.setLightColour("G");
        }
    }

    public void setLightColour(String str) {
        int cat = this.getBuoyIndex();
        if (str == null) {
            return;
        }
        switch (cat) {
            case 1: 
            case 3: {
                if (!this.getRegion()) {
                    if (str.equals("red")) {
                        this.setFired(true);
                        super.setLightColour("R");
                        break;
                    }
                    super.setLightColour("");
                    break;
                }
                if (str.equals("green")) {
                    this.setFired(true);
                    super.setLightColour("G");
                    break;
                }
                super.setLightColour("");
                break;
            }
            case 2: 
            case 4: {
                if (!this.getRegion()) {
                    if (str.equals("green")) {
                        this.setFired(true);
                        super.setLightColour("G");
                        break;
                    }
                    super.setLightColour("");
                    break;
                }
                if (str.equals("red")) {
                    this.setFired(true);
                    super.setLightColour("R");
                    break;
                }
                super.setLightColour("");
                break;
            }
        }
    }
}

