/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoyIsol
extends Buoy {
    public BuoyIsol(SmpDialogAction dia, Node node) {
        super(dia);
        String str;
        Map keys = node.getKeys();
        this.setNode(node);
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem("Not set");
        this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Beacon");
        this.dlg.cbM01StyleOfMark.addItem("Tower");
        this.dlg.cbM01StyleOfMark.addItem("Float");
        this.dlg.cbM01Kennung.removeAllItems();
        this.dlg.cbM01Kennung.addItem("Not set");
        this.dlg.cbM01Kennung.addItem("Fl(2)");
        this.dlg.cM01Fired.setSelected(false);
        this.dlg.cM01TopMark.setSelected(true);
        this.dlg.cM01TopMark.setEnabled(false);
        this.dlg.tbM01Region.setEnabled(false);
        this.setColour(10);
        this.setLightColour("W");
        this.setBuoyIndex(10);
        this.setTopMark(true);
        this.setRegion(Main.pref.get("tomsplugin.IALA").equals("B"));
        if (keys.containsKey("name")) {
            this.setName((String)keys.get("name"));
        }
        if (keys.containsKey("seamark:name")) {
            this.setName((String)keys.get("seamark:name"));
        }
        if (keys.containsKey("seamark:buoy_isolated_danger:name")) {
            this.setName((String)keys.get("seamark:buoy_isolated_danger:name"));
        } else if (keys.containsKey("seamark:beacon_isolated_danger:name")) {
            this.setName((String)keys.get("seamark:beacon_isolated_danger:name"));
        } else if (keys.containsKey("seamark:light_float:name")) {
            this.setName((String)keys.get("seamark:light_float:name"));
        }
        if (keys.containsKey("seamark:buoy_isolated_danger:shape")) {
            str = (String)keys.get("seamark:buoy_isolated_danger:shape");
            if (str.equals("pillar")) {
                this.setStyleIndex(1);
            } else if (str.equals("spar")) {
                this.setStyleIndex(2);
            }
        } else if (keys.containsKey("seamark:beacon_isolated_danger:colour")) {
            if (keys.containsKey("seamark:beacon_isolated_danger:shape")) {
                str = (String)keys.get("seamark:beacon_isolated_danger:shape");
                if (str.equals("tower")) {
                    this.setStyleIndex(4);
                } else {
                    this.setStyleIndex(3);
                }
            } else {
                this.setStyleIndex(3);
            }
        } else if (keys.containsKey("seamark:type") && ((String)keys.get("seamark:type")).equals("light_float")) {
            this.setStyleIndex(5);
        }
        if (keys.containsKey("seamark:topmark:shape") || keys.containsKey("seamark:topmark:colour")) {
            this.setTopMark(true);
        }
        if (keys.containsKey("seamark:light:colour")) {
            str = (String)keys.get("seamark:light:colour");
            if (keys.containsKey("seamark:light:character")) {
                this.setLightGroup(keys);
                String c = (String)keys.get("seamark:light:character");
                this.setLightChar(c);
                this.setLightPeriod(keys);
            }
            if (str.equals("white")) {
                this.setFired(true);
                this.setLightColour("W");
            }
        }
    }

    public void paintSign() {
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        this.dlg.lM01Icon02.setIcon(null);
        this.dlg.tfM01Name.setEnabled(true);
        this.dlg.tfM01Name.setText(this.getName());
        this.dlg.cM01Fired.setEnabled(true);
        this.dlg.cM01TopMark.setEnabled(false);
        String image = "/images/Cardinal";
        switch (this.getStyleIndex()) {
            case 1: {
                image = image + "_Pillar_Single";
                break;
            }
            case 2: {
                image = image + "_Spar_Single";
                break;
            }
            case 3: {
                image = image + "_Beacon_Single";
                break;
            }
            case 4: {
                image = image + "_Tower_Single";
                break;
            }
            case 5: {
                image = image + "_Float_Single";
                break;
            }
        }
        if (!image.equals("/images/Cardinal")) {
            image = image + ".png";
            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource(image)));
            if (this.isFired()) {
                this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_White_240.png")));
                if (this.getLightChar() != "") {
                    String c = this.getLightChar();
                    if (this.getLightGroup() != "") {
                        c = c + "(" + this.getLightGroup() + ")";
                    }
                    this.dlg.cbM01Kennung.setSelectedItem(c);
                }
            }
        } else {
            this.dlg.lM01Icon01.setIcon(null);
        }
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        switch (this.getStyleIndex()) {
            case 1: {
                super.saveSign("buoy_isolated_danger");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_isolated_danger:shape", "pillar"));
                break;
            }
            case 2: {
                super.saveSign("buoy_isolated_danger");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_isolated_danger:shape", "spar"));
                break;
            }
            case 3: {
                super.saveSign("beacon_isolated_danger");
                break;
            }
            case 4: {
                super.saveSign("beacon_isolated_danger");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_isolated_danger:shape", "tower"));
                break;
            }
            case 5: {
                super.saveSign("light_float");
                break;
            }
        }
        switch (this.getStyleIndex()) {
            case 1: 
            case 2: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_isolated_danger:colour_pattern", "horizontal stripes"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_isolated_danger:colour", "black;red;black"));
                break;
            }
            case 3: 
            case 4: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_isolated_danger:colour_pattern", "horizontal stripes"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_isolated_danger:colour", "black;red;black"));
                break;
            }
            case 5: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour_pattern", "horizontal stripes"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "black;red;black"));
            }
        }
        this.saveTopMarkData("2 spheres", "black");
        this.saveLightData("white");
    }

    public void setLightColour() {
        super.setLightColour("W");
    }
}

