/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoySpec
extends Buoy {
    public BuoySpec(SmpDialogAction dia, Node node) {
        super(dia);
        String str;
        Map keys = node.getKeys();
        this.setNode(node);
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem("Not set");
        this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Sphere Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Barrel");
        this.dlg.cbM01StyleOfMark.addItem("Float");
        this.dlg.cbM01StyleOfMark.addItem("Beacon");
        this.dlg.cbM01StyleOfMark.addItem("Tower");
        this.dlg.cbM01Kennung.removeAllItems();
        this.dlg.cbM01Kennung.addItem("Not set");
        this.dlg.cbM01Kennung.addItem("Fl");
        this.dlg.cbM01Kennung.addItem("Fl(2)");
        this.dlg.cbM01Kennung.addItem("Fl(3)");
        this.dlg.cbM01Kennung.addItem("Fl(4)");
        this.dlg.cbM01Kennung.addItem("Fl(5)");
        this.dlg.cbM01Kennung.addItem("Oc(2)");
        this.dlg.cbM01Kennung.addItem("Oc(3)");
        this.dlg.cbM01Kennung.addItem("Q");
        this.dlg.cbM01Kennung.addItem("IQ");
        this.dlg.cbM01Kennung.setSelectedIndex(0);
        this.dlg.cM01Fired.setSelected(false);
        this.dlg.cM01TopMark.setSelected(false);
        this.dlg.cM01Fired.setEnabled(false);
        this.dlg.cM01TopMark.setEnabled(true);
        this.dlg.tbM01Region.setEnabled(false);
        this.setColour(11);
        this.setLightColour("W");
        this.setBuoyIndex(11);
        if (keys.containsKey("name")) {
            this.setName((String)keys.get("name"));
        }
        if (keys.containsKey("seamark:name")) {
            this.setName((String)keys.get("seamark:name"));
        }
        if (keys.containsKey("seamark:buoy_special_purpose:name")) {
            this.setName((String)keys.get("seamark:buoy_special_purpose:name"));
        } else if (keys.containsKey("seamark:beacon_special_purpose:name")) {
            this.setName((String)keys.get("seamark:beacon_special_purpose:name"));
        } else if (keys.containsKey("seamark:light_float:name")) {
            this.setName((String)keys.get("seamark:light_float:name"));
        }
        if (keys.containsKey("seamark:buoy_special_purpose:shape")) {
            str = (String)keys.get("seamark:buoy_special_purpose:shape");
            if (str.equals("pillar")) {
                this.setStyleIndex(1);
            } else if (str.equals("spar")) {
                this.setStyleIndex(2);
            } else if (str.equals("sphere")) {
                this.setStyleIndex(3);
            } else if (str.equals("barrel")) {
                this.setStyleIndex(4);
            }
        }
        if (keys.containsKey("seamark:type") && ((String)keys.get("seamark:type")).equals("beacon_special_purpose") || keys.containsKey("seamark:special_purpose_beacon:colour") || keys.containsKey("seamark:special_purpose_beacon:shape")) {
            if (keys.containsKey("seamark:special_purpose_beacon:shape") && ((String)keys.get("seamark:soecial_purpose_beacon:shape")).equals("tower")) {
                this.setStyleIndex(7);
            } else {
                this.setStyleIndex(6);
            }
        } else if (keys.containsKey("seamark:light_float:colour") && ((String)keys.get("seamark:light_float:colour")).equals("yellow")) {
            this.setStyleIndex(5);
        }
        keys = node.getKeys();
        if (keys.containsKey("seamark:topmark:shape") && (str = (String)keys.get("seamark:topmark:shape")).equals("x-shape")) {
            this.setTopMark(true);
        }
        if (keys.containsKey("seamark:light:colour")) {
            str = (String)keys.get("seamark:light:colour");
            if (keys.containsKey("seamark:light:character")) {
                this.setLightGroup(keys);
                String c = (String)keys.get("seamark:light:character");
                if (this.getLightGroup() != "") {
                    c = c + "(" + this.getLightGroup() + ")";
                }
                this.setLightChar(c);
                this.setLightPeriod(keys);
            }
            if (str.equals("white")) {
                this.setFired(true);
                this.setLightColour("W");
            }
        }
    }

    public void setStyleIndex(int styleIndex) {
        super.setStyleIndex(styleIndex);
        if (styleIndex == 4) {
            this.dlg.cM01Fired.setSelected(false);
            this.dlg.cM01Fired.setEnabled(false);
            this.dlg.cM01TopMark.setEnabled(true);
        } else {
            this.dlg.cM01Fired.setEnabled(true);
            this.dlg.cM01TopMark.setEnabled(true);
        }
    }

    public void paintSign() {
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        this.dlg.tfM01Name.setEnabled(true);
        this.dlg.tfM01Name.setText(this.getName());
        String image = "/images/Special_Purpose";
        switch (this.getStyleIndex()) {
            case 1: {
                image = image + "_Pillar";
                break;
            }
            case 2: {
                image = image + "_Spar";
                break;
            }
            case 3: {
                image = image + "_Sphere";
                break;
            }
            case 4: {
                image = image + "_Barrel";
                break;
            }
            case 5: {
                image = image + "_Float";
                break;
            }
            case 6: {
                image = image + "_Beacon";
                break;
            }
            case 7: {
                image = image + "_Tower";
                break;
            }
        }
        if (!image.equals("/images/Special_Purpose")) {
            if (this.hasTopMark()) {
                image = image + "_CrossY";
            }
            if (this.isFired()) {
                image = image + "_Lit";
                if (this.getLightChar() != "") {
                    String c = this.getLightChar();
                    this.dlg.cbM01Kennung.setSelectedItem(c);
                    if (this.dlg.cbM01Kennung.getSelectedItem().equals("Not set")) {
                        String string = "";
                    }
                }
            }
            image = image + ".png";
            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource(image)));
        } else {
            this.dlg.lM01Icon01.setIcon(null);
        }
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        switch (this.getStyleIndex()) {
            case 1: {
                super.saveSign("buoy_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "pillar"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:colour", "yellow"));
                break;
            }
            case 2: {
                super.saveSign("buoy_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "spar"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:colour", "yellow"));
                break;
            }
            case 3: {
                super.saveSign("buoy_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "sphere"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:colour", "yellow"));
                break;
            }
            case 4: {
                super.saveSign("buoy_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:shape", "barrel"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_special_purpose:colour", "yellow"));
                break;
            }
            case 5: {
                super.saveSign("light_float");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "yellow"));
                break;
            }
            case 6: {
                super.saveSign("beacon_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_special_purpose:colour", "yellow"));
                break;
            }
            case 7: {
                super.saveSign("beacon_special_purpose");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_special_purpose:shape", "tower"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_special_purpose:colour", "yellow"));
                break;
            }
        }
        this.saveTopMarkData("x-shape", "yellow");
        this.saveLightData("white");
    }

    public void setLightColour() {
        super.setLightColour("W");
    }
}

