/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.io.CacheFiles;
import wmsplugin.GeorefImage;
import wmsplugin.WMSLayer;
import wmsplugin.WMSPlugin;
import wmsplugin.WMSRequest;

public abstract class Grabber
implements Runnable {
    protected final MapView mv;
    protected final WMSLayer layer;
    protected final CacheFiles cache;
    protected ProjectionBounds b;
    protected Projection proj;
    protected double pixelPerDegree;
    protected WMSRequest request;
    protected volatile boolean canceled;

    Grabber(MapView mv, WMSLayer layer, CacheFiles cache) {
        this.mv = mv;
        this.layer = layer;
        this.cache = cache;
    }

    private void updateState(WMSRequest request) {
        this.b = new ProjectionBounds(this.layer.getEastNorth(request.getXIndex(), request.getYIndex()), this.layer.getEastNorth(request.getXIndex() + 1, request.getYIndex() + 1));
        if (this.b.min != null && this.b.max != null && WMSPlugin.PROP_OVERLAP.get()) {
            double eastSize = this.b.max.east() - this.b.min.east();
            double northSize = this.b.max.north() - this.b.min.north();
            double eastCoef = (double)WMSPlugin.PROP_OVERLAP_EAST.get() / 100.0;
            double northCoef = (double)WMSPlugin.PROP_OVERLAP_NORTH.get() / 100.0;
            this.b = new ProjectionBounds(new EastNorth(this.b.min.east(), this.b.min.north()), new EastNorth(this.b.max.east() + eastCoef * eastSize, this.b.max.north() + northCoef * northSize));
        }
        this.proj = Main.proj;
        this.pixelPerDegree = request.getPixelPerDegree();
        this.request = request;
    }

    abstract void fetch(WMSRequest var1) throws Exception;

    int width() {
        return this.layer.getImageWidth(this.request.getXIndex());
    }

    int height() {
        return this.layer.getImageHeight(this.request.getYIndex());
    }

    public void run() {
        while (!this.canceled) {
            WMSRequest request = this.layer.getRequest();
            if (request == null) {
                return;
            }
            this.updateState(request);
            if (!this.loadFromCache(request)) {
                this.attempt(request);
            }
            if (request.getState() == null) continue;
            this.layer.finishRequest(request);
            this.mv.repaint();
        }
        return;
    }

    protected void attempt(WMSRequest request) {
        int maxTries = 5;
        for (int i = 1; i <= maxTries; ++i) {
            if (this.canceled) {
                return;
            }
            try {
                if (!this.layer.requestIsValid(request)) {
                    return;
                }
                this.fetch(request);
                break;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(Grabber.random(1000, 2000));
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                if (i != maxTries) continue;
                e.printStackTrace();
                request.finish(GeorefImage.State.FAILED, null);
                continue;
            }
        }
    }

    public static int random(int min, int max) {
        return (int)(Math.random() * (double)(max + 1 - min)) + min;
    }

    public abstract boolean loadFromCache(WMSRequest var1);

    public void cancel() {
        this.canceled = true;
    }
}

