/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoyCard
extends Buoy {
    public BuoyCard(SmpDialogAction dia, Node node) {
        super(dia);
        String str;
        Map keys = node.getKeys();
        this.setNode(node);
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem("Not set");
        this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Beacon");
        this.dlg.cbM01StyleOfMark.addItem("Tower");
        this.dlg.cbM01StyleOfMark.addItem("Float");
        this.dlg.cM01Fired.setSelected(false);
        this.dlg.cM01TopMark.setSelected(false);
        this.dlg.tbM01Region.setEnabled(false);
        if (keys.containsKey("name")) {
            this.setName((String)keys.get("name"));
        }
        if (keys.containsKey("seamark:name")) {
            this.setName((String)keys.get("seamark:name"));
        }
        if (keys.containsKey("seamark:buoy_cardinal:name")) {
            this.setName((String)keys.get("seamark:buoy_cardinal:name"));
        } else if (keys.containsKey("seamark:beacon_cardinal:name")) {
            this.setName((String)keys.get("seamark:beacon_cardinal:name"));
        } else if (keys.containsKey("seamark:light_float:name")) {
            this.setName((String)keys.get("seamark:light_float:name"));
        }
        String cat = "";
        String col = "";
        if (keys.containsKey("seamark:buoy_cardinal:category")) {
            cat = (String)keys.get("seamark:buoy_cardinal:category");
        } else if (keys.containsKey("seamark:beacon_cardinal:category")) {
            cat = (String)keys.get("seamark:beacon_cardinal:category");
        }
        if (keys.containsKey("seamark:buoy_cardinal:colour")) {
            col = (String)keys.get("seamark:buoy_cardinal:colour");
        } else if (keys.containsKey("seamark:beacon_cardinal:colour")) {
            col = (String)keys.get("seamark:beacon_cardinal:colour");
        } else if (keys.containsKey("seamark:light_float:colour")) {
            col = (String)keys.get("seamark:light_float:colour");
        }
        if (cat.equals("")) {
            if (col.equals("black;yellow")) {
                this.setBuoyIndex(6);
                this.setColour(6);
            } else if (col.equals("black;yellow;black")) {
                this.setBuoyIndex(7);
                this.setColour(7);
            } else if (col.equals("yellow;black")) {
                this.setBuoyIndex(8);
                this.setColour(8);
            } else if (col.equals("yellow;black;yellow")) {
                this.setBuoyIndex(9);
                this.setColour(9);
            }
        } else if (cat.equals("north")) {
            this.setBuoyIndex(6);
            this.setColour(6);
        } else if (cat.equals("east")) {
            this.setBuoyIndex(7);
            this.setColour(7);
        } else if (cat.equals("south")) {
            this.setBuoyIndex(8);
            this.setColour(8);
        } else if (cat.equals("west")) {
            this.setBuoyIndex(9);
            this.setColour(9);
        }
        if (keys.containsKey("seamark:buoy_cardinal:shape")) {
            str = (String)keys.get("seamark:buoy_cardinal:shape");
            if (str.equals("pillar")) {
                this.setStyleIndex(1);
            } else if (str.equals("spar")) {
                this.setStyleIndex(2);
            }
        } else if (keys.containsKey("seamark:beacon_cardinal:colour")) {
            if (keys.containsKey("seamark:beacon_cardinal:shape")) {
                str = (String)keys.get("seamark:beacon_cardinal:shape");
                if (str.equals("tower")) {
                    this.setStyleIndex(4);
                } else {
                    this.setStyleIndex(3);
                }
            } else {
                this.setStyleIndex(3);
            }
        } else if (keys.containsKey("seamark:type") && ((String)keys.get("seamark:type")).equals("light_float")) {
            this.setStyleIndex(5);
        }
        this.refreshLights();
        if (keys.containsKey("seamark:light:colour")) {
            str = (String)keys.get("seamark:light:colour");
            if (keys.containsKey("seamark:light:character")) {
                String tmp = null;
                this.setLightGroup(keys);
                String c = (String)keys.get("seamark:light:character");
                if (c.contains("+")) {
                    int i1 = c.indexOf("+");
                    tmp = c.substring(i1, c.length());
                    c = c.substring(0, i1);
                }
                if (this.getLightGroup() != "" && tmp != null) {
                    c = c + tmp;
                }
                this.setLightChar(c);
                this.setLightPeriod(keys);
            }
            if (str.equals("white")) {
                this.setFired(true);
                this.setLightColour("W");
            }
        }
    }

    public void refreshLights() {
        int type = this.getBuoyIndex();
        this.dlg.cbM01Kennung.removeAllItems();
        this.dlg.cbM01Kennung.addItem("Not set");
        this.dlg.cbM01Kennung.setSelectedIndex(0);
        switch (type) {
            case 6: {
                this.dlg.cbM01Kennung.addItem("Q");
                this.dlg.cbM01Kennung.addItem("VQ");
                break;
            }
            case 7: {
                this.dlg.cbM01Kennung.addItem("Q(3)");
                this.dlg.cbM01Kennung.addItem("VQ(3)");
                break;
            }
            case 8: {
                this.dlg.cbM01Kennung.addItem("Q(6)+LFl");
                this.dlg.cbM01Kennung.addItem("VQ(6)+LFl");
                break;
            }
            case 9: {
                this.dlg.cbM01Kennung.addItem("Q(9)");
                this.dlg.cbM01Kennung.addItem("VQ(9)");
                break;
            }
        }
    }

    public void paintSign() {
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        this.dlg.tfM01Name.setEnabled(true);
        this.dlg.tfM01Name.setText(this.getName());
        this.dlg.cM01TopMark.setSelected(true);
        this.dlg.cM01TopMark.setEnabled(false);
        this.dlg.cM01Fired.setEnabled(true);
        String image = "/images/Cardinal";
        switch (this.getStyleIndex()) {
            case 1: {
                image = image + "_Pillar";
                break;
            }
            case 2: {
                image = image + "_Spar";
                break;
            }
            case 3: {
                image = image + "_Beacon";
                break;
            }
            case 4: {
                image = image + "_Tower";
                break;
            }
            case 5: {
                image = image + "_Float";
                break;
            }
            default: {
                return;
            }
        }
        switch (this.getBuoyIndex()) {
            case 6: {
                image = image + "_North";
                break;
            }
            case 7: {
                image = image + "_East";
                break;
            }
            case 8: {
                image = image + "_South";
                break;
            }
            case 9: {
                image = image + "_West";
                break;
            }
            default: {
                return;
            }
        }
        if (!image.equals("")) {
            if (this.isFired()) {
                image = image + "_Lit";
                if (this.getLightChar() != "") {
                    String tmp = null;
                    String c = this.getLightChar();
                    if (c.contains("+")) {
                        int i1 = c.indexOf("+");
                        tmp = c.substring(i1, c.length());
                        c = c.substring(0, i1);
                    }
                    if (this.getLightGroup() != "") {
                        c = c + "(" + this.getLightGroup() + ")";
                    }
                    if (tmp != null) {
                        c = c + tmp;
                    }
                    this.dlg.cbM01Kennung.setSelectedItem(c);
                    if (this.dlg.cbM01Kennung.getSelectedItem().equals("Not set")) {
                        String string = "";
                    }
                }
            }
            image = image + ".png";
            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource(image)));
        } else {
            this.dlg.lM01Icon01.setIcon(null);
        }
    }

    public void setLightColour() {
        super.setLightColour("W");
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        String shape = "";
        switch (this.getStyleIndex()) {
            case 1: {
                super.saveSign("buoy_cardinal");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:shape", "pillar"));
                break;
            }
            case 2: {
                super.saveSign("buoy_cardinal");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:shape", "spar"));
                break;
            }
            case 3: {
                super.saveSign("beacon_cardinal");
                break;
            }
            case 4: {
                super.saveSign("beacon_cardinal");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:shape", "tower"));
                break;
            }
            case 5: {
                super.saveSign("light_float");
                break;
            }
        }
        switch (this.getStyleIndex()) {
            case 1: 
            case 2: {
                switch (this.getBuoyIndex()) {
                    case 6: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:category", "north"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour", "black;yellow"));
                        shape = "2 cones up";
                        break;
                    }
                    case 7: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:category", "east"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour", "black;yellow;black"));
                        shape = "2 cones base together";
                        break;
                    }
                    case 8: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:category", "south"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour", "yellow;black"));
                        shape = "2 cones down";
                        break;
                    }
                    case 9: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:category", "west"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour", "yellow;black;yellow"));
                        shape = "2 cones point together";
                    }
                }
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour_pattern", "horizontal stripes"));
                break;
            }
            case 3: 
            case 4: {
                switch (this.getBuoyIndex()) {
                    case 6: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:category", "north"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour", "black;yellow"));
                        shape = "2 cones up";
                        break;
                    }
                    case 7: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:category", "east"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour", "black;yellow;black"));
                        shape = "2 cones base together";
                        break;
                    }
                    case 8: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:category", "south"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour", "yellow;black"));
                        shape = "2 cones down";
                        break;
                    }
                    case 9: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:category", "west"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour", "yellow;black;yellow"));
                        shape = "2 cones point together";
                    }
                }
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour_pattern", "horizontal stripes"));
                break;
            }
            case 5: {
                switch (this.getBuoyIndex()) {
                    case 6: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "black;yellow"));
                        shape = "2 cones up";
                        break;
                    }
                    case 7: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "black;yellow;black"));
                        shape = "2 cones base together";
                        break;
                    }
                    case 8: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "yellow;black"));
                        shape = "2 cones down";
                        break;
                    }
                    case 9: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "yellow;black;yellow"));
                        shape = "2 cones point together";
                    }
                }
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour_pattern", "horizontal stripes"));
            }
        }
        this.saveTopMarkData(shape, "black");
        this.saveLightData("white");
    }
}

