/*
 * Decompiled with CFR 0.152.
 */
package toms.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import toms.seamarks.buoys.Buoy;
import toms.seamarks.buoys.BuoyCard;
import toms.seamarks.buoys.BuoyIsol;
import toms.seamarks.buoys.BuoyLat;
import toms.seamarks.buoys.BuoySaw;
import toms.seamarks.buoys.BuoySpec;
import toms.seamarks.buoys.BuoyUkn;

public class SmpDialogAction
extends JosmAction {
    private static final long serialVersionUID = -2976230949744302905L;
    private SmpDialogAction dia = null;
    private Buoy buoy = null;
    private boolean isOpen = false;
    private Node onode = null;
    private Buoy obuoy = null;
    private JMenuItem SmpItem = null;
    private String smt = "";
    private String smb = "";
    private Collection<? extends OsmPrimitive> Selection = null;
    private OsmPrimitive SelNode = null;
    private String Os = "";
    private String UserHome = "";
    private SelectionChangedListener SmpListener = new SelectionChangedListener(){

        public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
            SmpDialogAction.this.Selection = newSelection;
            for (OsmPrimitive osm : SmpDialogAction.this.Selection) {
                if (!(osm instanceof Node)) continue;
                Node node = (Node)osm;
                if (SmpDialogAction.this.Selection.size() != 1 || node.compareTo(SmpDialogAction.this.SelNode) == 0) continue;
                SmpDialogAction.this.SelNode = (OsmPrimitive)node;
                SmpDialogAction.this.parseSeaMark();
                SmpDialogAction.this.buoy.paintSign();
            }
            SmpDialogAction.this.Selection = null;
        }
    };
    private JDialog dM01SeaMap = null;
    private JPanel pM01SeaMap = null;
    private JLabel lM01TimeUnit = null;
    private JLabel lM01RepeatTime = null;
    private JLabel lM01Kennung = null;
    private JLabel lM01Name = null;
    private JLabel lM01Props02 = null;
    private JLabel lM01StyleOfMark = null;
    private JLabel lM01TypeOfMark = null;
    private JLabel lM01Region = null;
    private JLabel lM01Head = null;
    public JLabel lM01Icon01 = null;
    public JToggleButton tbM01Region = null;
    public JComboBox cbM01TypeOfMark = null;
    public JComboBox cbM01StyleOfMark = null;
    public JButton bM01Save = null;
    public JCheckBox cM01TopMark = null;
    private JCheckBox cM01Radar = null;
    public JCheckBox cM01Fired = null;
    private JCheckBox cM01Fog = null;
    public JTextField sM01StatusBar = null;
    public JTextField tfM01Name = null;
    private JButton bM01Close = null;
    public JTextField tfM01RepeatTime = null;
    public JComboBox cbM01Kennung = null;
    public JTextField tfM01FireMark = null;
    private JCheckBox cM01IconVisible = null;

    public JMenuItem getSmpItem() {
        return this.SmpItem;
    }

    public void setSmpItem(JMenuItem smpItem) {
        this.SmpItem = smpItem;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public String getOs() {
        return this.Os;
    }

    public void setOs(String os) {
        this.Os = os;
    }

    public String getUserHome() {
        return this.UserHome;
    }

    public void setUserHome(String userHome) {
        this.UserHome = userHome;
    }

    public SmpDialogAction() {
        super(I18n.tr((String)"Edit OpenSeaMap"), "Smp", I18n.tr((String)"Seamark Editor"), Shortcut.registerShortcut((String)"tools:Semarks", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Seamark Editor")}), (int)83, (int)3, (int)1), true);
        this.dia = this;
        String str = Main.pref.get("mappaint.style.sources");
        if (!str.contains("dev.openseamap.org")) {
            if (!str.equals("")) {
                str = str + new String(new char[]{'\u001e'});
            }
            Main.pref.put("mappaint.style.sources", str + "http://dev.openseamap.org/josm/seamark_styles.xml");
        }
    }

    public void CloseDialog() {
        this.onode = null;
        DataSet.selListeners.remove(this.SmpListener);
        this.Selection = null;
        if (this.isOpen) {
            this.dM01SeaMap.dispose();
        }
        this.isOpen = false;
    }

    public void actionPerformed(ActionEvent e) {
        this.onode = null;
        this.obuoy = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDialog dialog = SmpDialogAction.this.getDM01SeaMap();
                if (SmpDialogAction.this.SmpItem == null) {
                    // empty if block
                }
                dialog.setVisible(true);
            }
        });
        this.setOpen(true);
        if (this.SmpItem == null) {
            return;
        }
        this.SmpItem.setEnabled(false);
        DataSet.selListeners.add(this.SmpListener);
    }

    private void PicRebuild() {
        DataSet ds = Main.main.getCurrentDataSet();
        if (this.obuoy == null) {
            return;
        }
        Node n = this.obuoy.getNode();
        if (n != null) {
            ChangePropertyCommand c;
            if (this.smb != "") {
                c = new ChangePropertyCommand((OsmPrimitive)n, "seamark", this.smb);
                c.executeCommand();
                ds.fireSelectionChanged();
                this.smb = "";
            }
            if (this.smt != "") {
                c = new ChangePropertyCommand((OsmPrimitive)n, "seamark:type", this.smt);
                c.executeCommand();
                ds.fireSelectionChanged();
                this.smt = "";
            }
        }
        this.obuoy = null;
    }

    private void parseSeaMark() {
        int nodes = 0;
        Node node = null;
        Collection selection = null;
        DataSet ds = Main.main.getCurrentDataSet();
        if (ds == null) {
            this.buoy = new BuoyUkn(this, "active layer contains no OSM data");
            this.buoy.setNode(null);
            return;
        }
        selection = ds.getSelectedNodes();
        nodes = selection.size();
        if (nodes == 0) {
            this.buoy = new BuoyUkn(this, "Please select a node");
            this.buoy.setNode(null);
            return;
        }
        if (nodes > 1) {
            this.buoy = new BuoyUkn(this, "Please select only one node");
            this.buoy.setNode(null);
            return;
        }
        Iterator it = selection.iterator();
        node = (Node)it.next();
        if (this.onode != null && node.equals((Object)this.onode)) {
            return;
        }
        if (this.obuoy != null) {
            this.PicRebuild();
        }
        this.onode = node;
        this.cM01IconVisible.setEnabled(true);
        this.cM01IconVisible.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/Auge.png")));
        this.tbM01Region.setEnabled(true);
        this.cbM01TypeOfMark.setEnabled(true);
        this.cbM01StyleOfMark.setEnabled(true);
        String type = "";
        String str = "";
        Map keys = node.getKeys();
        if (keys.containsKey("seamark:type")) {
            type = (String)keys.get("seamark:type");
        }
        if (type.equals("buoy_lateral") || type.equals("beacon_lateral") || keys.containsKey("seamark:buoy_lateral:category") || keys.containsKey("seamark:buoy_lateral:shape") || keys.containsKey("seamark:buoy_lateral:colour") || keys.containsKey("seamark:beacon_lateral:category") || keys.containsKey("seamark:beacon_lateral:shape") || keys.containsKey("seamark:beacon_lateral:colour")) {
            this.buoy = new BuoyLat(this, node);
            return;
        }
        if (type.equals("buoy_cardinal") || type.equals("beacon_cardinal") || keys.containsKey("seamark:buoy_cardinal:category") || keys.containsKey("seamark:buoy_cardinal:shape") || keys.containsKey("seamark:buoy_cardinal:colour") || keys.containsKey("seamark:beacon_cardinal:category") || keys.containsKey("seamark:beacon_cardinal:shape") || keys.containsKey("seamark:beacon_cardinal:colour")) {
            this.buoy = new BuoyCard(this, node);
            return;
        }
        if (type.equals("buoy_safe_water") || type.equals("beacon_safe_water") || keys.containsKey("seamark:buoy_safe_water:shape") || keys.containsKey("seamark:buoy_safe_water:colour") || keys.containsKey("seamark:beacon_safe_water:shape") || keys.containsKey("seamark:beacon_safe_water:colour")) {
            this.buoy = new BuoySaw(this, node);
            return;
        }
        if (type.equals("buoy_special_purpose") || type.equals("beacon_special_purpose") || keys.containsKey("seamark:buoy_special_purpose:shape") || keys.containsKey("seamark:buoy_special_purpose:colour") || keys.containsKey("seamark:beacon_special_purpose:shape") || keys.containsKey("seamark:beacon_special_purpose:colour")) {
            this.buoy = new BuoySpec(this, node);
            return;
        }
        if (type.equals("buoy_isolated_danger") || type.equals("beacon_isolated_danger") || keys.containsKey("seamark:buoy_isolated_danger:shape") || keys.containsKey("seamark:buoy_isolated_danger:colour") || keys.containsKey("seamark:beacon_isolated_danger:shape") || keys.containsKey("seamark:beacon_isolated_danger:colour")) {
            this.buoy = new BuoyIsol(this, node);
            return;
        }
        if (type.equals("light_float")) {
            if (keys.containsKey("seamark:light_float:colour")) {
                str = (String)keys.get("seamark:light_float:colour");
                if (str.equals("red") || str.equals("green") || str.equals("red;green;red") || str.equals("green;red;green")) {
                    this.buoy = new BuoyLat(this, node);
                    return;
                }
                if (str.equals("black;yellow") || str.equals("black;yellow;black") || str.equals("yellow;black") || str.equals("yellow;black;yellow")) {
                    this.buoy = new BuoyCard(this, node);
                    return;
                }
                if (str.equals("black;red;black")) {
                    this.buoy = new BuoyIsol(this, node);
                    return;
                }
                if (str.equals("red;white")) {
                    this.buoy = new BuoySaw(this, node);
                    return;
                }
                if (str.equals("yellow")) {
                    this.buoy = new BuoySaw(this, node);
                    return;
                }
                this.buoy = new BuoyUkn(this, "Parse-Error: Invalid colour");
                this.buoy.setNode(node);
                return;
            }
            if (keys.containsKey("seamark:light_float:topmark:shape")) {
                str = (String)keys.get("seamark:light_float:topmark:shape");
                if (str.equals("cylinder") || str.equals("cone, point up")) {
                    this.buoy = new BuoyLat(this, node);
                    return;
                }
            } else if (keys.containsKey("seamark:light_float:topmark:colour") && ((str = (String)keys.get("seamark:light_float:topmark:colour")).equals("red") || str.equals("green"))) {
                this.buoy = new BuoyLat(this, node);
                return;
            }
        }
        this.buoy = new BuoyUkn(this, "Seamark not set");
        this.buoy.setNode(node);
    }

    private JDialog getDM01SeaMap() {
        if (this.dM01SeaMap == null) {
            this.dM01SeaMap = new JDialog();
            this.dM01SeaMap.setSize(new Dimension(353, 373));
            this.dM01SeaMap.setDefaultCloseOperation(2);
            this.dM01SeaMap.setModal(false);
            this.dM01SeaMap.setResizable(false);
            this.dM01SeaMap.setContentPane(this.getPM01SeaMap());
            this.dM01SeaMap.setTitle("Seamark Editor");
            this.dM01SeaMap.setVisible(false);
            this.dM01SeaMap.setAlwaysOnTop(true);
            this.dM01SeaMap.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    if (SmpDialogAction.this.obuoy != null) {
                        SmpDialogAction.this.PicRebuild();
                    }
                    DataSet.selListeners.remove(SmpDialogAction.this.SmpListener);
                    SmpDialogAction.this.Selection = null;
                    SmpDialogAction.this.SmpItem.setEnabled(true);
                }

                public void windowActivated(WindowEvent arg0) {
                    SmpDialogAction.this.parseSeaMark();
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.dM01SeaMap;
    }

    private JPanel getPM01SeaMap() {
        if (this.pM01SeaMap == null) {
            this.lM01TimeUnit = new JLabel();
            this.lM01TimeUnit.setBounds(new Rectangle(325, 230, 26, 20));
            this.lM01TimeUnit.setFont(new Font("Dialog", 0, 12));
            this.lM01TimeUnit.setText("s");
            this.lM01RepeatTime = new JLabel();
            this.lM01RepeatTime.setBounds(new Rectangle(245, 230, 70, 20));
            this.lM01RepeatTime.setFont(new Font("Dialog", 0, 12));
            this.lM01RepeatTime.setText("Period:");
            this.lM01Kennung = new JLabel();
            this.lM01Kennung.setBounds(new Rectangle(95, 230, 60, 20));
            this.lM01Kennung.setFont(new Font("Dialog", 0, 12));
            this.lM01Kennung.setText("Character:");
            this.lM01Name = new JLabel();
            this.lM01Name.setBounds(new Rectangle(5, 120, 82, 16));
            this.lM01Name.setFont(new Font("Dialog", 0, 12));
            this.lM01Name.setText("Name:");
            this.lM01Props02 = new JLabel();
            this.lM01Props02.setBounds(new Rectangle(5, 170, 90, 16));
            this.lM01Props02.setFont(new Font("Dialog", 0, 12));
            this.lM01Props02.setText("Other Features:");
            this.lM01StyleOfMark = new JLabel();
            this.lM01StyleOfMark.setBounds(new Rectangle(5, 90, 148, 16));
            this.lM01StyleOfMark.setFont(new Font("Dialog", 0, 12));
            this.lM01StyleOfMark.setText("Shape:");
            this.lM01TypeOfMark = new JLabel();
            this.lM01TypeOfMark.setBounds(new Rectangle(5, 30, 120, 16));
            this.lM01TypeOfMark.setFont(new Font("Dialog", 0, 12));
            this.lM01TypeOfMark.setText("Type:");
            this.lM01Region = new JLabel();
            this.lM01Region.setBounds(new Rectangle(5, 60, 120, 16));
            this.lM01Region.setFont(new Font("Dialog", 0, 12));
            this.lM01Region.setText("Region:");
            this.lM01Head = new JLabel();
            this.lM01Head.setBounds(new Rectangle(5, 3, 316, 16));
            this.lM01Head.setText("Seamark Properties");
            this.lM01Icon01 = new JLabel();
            this.lM01Icon01.setBounds(new Rectangle(225, 0, 160, 200));
            this.lM01Icon01.setIcon(null);
            this.lM01Icon01.setText("");
            this.pM01SeaMap = new JPanel();
            this.pM01SeaMap.setLayout(null);
            this.pM01SeaMap.add((Component)this.lM01TimeUnit, null);
            this.pM01SeaMap.add((Component)this.lM01RepeatTime, null);
            this.pM01SeaMap.add((Component)this.lM01Kennung, null);
            this.pM01SeaMap.add((Component)this.lM01Name, null);
            this.pM01SeaMap.add((Component)this.lM01Props02, null);
            this.pM01SeaMap.add((Component)this.lM01StyleOfMark, null);
            this.pM01SeaMap.add((Component)this.lM01TypeOfMark, null);
            this.pM01SeaMap.add((Component)this.lM01Region, null);
            this.pM01SeaMap.add((Component)this.lM01Head, null);
            this.pM01SeaMap.add((Component)this.lM01Icon01, null);
            this.pM01SeaMap.add((Component)this.getTbM01Region(), null);
            this.pM01SeaMap.add((Component)this.getCbM01TypeOfMark(), null);
            this.pM01SeaMap.add((Component)this.getCbM01StyleOfMark(), null);
            this.pM01SeaMap.add((Component)this.getBM01Save(), null);
            this.pM01SeaMap.add((Component)this.getCM01TopMark(), null);
            this.pM01SeaMap.add((Component)this.getCM01Radar(), null);
            this.pM01SeaMap.add((Component)this.getCM01Fired(), null);
            this.pM01SeaMap.add((Component)this.getCM01Fog(), null);
            this.pM01SeaMap.add((Component)this.getSM01StatusBar(), null);
            this.pM01SeaMap.add((Component)this.getTfM01Name(), null);
            this.pM01SeaMap.add((Component)this.getBM01Close(), null);
            this.pM01SeaMap.add((Component)this.getTfM01RepeatTime(), null);
            this.pM01SeaMap.add((Component)this.getCbM01Kennung(), null);
            this.pM01SeaMap.add((Component)this.getTfM01FireMark(), null);
            this.pM01SeaMap.add((Component)this.getCM01IconVisible(), null);
        }
        return this.pM01SeaMap;
    }

    private JComboBox getCbM01TypeOfMark() {
        if (this.cbM01TypeOfMark == null) {
            this.cbM01TypeOfMark = new JComboBox();
            this.cbM01TypeOfMark.addItem("Not set");
            this.cbM01TypeOfMark.addItem("Port");
            this.cbM01TypeOfMark.addItem("Starboard");
            this.cbM01TypeOfMark.addItem("Preferred Port");
            this.cbM01TypeOfMark.addItem("Preferred Starboard");
            this.cbM01TypeOfMark.addItem("Safe Water");
            this.cbM01TypeOfMark.addItem("Cardinal North");
            this.cbM01TypeOfMark.addItem("Cardinal East");
            this.cbM01TypeOfMark.addItem("Cardinal South");
            this.cbM01TypeOfMark.addItem("Cardinal West");
            this.cbM01TypeOfMark.addItem("Isolated Danger");
            this.cbM01TypeOfMark.addItem("Special Purpose");
            this.cbM01TypeOfMark.setBounds(new Rectangle(50, 25, 150, 25));
            this.cbM01TypeOfMark.setEditable(false);
            this.cbM01TypeOfMark.setFont(new Font("Dialog", 0, 12));
            this.cbM01TypeOfMark.setEnabled(true);
            this.cbM01TypeOfMark.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int type = SmpDialogAction.this.cbM01TypeOfMark.getSelectedIndex();
                    if (SmpDialogAction.this.buoy == null) {
                        SmpDialogAction.this.buoy = new BuoyUkn(SmpDialogAction.this.dia, "Seamark not set");
                        return;
                    }
                    if (type == 0 || type == SmpDialogAction.this.buoy.getBuoyIndex()) {
                        return;
                    }
                    Node n = SmpDialogAction.this.buoy.getNode();
                    if (n == null) {
                        return;
                    }
                    switch (type) {
                        case 0: {
                            if (!(SmpDialogAction.this.buoy instanceof BuoyUkn)) {
                                SmpDialogAction.this.buoy = new BuoyUkn(SmpDialogAction.this.dia, "Seamark not set");
                            }
                            SmpDialogAction.this.buoy.setBuoyIndex(type);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            if (SmpDialogAction.this.buoy instanceof BuoyLat) break;
                            SmpDialogAction.this.buoy = new BuoyLat(SmpDialogAction.this.dia, n);
                            break;
                        }
                        case 5: {
                            if (SmpDialogAction.this.buoy instanceof BuoySaw) break;
                            SmpDialogAction.this.buoy = new BuoySaw(SmpDialogAction.this.dia, n);
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            if (SmpDialogAction.this.buoy instanceof BuoyCard) break;
                            SmpDialogAction.this.buoy = new BuoyCard(SmpDialogAction.this.dia, n);
                            break;
                        }
                        case 10: {
                            if (SmpDialogAction.this.buoy instanceof BuoyIsol) break;
                            SmpDialogAction.this.buoy = new BuoyIsol(SmpDialogAction.this.dia, n);
                            break;
                        }
                        case 11: {
                            if (SmpDialogAction.this.buoy instanceof BuoySpec) break;
                            SmpDialogAction.this.buoy = new BuoySpec(SmpDialogAction.this.dia, n);
                            break;
                        }
                        default: {
                            if (SmpDialogAction.this.buoy instanceof BuoyUkn) break;
                            SmpDialogAction.this.buoy = new BuoyUkn(SmpDialogAction.this.dia, "Not Implemented");
                        }
                    }
                    SmpDialogAction.this.buoy.setBuoyIndex(type);
                    SmpDialogAction.this.buoy.refreshStyles();
                    SmpDialogAction.this.buoy.refreshLights();
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cbM01TypeOfMark;
    }

    private JToggleButton getTbM01Region() {
        if (this.tbM01Region == null) {
            this.tbM01Region = new JToggleButton();
            this.tbM01Region.setBounds(new Rectangle(60, 55, 80, 25));
            this.tbM01Region.setFont(new Font("Dialog", 0, 12));
            this.tbM01Region.setEnabled(false);
            if (Main.pref.get("tomsplugin.IALA").equals("B")) {
                this.tbM01Region.setSelected(true);
                this.tbM01Region.setText("IALA-B");
            } else {
                this.tbM01Region.setSelected(false);
                this.tbM01Region.setText("IALA-A");
            }
            this.tbM01Region.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.tbM01Region.isSelected()) {
                        SmpDialogAction.this.buoy.setRegion(true);
                        SmpDialogAction.this.tbM01Region.setText("IALA-B");
                    } else {
                        SmpDialogAction.this.buoy.setRegion(false);
                        SmpDialogAction.this.tbM01Region.setText("IALA-A");
                    }
                }
            });
        }
        return this.tbM01Region;
    }

    private JComboBox getCbM01StyleOfMark() {
        if (this.cbM01StyleOfMark == null) {
            this.cbM01StyleOfMark = new JComboBox();
            this.cbM01StyleOfMark.setBounds(new Rectangle(50, 85, 150, 25));
            this.cbM01StyleOfMark.setFont(new Font("Dialog", 0, 12));
            this.cbM01StyleOfMark.setEnabled(true);
            this.cbM01StyleOfMark.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int style = SmpDialogAction.this.cbM01StyleOfMark.getSelectedIndex();
                    if (SmpDialogAction.this.buoy != null && style != SmpDialogAction.this.buoy.getStyleIndex()) {
                        SmpDialogAction.this.buoy.setStyleIndex(style);
                        SmpDialogAction.this.buoy.paintSign();
                    }
                }
            });
        }
        return this.cbM01StyleOfMark;
    }

    private JButton getBM01Save() {
        if (this.bM01Save == null) {
            this.bM01Save = new JButton();
            this.bM01Save.setBounds(new Rectangle(120, 290, 80, 20));
            this.bM01Save.setText("Save");
            this.bM01Save.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SmpDialogAction.this.cM01IconVisible.setIcon(new ImageIcon(this.getClass().getResource("/images/Auge.png")));
                    SmpDialogAction.this.cM01IconVisible.setSelected(true);
                    SmpDialogAction.this.buoy.saveSign();
                }
            });
        }
        return this.bM01Save;
    }

    private JCheckBox getCM01TopMark() {
        if (this.cM01TopMark == null) {
            this.cM01TopMark = new JCheckBox();
            this.cM01TopMark.setBounds(new Rectangle(20, 190, 90, 20));
            this.cM01TopMark.setFont(new Font("Dialog", 0, 12));
            this.cM01TopMark.setText("Topmark");
            this.cM01TopMark.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setTopMark(SmpDialogAction.this.cM01TopMark.isSelected());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cM01TopMark;
    }

    private JCheckBox getCM01Radar() {
        if (this.cM01Radar == null) {
            this.cM01Radar = new JCheckBox();
            this.cM01Radar.setBounds(new Rectangle(140, 190, 70, 20));
            this.cM01Radar.setFont(new Font("Dialog", 0, 12));
            this.cM01Radar.setEnabled(false);
            this.cM01Radar.setText("Radar");
        }
        return this.cM01Radar;
    }

    private JCheckBox getCM01Fired() {
        if (this.cM01Fired == null) {
            this.cM01Fired = new JCheckBox();
            this.cM01Fired.setBounds(new Rectangle(20, 230, 70, 20));
            this.cM01Fired.setFont(new Font("Dialog", 0, 12));
            this.cM01Fired.setText("Lighted");
            this.cM01Fired.setEnabled(false);
            this.cM01Fired.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setFired(SmpDialogAction.this.cM01Fired.isSelected());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cM01Fired;
    }

    private JCheckBox getCM01Fog() {
        if (this.cM01Fog == null) {
            this.cM01Fog = new JCheckBox();
            this.cM01Fog.setBounds(new Rectangle(20, 210, 90, 20));
            this.cM01Fog.setFont(new Font("Dialog", 0, 12));
            this.cM01Fog.setEnabled(false);
            this.cM01Fog.setText("Foghorn");
        }
        return this.cM01Fog;
    }

    private JTextField getSM01StatusBar() {
        if (this.sM01StatusBar == null) {
            this.sM01StatusBar = new JTextField();
            this.sM01StatusBar.setBounds(new Rectangle(7, 319, 340, 20));
            this.sM01StatusBar.setBackground(SystemColor.activeCaptionBorder);
        }
        return this.sM01StatusBar;
    }

    private JTextField getTfM01Name() {
        if (this.tfM01Name == null) {
            this.tfM01Name = new JTextField();
            this.tfM01Name.setBounds(new Rectangle(50, 120, 175, 20));
            this.tfM01Name.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    SmpDialogAction.this.buoy.setName(SmpDialogAction.this.tfM01Name.getText());
                }
            });
        }
        return this.tfM01Name;
    }

    private JButton getBM01Close() {
        if (this.bM01Close == null) {
            this.bM01Close = new JButton();
            this.bM01Close.setBounds(new Rectangle(20, 290, 80, 20));
            this.bM01Close.setText("Close");
            this.bM01Close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.obuoy != null) {
                        SmpDialogAction.this.PicRebuild();
                    }
                    DataSet.selListeners.remove(SmpDialogAction.this.SmpListener);
                    SmpDialogAction.this.Selection = null;
                    SmpDialogAction.this.SmpItem.setEnabled(true);
                    SmpDialogAction.this.onode = null;
                    SmpDialogAction.this.dM01SeaMap.dispose();
                }
            });
        }
        return this.bM01Close;
    }

    private JTextField getTfM01RepeatTime() {
        if (this.tfM01RepeatTime == null) {
            this.tfM01RepeatTime = new JTextField();
            this.tfM01RepeatTime.setBounds(new Rectangle(290, 230, 30, 20));
            this.tfM01RepeatTime.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String s = SmpDialogAction.this.tfM01RepeatTime.getText();
                    SmpDialogAction.this.buoy.setLightPeriod(s);
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
            this.tfM01RepeatTime.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    String s = SmpDialogAction.this.tfM01RepeatTime.getText();
                    SmpDialogAction.this.buoy.setLightPeriod(s);
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.tfM01RepeatTime;
    }

    private JComboBox getCbM01Kennung() {
        if (this.cbM01Kennung == null) {
            this.cbM01Kennung = new JComboBox();
            this.cbM01Kennung.setBounds(new Rectangle(160, 230, 70, 20));
            this.cbM01Kennung.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String g = "";
                    String c = "";
                    String it = (String)SmpDialogAction.this.cbM01Kennung.getSelectedItem();
                    if (it == null) {
                        return;
                    }
                    if (it.compareTo("Not set") == 0) {
                        return;
                    }
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    int i1 = it.indexOf("(");
                    int i2 = it.indexOf(")", i1);
                    if (i1 >= 0) {
                        c = it.substring(0, i1);
                        if (i1 >= 0) {
                            g = it.substring(i1 + 1, i2);
                        }
                    }
                    if (it.contains("+")) {
                        i1 = it.indexOf("+");
                        i2 = it.length();
                        c = c.equals("") ? it : c + it.substring(i1, i2);
                    }
                    if (c.equals("")) {
                        c = it;
                    }
                    SmpDialogAction.this.buoy.setLightChar(c);
                    SmpDialogAction.this.buoy.setLightGroup(g);
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cbM01Kennung;
    }

    private JTextField getTfM01FireMark() {
        if (this.tfM01FireMark == null) {
            this.tfM01FireMark = new JTextField();
            this.tfM01FireMark.setBounds(new Rectangle(240, 160, 100, 20));
            this.tfM01FireMark.setEditable(false);
        }
        return this.tfM01FireMark;
    }

    private JCheckBox getCM01IconVisible() {
        if (this.cM01IconVisible == null) {
            this.cM01IconVisible = new JCheckBox();
            this.cM01IconVisible.setBounds(new Rectangle(310, 290, 30, 21));
            this.cM01IconVisible.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/AugeN.png")));
            this.cM01IconVisible.setSelected(false);
            this.cM01IconVisible.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Node n = null;
                    DataSet ds = Main.main.getCurrentDataSet();
                    if (SmpDialogAction.this.buoy != null) {
                        n = SmpDialogAction.this.buoy.getNode();
                    }
                    if (SmpDialogAction.this.cM01IconVisible.isSelected()) {
                        SmpDialogAction.this.cM01IconVisible.setIcon(new ImageIcon(this.getClass().getResource("/images/AugeN.png")));
                        if (n != null) {
                            ChangePropertyCommand c;
                            if (n.getKeys().containsKey("seamark")) {
                                SmpDialogAction.this.smb = (String)n.getKeys().get("seamark");
                                c = new ChangePropertyCommand((OsmPrimitive)n, "seamark", null);
                                c.executeCommand();
                                ds.fireSelectionChanged();
                                SmpDialogAction.this.obuoy = SmpDialogAction.this.buoy;
                            }
                            if (n.getKeys().containsKey("seamark:type")) {
                                SmpDialogAction.this.smt = (String)n.getKeys().get("seamark:type");
                                c = new ChangePropertyCommand((OsmPrimitive)n, "seamark:type", null);
                                c.executeCommand();
                                ds.fireSelectionChanged();
                                SmpDialogAction.this.obuoy = SmpDialogAction.this.buoy;
                            }
                        }
                    } else {
                        SmpDialogAction.this.cM01IconVisible.setIcon(new ImageIcon(this.getClass().getResource("/images/Auge.png")));
                        SmpDialogAction.this.PicRebuild();
                        SmpDialogAction.this.obuoy = null;
                    }
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cM01IconVisible;
    }
}

