/*
 * Decompiled with CFR 0.152.
 */
package CreateGridOfWaysPlugin;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class CreateGridOfWaysAction
extends JosmAction {
    public CreateGridOfWaysAction() {
        super(I18n.tr((String)"Create grid of ways"), "creategridofways", I18n.tr((String)"Forms a grid of ways in base to two existing that have various nodes and one in common"), Shortcut.registerShortcut((String)"tools:CreateGridOfWays", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Create grid of ways")}), (int)71, (int)3, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        int c;
        Collection sel = Main.main.getCurrentDataSet().getSelected();
        LinkedList nodesWay1 = new LinkedList();
        LinkedList nodesWay2 = new LinkedList();
        if (sel.size() != 2 || !(sel.toArray()[0] instanceof Way) || !(sel.toArray()[1] instanceof Way)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Select two ways with a node in common"));
            return;
        }
        nodesWay1.addAll(((Way)sel.toArray()[0]).getNodes());
        nodesWay2.addAll(((Way)sel.toArray()[1]).getNodes());
        Node nodeCommon = null;
        for (Node n : nodesWay1) {
            for (Node m : nodesWay2) {
                if (!n.equals((Object)m)) continue;
                if (nodeCommon != null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Select two ways with alone a node in common"));
                    return;
                }
                nodeCommon = n;
            }
        }
        Way[] w2 = new Way[nodesWay2.size() - 1];
        for (int c2 = 0; c2 < w2.length; ++c2) {
            w2[c2] = new Way();
        }
        Way[] w1 = new Way[nodesWay1.size() - 1];
        for (int c3 = 0; c3 < w1.length; ++c3) {
            w1[c3] = new Way();
        }
        LinkedList<AddCommand> cmds = new LinkedList<AddCommand>();
        int c1 = 0;
        for (Node n1 : nodesWay1) {
            double latDif = n1.getCoor().lat() - nodeCommon.getCoor().lat();
            double lonDif = n1.getCoor().lon() - nodeCommon.getCoor().lon();
            int c2 = 0;
            for (Node n2 : nodesWay2) {
                if (n1.equals((Object)nodeCommon) && n2.equals((Object)nodeCommon)) continue;
                if (n2.equals((Object)nodeCommon)) {
                    w1[c1].addNode(n1);
                    continue;
                }
                if (n1.equals((Object)nodeCommon)) {
                    w2[c2++].addNode(n2);
                    continue;
                }
                Node nodeOfGrid = new Node(new LatLon(n2.getCoor().lat() + latDif, n2.getCoor().lon() + lonDif));
                cmds.add(new AddCommand((OsmPrimitive)nodeOfGrid));
                w1[c1].addNode(nodeOfGrid);
                w2[c2++].addNode(nodeOfGrid);
            }
            if (n1.equals((Object)nodeCommon)) continue;
            ++c1;
        }
        for (c = 0; c < w1.length; ++c) {
            cmds.add(new AddCommand((OsmPrimitive)w1[c]));
        }
        for (c = 0; c < w2.length; ++c) {
            cmds.add(new AddCommand((OsmPrimitive)w2[c]));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Create a grid of ways"), cmds));
        Main.map.repaint();
    }
}

