/*
 * Decompiled with CFR 0.152.
 */
package touchscreenhelper;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.tools.I18n;

public class BrowseAction
extends MapMode
implements MouseListener,
MouseMotionListener {
    private EastNorth mousePosMove;
    private boolean movementInPlace = false;

    public BrowseAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Browse"), "browse", I18n.tr((String)"Browse map with left button"), mapFrame, Cursor.getPredefinedCursor(13));
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
    }

    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) != 1024) {
            this.endMovement();
            return;
        }
        if (this.mousePosMove == null) {
            this.startMovement(e);
        }
        EastNorth center = Main.map.mapView.getCenter();
        EastNorth mouseCenter = Main.map.mapView.getEastNorth(e.getX(), e.getY());
        Main.map.mapView.zoomTo(new EastNorth(this.mousePosMove.east() + center.east() - mouseCenter.east(), this.mousePosMove.north() + center.north() - mouseCenter.north()));
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.startMovement(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.endMovement();
        }
    }

    private void startMovement(MouseEvent e) {
        if (this.movementInPlace) {
            return;
        }
        this.movementInPlace = true;
        this.mousePosMove = Main.map.mapView.getEastNorth(e.getX(), e.getY());
    }

    private void endMovement() {
        if (!this.movementInPlace) {
            return;
        }
        this.movementInPlace = false;
        this.mousePosMove = null;
    }
}

