/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.pnm;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.formats.pnm.PNMWriter;

public class PPMWriter
extends PNMWriter {
    public PPMWriter(boolean RAWBITS) {
        super(RAWBITS);
    }

    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        os.write(80);
        os.write(this.RAWBITS ? 54 : 51);
        os.write(32);
        int width = src.getWidth();
        int height = src.getHeight();
        os.write(("" + width).getBytes());
        os.write(32);
        os.write(("" + height).getBytes());
        os.write(32);
        os.write("255".getBytes());
        os.write(10);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = src.getRGB(x, y);
                int red = 0xFF & argb >> 16;
                int green = 0xFF & argb >> 8;
                int blue = 0xFF & argb >> 0;
                if (this.RAWBITS) {
                    os.write((byte)red);
                    os.write((byte)green);
                    os.write((byte)blue);
                    continue;
                }
                os.write(("" + red).getBytes());
                os.write(32);
                os.write(("" + green).getBytes());
                os.write(32);
                os.write(("" + blue).getBytes());
                os.write(32);
            }
        }
    }
}

