/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import reverter.ChangesetReverter;

public class ChangesetIdQuery
extends ExtendedDialog {
    private JFormattedTextField tcid = new JFormattedTextField(NumberFormat.getInstance());
    private ButtonGroup bgRevertType = new ButtonGroup();
    private JRadioButton rbFull = new JRadioButton(I18n.tr((String)"Revert changeset fully"));
    private JRadioButton rbSelection = new JRadioButton(I18n.tr((String)"Revert selection only"));
    private JRadioButton rbSelectionUndelete = new JRadioButton(I18n.tr((String)"Revert selection and restore deleted objects"));

    public int getChangesetId() {
        try {
            return NumberFormat.getInstance().parse(this.tcid.getText()).intValue();
        }
        catch (ParseException e) {
            return 0;
        }
    }

    public ChangesetReverter.RevertType getRevertType() {
        if (this.rbFull.isSelected()) {
            return ChangesetReverter.RevertType.FULL;
        }
        if (this.rbSelection.isSelected()) {
            return ChangesetReverter.RevertType.SELECTION;
        }
        if (this.rbSelectionUndelete.isSelected()) {
            return ChangesetReverter.RevertType.SELECTION_WITH_UNDELETE;
        }
        return null;
    }

    public ChangesetIdQuery() {
        super(Main.parent, I18n.tr((String)"Revert changeset"), new String[]{I18n.tr((String)"Revert"), I18n.tr((String)"Cancel")}, true);
        this.contentInsets = new Insets(10, 10, 10, 5);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(new JLabel(I18n.tr((String)"Changeset id:")));
        panel.add((Component)this.tcid, GBC.eol().fill(2));
        this.bgRevertType.add(this.rbFull);
        this.bgRevertType.add(this.rbSelection);
        this.bgRevertType.add(this.rbSelectionUndelete);
        this.rbFull.setSelected(true);
        panel.add((Component)this.rbFull, GBC.eol().insets(0, 10, 0, 0).fill(2));
        panel.add((Component)this.rbSelection, GBC.eol().fill(2));
        panel.add((Component)this.rbSelectionUndelete, GBC.eol().fill(2));
        this.setContent(panel);
        this.setupDialog();
    }
}

