/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.remotecontrol.handler;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandler;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandlerErrorException;
import org.openstreetmap.josm.tools.I18n;

public class LoadAndZoomHandler
extends RequestHandler {
    public static final String command = "load_and_zoom";
    public static final String command2 = "zoom";
    public static final String loadDataPermissionKey = "remotecontrol.permission.load-data";
    public static final boolean loadDataPermissionDefault = true;
    public static final String changeSelectionPermissionKey = "remotecontrol.permission.change-selection";
    public static final boolean changeSelectionPermissionDefault = true;
    public static final String changeViewportPermissionKey = "remotecontrol.permission.change-viewport";
    public static final boolean changeViewportPermissionDefault = true;

    public String getPermissionMessage() {
        return I18n.tr((String)"Remote Control has been asked to load data from the API.") + "<br>" + I18n.tr((String)"Request details: {0}", (Object[])new Object[]{this.request});
    }

    protected String[] getMandatoryParams() {
        return new String[]{"bottom", "top", "left", "right"};
    }

    protected void handleRequest() throws RequestHandlerErrorException {
        DownloadOsmTask osmTask = new DownloadOsmTask();
        double minlat = 0.0;
        double maxlat = 0.0;
        double minlon = 0.0;
        double maxlon = 0.0;
        try {
            minlat = Double.parseDouble((String)this.args.get("bottom"));
            maxlat = Double.parseDouble((String)this.args.get("top"));
            minlon = Double.parseDouble((String)this.args.get("left"));
            maxlon = Double.parseDouble((String)this.args.get("right"));
            if (command.equals(this.myCommand)) {
                if (!Main.pref.getBoolean(loadDataPermissionKey, true)) {
                    System.out.println("RemoteControl: download forbidden by preferences");
                } else {
                    Area present = null;
                    Area toDownload = null;
                    DataSet ds = Main.main.getCurrentDataSet();
                    if (ds != null) {
                        present = ds.getDataSourceArea();
                    }
                    if (present != null && !present.isEmpty()) {
                        toDownload = new Area(new Rectangle2D.Double(minlon, minlat, maxlon - minlon, maxlat - minlat));
                        toDownload.subtract(present);
                        if (!toDownload.isEmpty()) {
                            Rectangle2D downloadBounds = toDownload.getBounds2D();
                            minlat = downloadBounds.getMinY();
                            minlon = downloadBounds.getMinX();
                            maxlat = downloadBounds.getMaxY();
                            maxlon = downloadBounds.getMaxX();
                        }
                    }
                    if (toDownload != null && toDownload.isEmpty()) {
                        System.out.println("RemoteControl: no download necessary");
                    } else {
                        Future future = osmTask.download(false, new Bounds(minlat, minlon, maxlat, maxlon), null);
                        Main.worker.submit((Runnable)new PostDownloadHandler((DownloadTask)osmTask, future));
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("RemoteControl: Error parsing load_and_zoom remote control request:");
            ex.printStackTrace();
            throw new RequestHandlerErrorException();
        }
        if (this.args.containsKey("select") && Main.pref.getBoolean(changeSelectionPermissionKey, true)) {
            final String selection = (String)this.args.get("select");
            Main.worker.execute(new Runnable(){

                public void run() {
                    HashSet<Long> ways = new HashSet<Long>();
                    HashSet<Long> nodes = new HashSet<Long>();
                    HashSet<Long> relations = new HashSet<Long>();
                    HashSet<Object> newSel = new HashSet<Object>();
                    for (String item : selection.split(",")) {
                        if (item.startsWith("way")) {
                            ways.add(Long.parseLong(item.substring(3)));
                            continue;
                        }
                        if (item.startsWith("node")) {
                            nodes.add(Long.parseLong(item.substring(4)));
                            continue;
                        }
                        if (item.startsWith("relation")) {
                            relations.add(Long.parseLong(item.substring(8)));
                            continue;
                        }
                        if (item.startsWith("rel")) {
                            relations.add(Long.parseLong(item.substring(3)));
                            continue;
                        }
                        System.out.println("RemoteControl: invalid selection '" + item + "' ignored");
                    }
                    DataSet ds = Main.main.getCurrentDataSet();
                    if (ds == null) {
                        return;
                    }
                    for (Way w : ds.getWays()) {
                        if (!ways.contains(w.getId())) continue;
                        newSel.add(w);
                    }
                    for (Node n : ds.getNodes()) {
                        if (!nodes.contains(n.getId())) continue;
                        newSel.add(n);
                    }
                    for (Relation r : ds.getRelations()) {
                        if (!relations.contains(r.getId())) continue;
                        newSel.add(r);
                    }
                    ds.setSelected(newSel);
                    if (Main.pref.getBoolean(LoadAndZoomHandler.changeViewportPermissionKey, true)) {
                        new AutoScaleAction("selection").actionPerformed(null);
                    }
                }
            });
        } else if (Main.pref.getBoolean(changeViewportPermissionKey, true)) {
            this.zoom(minlat, maxlat, minlon, maxlon);
        }
    }

    protected void zoom(double minlat, double maxlat, double minlon, double maxlon) {
        final Bounds bounds = new Bounds(new LatLon(minlat, minlon), new LatLon(maxlat, maxlon));
        if (Main.map != null && Main.map.mapView != null) {
            Main.worker.execute(new Runnable(){

                public void run() {
                    BoundingXYVisitor bbox = new BoundingXYVisitor();
                    bbox.visit(bounds);
                    Main.map.mapView.recalculateCenterScale(bbox);
                }
            });
        }
    }
}

