/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionLegRole;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.tools.I18n;

public class TurnRestrictionLegSplitRequiredError
extends Issue {
    private TurnRestrictionLegRole role;
    private Way from;
    private Way to;
    private Node interesect;

    public TurnRestrictionLegSplitRequiredError(IssuesModel parent, TurnRestrictionLegRole role, Way from, Way to, Node intersect) {
        super(parent, Severity.ERROR);
        this.role = role;
        this.from = from;
        this.to = to;
        this.interesect = intersect;
        this.actions.add(new SplitAction());
    }

    public String getText() {
        String msg = null;
        switch (this.role) {
            case FROM: {
                msg = I18n.tr((String)"The OSM way <span class=\"object-name\">{0}</span> with role <tt>{1}</tt> should be split at node <span class=\"object-name\">{2}</span> where it connects to way <span class=\"object-name\">{3}</span>.", (Object[])new Object[]{this.from.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.role.getOsmRole(), this.interesect.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.to.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
                break;
            }
            case TO: {
                msg = I18n.tr((String)"The OSM way <span class=\"object-name\">{0}</span> with role <tt>{1}</tt> should be split at node <span class=\"object-name\">{2}</span> where it connects to way <span class=\"object-name\">{3}</span>.", (Object[])new Object[]{this.to.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.role.getOsmRole(), this.interesect.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.from.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
            }
        }
        return msg;
    }

    class SplitAction
    extends AbstractAction {
        public SplitAction() {
            this.putValue("Name", I18n.tr((String)"Split now"));
            this.putValue("ShortDescription", I18n.tr((String)"Splits the way"));
        }

        public void actionPerformed(ActionEvent e) {
            Way way = null;
            switch (TurnRestrictionLegSplitRequiredError.this.role) {
                case FROM: {
                    way = TurnRestrictionLegSplitRequiredError.this.from;
                    break;
                }
                case TO: {
                    way = TurnRestrictionLegSplitRequiredError.this.to;
                }
            }
            SplitWayAction.SplitWayResult result = SplitWayAction.split((OsmDataLayer)TurnRestrictionLegSplitRequiredError.this.parent.getEditorModel().getLayer(), (Way)way, Collections.singletonList(TurnRestrictionLegSplitRequiredError.this.interesect), Collections.emptyList());
            if (result != null) {
                Main.main.undoRedo.add(result.getCommand());
            }
        }
    }
}

