/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.routes.paint;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.util.BitSet;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.routes.ConvertedWay;
import org.openstreetmap.josm.plugins.routes.RouteDefinition;
import org.openstreetmap.josm.plugins.routes.RouteLayer;
import org.openstreetmap.josm.plugins.routes.paint.AbstractLinePainter;

public class NarrowLinePainter
extends AbstractLinePainter {
    private static final float LINE_WIDTH = 5.0f;
    private final RouteLayer layer;

    public NarrowLinePainter(RouteLayer layer) {
        this.layer = layer;
    }

    public void drawWay(ConvertedWay way, MapView mapView, Graphics2D g) {
        List<Node> nodes = way.getNodes();
        BitSet routes = way.getRoutes();
        if (nodes.size() < 2) {
            return;
        }
        double width = 5.0;
        double shift = (double)(-(5.0f * (float)routes.cardinality()) / 2.0f) + width / 2.0;
        for (int k = 0; k < routes.length(); ++k) {
            if (!routes.get(k)) continue;
            RouteDefinition route = this.layer.getRoutes().get(k);
            g.setColor(route.getColor());
            g.setStroke(new BasicStroke((float)width));
            g.draw(this.getPath(g, mapView, nodes, shift));
            shift += width + 2.0;
        }
    }
}

