/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.alg.BellmanFordIterator;
import org.jgrapht.alg.BellmanFordPathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BellmanFordShortestPath<V, E> {
    protected Graph<V, E> graph;
    protected V startVertex;
    private BellmanFordIterator<V, E> iter;
    private int nMaxHops;
    private int passNumber;

    public BellmanFordShortestPath(Graph<V, E> graph, V v) {
        this(graph, v, graph.vertexSet().size() - 1);
    }

    public BellmanFordShortestPath(Graph<V, E> graph, V v, int n) {
        this.startVertex = v;
        this.nMaxHops = n;
        this.graph = graph;
        this.passNumber = 1;
    }

    public double getCost(V v) {
        this.lazyCalculate();
        this.assertGetPath(v);
        return this.iter.getPathElement(v).getCost();
    }

    public List<E> getPathEdgeList(V v) {
        this.assertGetPath(v);
        this.lazyCalculate();
        if (this.iter.getPathElement(v) == null) {
            return null;
        }
        return this.createPath(v);
    }

    private void assertGetPath(V v) {
        if (v.equals(this.startVertex)) {
            throw new IllegalArgumentException("The end vertex is the same as the start vertex!");
        }
        if (!this.graph.containsVertex(v)) {
            throw new IllegalArgumentException("Graph must contain the end vertex!");
        }
    }

    private List<E> createPath(V v) {
        BellmanFordPathElement<V, E> bellmanFordPathElement = this.iter.getPathElement(v);
        return bellmanFordPathElement.createEdgeListPath();
    }

    private void lazyCalculate() {
        if (this.iter == null) {
            this.iter = new BellmanFordIterator<V, E>(this.graph, this.startVertex);
        }
        while (this.passNumber <= this.nMaxHops && this.iter.hasNext()) {
            this.iter.next();
            ++this.passNumber;
        }
    }

    public static <V, E> List<E> findPathBetween(Graph<V, E> graph, V v, V v2) {
        BellmanFordShortestPath<V, E> bellmanFordShortestPath = new BellmanFordShortestPath<V, E>(graph, v);
        return bellmanFordShortestPath.getPathEdgeList(v2);
    }
}

