/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing;

import com.innovant.josm.jrt.core.PreferencesKeys;
import com.innovant.josm.jrt.osm.OsmEdge;
import com.innovant.josm.plugin.routing.RoutingModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.ImageProvider;

public class RoutingLayer
extends Layer {
    static Logger logger = Logger.getLogger(RoutingLayer.class);
    private static final double ARROW_PHI = Math.toRadians(20.0);
    private RoutingModel routingModel;
    private Icon startIcon;
    private Icon middleIcon;
    private Icon endIcon;
    private OsmDataLayer dataLayer;

    public RoutingLayer(String name, OsmDataLayer dataLayer) {
        super(name);
        logger.debug("Creating Routing Layer...");
        if (this.startIcon == null) {
            this.startIcon = ImageProvider.get((String)"routing", (String)"startflag");
        }
        if (this.middleIcon == null) {
            this.middleIcon = ImageProvider.get((String)"routing", (String)"middleflag");
        }
        if (this.endIcon == null) {
            this.endIcon = ImageProvider.get((String)"routing", (String)"endflag");
        }
        this.dataLayer = dataLayer;
        this.routingModel = new RoutingModel(dataLayer.data);
        logger.debug("Routing Layer created.");
    }

    public RoutingModel getRoutingModel() {
        return this.routingModel;
    }

    public OsmDataLayer getDataLayer() {
        return this.dataLayer;
    }

    public final Node getNearestHighwayNode(Point p) {
        Node nearest = null;
        double minDist = 0.0;
        for (Way w : this.dataLayer.data.getWays()) {
            if (w.isDeleted() || w.isIncomplete() || w.get("highway") == null) continue;
            for (Node n : w.getNodes()) {
                Point P;
                double dist;
                if (n.isDeleted() || n.isIncomplete() || !((dist = p.distanceSq(P = Main.map.mapView.getPoint(n))) < (double)NavigatableComponent.snapDistance) || nearest != null && !(dist < minDist)) continue;
                nearest = n;
                minDist = dist;
            }
        }
        return nearest;
    }

    public Icon getIcon() {
        ImageIcon icon = ImageProvider.get((String)"layer", (String)"routing_small");
        return icon;
    }

    public Object getInfoComponent() {
        String info = "<html><body>Graph Vertex: " + this.routingModel.routingGraph.getVertexCount() + "<br/>" + "Graph Edges: " + this.routingModel.routingGraph.getEdgeCount() + "<br/>" + "</body>" + "</html>";
        return info;
    }

    public Action[] getMenuEntries() {
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(LayerListDialog.getInstance().createShowHideLayerAction());
        components.add(LayerListDialog.getInstance().createDeleteLayerAction());
        components.add(Layer.SeparatorLayerAction.INSTANCE);
        components.add(new RenameLayerAction(this.getAssociatedFile(), (Layer)this));
        components.add(Layer.SeparatorLayerAction.INSTANCE);
        components.add(new LayerListPopup.InfoAction((Layer)this));
        return components.toArray(new Action[0]);
    }

    public String getToolTipText() {
        String tooltip = this.routingModel.routingGraph.getVertexCount() + " vertices, " + this.routingModel.routingGraph.getEdgeCount() + " edges";
        return tooltip;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        String colorString;
        boolean isActiveLayer = mv.getActiveLayer().equals((Object)this);
        List<Node> nodes = this.routingModel.getSelectedNodes();
        if (nodes == null || nodes.size() == 0) {
            logger.debug("no nodes selected");
            return;
        }
        if (isActiveLayer) {
            if (Main.pref.hasKey(PreferencesKeys.KEY_ACTIVE_ROUTE_COLOR.key)) {
                colorString = Main.pref.get(PreferencesKeys.KEY_ACTIVE_ROUTE_COLOR.key);
            } else {
                colorString = ColorHelper.color2html((Color)Color.RED);
                Main.pref.put(PreferencesKeys.KEY_ACTIVE_ROUTE_COLOR.key, colorString);
            }
        } else if (Main.pref.hasKey(PreferencesKeys.KEY_INACTIVE_ROUTE_COLOR.key)) {
            colorString = Main.pref.get(PreferencesKeys.KEY_INACTIVE_ROUTE_COLOR.key);
        } else {
            colorString = ColorHelper.color2html((Color)Color.decode("#dd2222"));
            Main.pref.put(PreferencesKeys.KEY_INACTIVE_ROUTE_COLOR.key, colorString);
        }
        Color color = ColorHelper.html2color((String)colorString);
        String widthString = Main.pref.get(PreferencesKeys.KEY_ROUTE_WIDTH.key);
        if (widthString.length() == 0) {
            widthString = "8";
        }
        int width = Integer.parseInt(widthString);
        List<OsmEdge> routeEdges = this.routingModel.getRouteEdges();
        if (routeEdges != null) {
            for (OsmEdge edge : routeEdges) {
                this.drawEdge(g, mv, edge, color, width, true);
            }
        }
        Node node = nodes.get(0);
        Point screen = mv.getPoint(node);
        this.startIcon.paintIcon((Component)mv, g, screen.x - this.startIcon.getIconWidth() / 2, screen.y - this.startIcon.getIconHeight());
        for (int index = 1; index < nodes.size() - 1; ++index) {
            node = nodes.get(index);
            screen = mv.getPoint(node);
            this.middleIcon.paintIcon((Component)mv, g, screen.x - this.startIcon.getIconWidth() / 2, screen.y - this.middleIcon.getIconHeight());
        }
        if (nodes.size() > 1) {
            node = nodes.get(nodes.size() - 1);
            screen = mv.getPoint(node);
            this.endIcon.paintIcon((Component)mv, g, screen.x - this.startIcon.getIconWidth() / 2, screen.y - this.endIcon.getIconHeight());
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (Node node : this.routingModel.getSelectedNodes()) {
            v.visit(node);
        }
    }

    public void destroy() {
        this.routingModel.reset();
    }

    private void drawEdge(Graphics g, MapView mv, OsmEdge edge, Color col, int width, boolean showDirection) {
        g.setColor(col);
        Point from = mv.getPoint(edge.fromEastNorth());
        Point to = mv.getPoint(edge.toEastNorth());
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(width));
        g.drawLine(from.x, from.y, to.x, to.y);
        if (showDirection) {
            double t = Math.atan2(to.y - from.y, to.x - from.x) + Math.PI;
            g.drawLine(to.x, to.y, (int)((double)to.x + 10.0 * Math.cos(t - ARROW_PHI)), (int)((double)to.y + 10.0 * Math.sin(t - ARROW_PHI)));
            g.drawLine(to.x, to.y, (int)((double)to.x + 10.0 * Math.cos(t + ARROW_PHI)), (int)((double)to.y + 10.0 * Math.sin(t + ARROW_PHI)));
        }
        g2d.setStroke(oldStroke);
    }
}

