/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.remotecontrol;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandler;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandlerBadRequestException;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandlerErrorException;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandlerForbiddenException;
import org.openstreetmap.josm.plugins.remotecontrol.handler.AddNodeHandler;
import org.openstreetmap.josm.plugins.remotecontrol.handler.ImportHandler;
import org.openstreetmap.josm.plugins.remotecontrol.handler.LoadAndZoomHandler;
import org.openstreetmap.josm.plugins.remotecontrol.handler.VersionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestProcessor
extends Thread {
    public static final String PROTOCOLVERSION = "{\"protocolversion\": {\"major\": 1, \"minor\": 2}, \"application\": \"JOSM RemoteControl\"}";
    private Socket request;
    private static HashMap<String, Class<? extends RequestHandler>> handlers = new HashMap();

    public RequestProcessor(Socket request) {
        super("RemoteControl request processor");
        this.setDaemon(true);
        this.request = request;
    }

    public static void processRequest(Socket request) {
        RequestProcessor processor = new RequestProcessor(request);
        processor.start();
    }

    static void addRequestHandlerClass(String command, Class<? extends RequestHandler> handler) {
        RequestProcessor.addRequestHandlerClass(command, handler, false);
    }

    private static void addRequestHandlerClass(String command, Class<? extends RequestHandler> handler, boolean silent) {
        String commandWithSlash;
        if (command.charAt(0) == '/') {
            command = command.substring(1);
        }
        if (handlers.get(commandWithSlash = "/" + command) != null) {
            System.out.println("RemoteControl: ignoring duplicate command " + command + " with handler " + handler.getName());
        } else {
            if (!silent) {
                System.out.println("RemoteControl: adding command \"" + command + "\" (handled by " + handler.getSimpleName() + ")");
            }
            handlers.put(commandWithSlash, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        OutputStreamWriter out = null;
        try {
            int c;
            BufferedOutputStream raw = new BufferedOutputStream(this.request.getOutputStream());
            out = new OutputStreamWriter(raw);
            InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream(this.request.getInputStream()), "ASCII");
            StringBuffer requestLine = new StringBuffer();
            while (requestLine.length() < 1024 && (c = ((Reader)in).read()) != 13 && c != 10) {
                requestLine.append((char)c);
            }
            System.out.println("RemoteControl received: " + requestLine);
            String get = requestLine.toString();
            StringTokenizer st = new StringTokenizer(get);
            if (!st.hasMoreTokens()) {
                this.sendError(out);
                return;
            }
            String method = st.nextToken();
            if (!st.hasMoreTokens()) {
                this.sendError(out);
                return;
            }
            String url = st.nextToken();
            if (!method.equals("GET")) {
                this.sendNotImplemented(out);
                return;
            }
            String command = null;
            int questionPos = url.indexOf(63);
            command = questionPos < 0 ? url : url.substring(0, questionPos);
            Class<? extends RequestHandler> handlerClass = handlers.get(command);
            if (handlerClass == null) {
                this.sendBadRequest(out);
                return;
            }
            RequestHandler handler = handlerClass.newInstance();
            try {
                handler.setCommand(command);
                handler.setUrl(url);
                handler.checkPermission();
                handler.handle();
                this.sendHeader(out, "200 OK", handler.contentType, false);
                out.write("Content-length: " + handler.content.length() + "\r\n");
                out.write("\r\n");
                out.write(handler.content);
                ((Writer)out).flush();
                return;
            }
            catch (RequestHandlerErrorException ex) {
                this.sendError(out);
                return;
            }
            catch (RequestHandlerBadRequestException ex) {
                this.sendBadRequest(out);
                return;
            }
            catch (RequestHandlerForbiddenException ex) {
                this.sendForbidden(out);
                return;
            }
        }
        catch (IOException ioe) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.sendError(out);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
                return;
            }
        }
        finally {
            try {
                this.request.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void sendError(Writer out) throws IOException {
        this.sendHeader(out, "500 Internal Server Error", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Internal Error</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 500: Internal Server Error</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendNotImplemented(Writer out) throws IOException {
        this.sendHeader(out, "501 Not Implemented", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Not Implemented</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 501: Not Implemented</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendForbidden(Writer out) throws IOException {
        this.sendHeader(out, "403 Forbidden", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Forbidden</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 403: Forbidden</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendBadRequest(Writer out) throws IOException {
        this.sendHeader(out, "400 Bad Request", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Bad Request</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 400: Bad Request</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendHeader(Writer out, String status, String contentType, boolean endHeaders) throws IOException {
        out.write("HTTP/1.1 " + status + "\r\n");
        Date now = new Date();
        out.write("Date: " + now + "\r\n");
        out.write("Server: JOSM RemoteControl\r\n");
        out.write("Content-type: " + contentType + "\r\n");
        out.write("Access-Control-Allow-Origin: *\r\n");
        if (endHeaders) {
            out.write("\r\n");
        }
    }

    static {
        RequestProcessor.addRequestHandlerClass("load_and_zoom", LoadAndZoomHandler.class, true);
        RequestProcessor.addRequestHandlerClass("zoom", LoadAndZoomHandler.class, true);
        RequestProcessor.addRequestHandlerClass("add_node", AddNodeHandler.class, true);
        RequestProcessor.addRequestHandlerClass("import", ImportHandler.class, true);
        RequestProcessor.addRequestHandlerClass("version", VersionHandler.class, true);
    }
}

