/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb;

import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsbUploadHook
implements UploadHook {
    public boolean checkUpload(APIDataSet apiData) {
        boolean containsOsbData = this.checkOpenStreetBugs(apiData.getPrimitivesToAdd());
        containsOsbData |= this.checkOpenStreetBugs(apiData.getPrimitivesToUpdate());
        if (containsOsbData |= this.checkOpenStreetBugs(apiData.getPrimitivesToDelete())) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"<html>The selected data contains data from OpenStreetBugs.<br>You cannot upload this data. Maybe you have selected the wrong layer?"), I18n.tr((String)"Warning"), 2);
            return false;
        }
        return true;
    }

    private boolean checkOpenStreetBugs(Collection<OsmPrimitive> osmPrimitives) {
        for (OsmPrimitive osmPrimitive : osmPrimitives) {
            if (osmPrimitive.get("openstreetbug") == null) continue;
            return true;
        }
        return false;
    }
}

