/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.plugins.validator.util.NameVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePropertyKeyCommand
extends Command {
    private final List<OsmPrimitive> objects;
    private final String key;
    private final String newKey;

    public ChangePropertyKeyCommand(Collection<? extends OsmPrimitive> objects, String key, String newKey) {
        this.objects = new LinkedList<OsmPrimitive>(objects);
        this.key = key;
        this.newKey = newKey;
    }

    public boolean executeCommand() {
        if (!super.executeCommand()) {
            return false;
        }
        for (OsmPrimitive osm : this.objects) {
            if (!osm.hasKeys()) continue;
            osm.setModified(true);
            String oldValue = osm.get(this.key);
            osm.put(this.newKey, oldValue);
            osm.remove(this.key);
        }
        return true;
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.addAll(this.objects);
    }

    public JLabel getDescription() {
        String text = I18n.tr((String)"Replace \"{0}\" by \"{1}\" for", (Object[])new Object[]{this.key, this.newKey});
        if (this.objects.size() == 1) {
            NameVisitor v = new NameVisitor();
            this.objects.iterator().next().visit((Visitor)v);
            text = text + " " + I18n.tr((String)v.className) + " " + v.name;
        } else {
            text = text + " " + this.objects.size() + " " + I18n.trn((String)"object", (String)"objects", (long)this.objects.size());
        }
        return new JLabel(text, ImageProvider.get((String)"data", (String)"key"), 0);
    }

    public Collection<PseudoCommand> getChildren() {
        if (this.objects.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> children = new ArrayList<PseudoCommand>();
        final NameVisitor v = new NameVisitor();
        for (final OsmPrimitive osm : this.objects) {
            osm.visit((Visitor)v);
            children.add(new PseudoCommand(){

                public JLabel getDescription() {
                    return v.toLabel();
                }

                public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
                    return Collections.singleton(osm);
                }
            });
        }
        return children;
    }
}

