/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.photometricinterpreters;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public class PhotometricInterpreterBiLevel
extends PhotometricInterpreter {
    private final boolean invert;

    public PhotometricInterpreterBiLevel(int fBitsPerPixel, int fSamplesPerPixel, int[] fBitsPerSample, int Predictor, int width, int height, boolean invert) {
        super(fSamplesPerPixel, fBitsPerSample, Predictor, width, height);
        this.invert = invert;
    }

    public void interpretPixel(BufferedImage bi, int[] samples, int x, int y) throws ImageReadException, IOException {
        int sample = samples[0];
        if (this.invert) {
            sample = 255 - sample;
        }
        int red = sample;
        int green = sample;
        int blue = sample;
        int alpha = 255;
        int rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
        bi.setRGB(x, y, rgb);
    }
}

