/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.fieldtypes;

import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.util.Debug;

public class FieldTypeDouble
extends FieldType {
    public FieldTypeDouble() {
        super(12, 8, "Double");
    }

    public Object getSimpleValue(TiffField entry) {
        return "?";
    }

    public byte[] writeData(Object o, int byteOrder) throws ImageWriteException {
        if (o instanceof Double) {
            return this.convertDoubleToByteArray((Double)o, byteOrder);
        }
        if (o instanceof double[]) {
            double[] numbers = (double[])o;
            return this.convertDoubleArrayToByteArray(numbers, byteOrder);
        }
        if (o instanceof Double[]) {
            Double[] numbers = (Double[])o;
            double[] values = new double[numbers.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = numbers[i];
            }
            return this.convertDoubleArrayToByteArray(values, byteOrder);
        }
        throw new ImageWriteException("Invalid data: " + o + " (" + Debug.getType(o) + ")");
    }
}

