/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import public_transport.GTFSImporterAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTFSStopTableModel
extends DefaultTableModel
implements TableModelListener {
    private GTFSImporterAction controller = null;
    public Vector<Node> nodes = new Vector();
    public Vector<LatLon> coors = new Vector();
    private int idCol = -1;
    private int nameCol = -1;
    private int latCol = -1;
    private int lonCol = -1;

    public GTFSStopTableModel(GTFSImporterAction controller, String columnConfig) {
        String title;
        int pos = columnConfig.indexOf(44);
        int oldPos = 0;
        int i = 0;
        while (pos > -1) {
            title = columnConfig.substring(oldPos, pos);
            if ("stop_id".equals(title)) {
                this.idCol = i;
            } else if ("stop_name".equals(title)) {
                this.nameCol = i;
            } else if ("stop_lat".equals(title)) {
                this.latCol = i;
            } else if ("stop_lon".equals(title)) {
                this.lonCol = i;
            }
            ++i;
            oldPos = pos + 1;
            pos = columnConfig.indexOf(44, oldPos);
        }
        title = columnConfig.substring(oldPos);
        if ("stop_id".equals(title)) {
            this.idCol = i;
        } else if ("stop_name".equals(title)) {
            this.nameCol = i;
        } else if ("stop_lat".equals(title)) {
            this.latCol = i;
        } else if ("stop_lon".equals(title)) {
            this.lonCol = i;
        }
        this.controller = controller;
        this.addColumn("Id");
        this.addColumn("Name");
        this.addColumn("State");
        this.addTableModelListener(this);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void addRow(Object[] obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertRow(int insPos, Object[] obj) {
        throw new UnsupportedOperationException();
    }

    public void addRow(String s) {
        this.insertRow(-1, s, new Vector<Node>());
    }

    public void addRow(String s, Vector<Node> existingStops) {
        this.insertRow(-1, s, existingStops);
    }

    public void insertRow(int insPos, String s, Vector<Node> existingStops) {
        Node node2;
        Object[] buf = new String[]{"", "", "pending"};
        int pos = s.indexOf(44);
        int oldPos = 0;
        int i = 0;
        double lat = 0.0;
        double lon = 0.0;
        while (pos > -1) {
            if (i == this.idCol) {
                buf[0] = s.substring(oldPos, pos);
            } else if (i == this.nameCol) {
                buf[1] = s.substring(oldPos, pos);
            } else if (i == this.latCol) {
                lat = Double.parseDouble(s.substring(oldPos, pos));
            } else if (i == this.lonCol) {
                lon = Double.parseDouble(s.substring(oldPos, pos));
            }
            ++i;
            oldPos = pos + 1;
            pos = s.indexOf(44, oldPos);
        }
        if (i == this.idCol) {
            buf[0] = s.substring(oldPos);
        } else if (i == this.nameCol) {
            buf[1] = s.substring(oldPos);
        } else if (i == this.latCol) {
            lat = Double.parseDouble(s.substring(oldPos));
        } else if (i == this.lonCol) {
            lon = Double.parseDouble(s.substring(oldPos));
        }
        LatLon coor = new LatLon(lat, lon);
        if (Main.main.getCurrentDataSet() != null) {
            boolean inside = false;
            Iterator<Object> iter = Main.main.getCurrentDataSet().dataSources.iterator();
            while (iter.hasNext()) {
                if (!((DataSource)iter.next()).bounds.contains(coor)) continue;
                inside = true;
                break;
            }
            if (!inside) {
                buf[2] = "outside";
            }
        }
        boolean nearBusStop = false;
        for (Node node2 : existingStops) {
            if (!(coor.greatCircleDistance(node2.getCoor()) < 1000.0)) continue;
            nearBusStop = true;
            break;
        }
        if (insPos == -1) {
            if (nearBusStop || !"pending".equals(buf[2])) {
                this.nodes.addElement(null);
            } else {
                node2 = GTFSImporterAction.createNode(coor, buf[0], (String)buf[1]);
                this.nodes.addElement(node2);
                buf[2] = "added";
            }
            this.coors.addElement(coor);
            super.addRow(buf);
        } else {
            if (nearBusStop || !"pending".equals(buf[2])) {
                this.nodes.insertElementAt(null, insPos);
            } else {
                node2 = GTFSImporterAction.createNode(coor, buf[0], (String)buf[1]);
                this.nodes.insertElementAt(node2, insPos);
                buf[2] = "added";
            }
            this.coors.insertElementAt(coor, insPos);
            super.insertRow(insPos, buf);
        }
    }

    public void clear() {
        this.nodes.clear();
        super.setRowCount(0);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }
}

