/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.SeaMark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Buoy
extends SeaMark {
    private int BuoyIndex = 0;
    private int StyleIndex = 0;
    private boolean Region = false;
    private boolean Fired = false;
    private String LightChar = "";
    private String LightColour = "";
    private String LightGroup = "";
    private String Height = "";
    private String Range = "";
    private String LightPeriod = "";
    private Node Node = null;
    private boolean TopMark = false;
    protected SmpDialogAction dlg = null;

    public abstract void setLightColour();

    public int getBuoyIndex() {
        return this.BuoyIndex;
    }

    public void setBuoyIndex(int buoyIndex) {
        this.BuoyIndex = buoyIndex;
    }

    public int getStyleIndex() {
        return this.StyleIndex;
    }

    public void setStyleIndex(int styleIndex) {
        this.StyleIndex = styleIndex;
    }

    public boolean getRegion() {
        return this.Region;
    }

    public void setRegion(boolean region) {
        this.Region = region;
        this.dlg.tbM01Region.setSelected(region);
        this.dlg.tbM01Region.setText(region ? "IALA-B" : "IALA-A");
    }

    public boolean isFired() {
        return this.Fired;
    }

    public void setFired(boolean fired) {
        this.Fired = fired;
        this.dlg.cM01Fired.setSelected(fired);
    }

    public String getLightChar() {
        return this.LightChar;
    }

    public void setLightChar(String lightChar) {
        this.LightChar = lightChar;
    }

    public String getLightColour() {
        return this.LightColour;
    }

    public void setLightColour(String lightColour) {
        this.LightColour = lightColour;
    }

    public String getLightGroup() {
        return this.LightGroup;
    }

    public void setLightGroup(String lightGroup) {
        this.LightGroup = lightGroup;
    }

    protected void setLightGroup(Map<String, String> k) {
        String s = "";
        if (k.containsKey("seamark:light:group")) {
            this.LightGroup = s = k.get("seamark:light:group");
        }
    }

    public String getHeight() {
        return this.Height;
    }

    public void setHeight(String height) {
        this.Height = height;
    }

    public String getRange() {
        return this.Range;
    }

    public void setRange(String range) {
        this.Range = range;
    }

    public String getLightPeriod() {
        return this.LightPeriod;
    }

    public void setLightPeriod(String lightPeriod) {
        Pattern pat;
        Matcher matcher;
        String regex = "^[\\d\\s.]+$";
        if (lightPeriod.length() == 0) {
            lightPeriod = " ";
        }
        if ((matcher = (pat = Pattern.compile(regex)).matcher(lightPeriod)).find()) {
            this.LightPeriod = lightPeriod;
            this.setErrMsg(null);
        } else {
            this.setErrMsg("Must be a number");
            this.dlg.tfM01RepeatTime.requestFocus();
        }
    }

    protected void setLightPeriod(Map<String, String> k) {
        String s = "";
        if (k.containsKey("seamark:light:signal:period")) {
            this.LightPeriod = s = k.get("seamark:light:signal:period");
            return;
        }
        if (k.containsKey("seamark:light:period")) {
            this.LightPeriod = s = k.get("seamark:light:period");
            return;
        }
    }

    public Node getNode() {
        return this.Node;
    }

    public void setNode(Node node) {
        this.Node = node;
    }

    public boolean hasTopMark() {
        return this.TopMark;
    }

    public void setTopMark(boolean topMark) {
        this.TopMark = topMark;
        this.dlg.cM01TopMark.setSelected(topMark);
    }

    public SmpDialogAction getDlg() {
        return this.dlg;
    }

    public void setDlg(SmpDialogAction dlg) {
        this.dlg = dlg;
    }

    protected Buoy(SmpDialogAction dia) {
        this.dlg = dia;
    }

    @Override
    public void paintSign() {
        this.dlg.cbM01TypeOfMark.setEnabled(true);
        this.dlg.cbM01StyleOfMark.setEnabled(true);
        this.dlg.cbM01TypeOfMark.setSelectedIndex(this.getBuoyIndex());
        this.dlg.cbM01StyleOfMark.setSelectedIndex(this.getStyleIndex());
        this.dlg.cM01TopMark.setSelected(this.hasTopMark());
        this.dlg.cM01Fired.setSelected(this.isFired());
        this.dlg.tfM01RepeatTime.setText(this.LightPeriod);
        this.dlg.tfM01Name.setText(this.getName());
        if (this.isFired()) {
            String tmp = null;
            this.dlg.cbM01Kennung.setEnabled(true);
            String c = this.getLightChar();
            if (this.dlg.cbM01Kennung.getSelectedIndex() == 0) {
                this.dlg.tfM01RepeatTime.setEnabled(false);
            } else {
                this.dlg.tfM01RepeatTime.setEnabled(true);
            }
            if (c.contains("+")) {
                int i1 = c.indexOf("+");
                tmp = c.substring(i1, c.length());
                c = c.substring(0, i1);
            }
            if (this.getLightGroup() != "") {
                c = c + "(" + this.getLightGroup() + ")";
            }
            if (tmp != null) {
                c = c + tmp;
            }
            c = c + " " + this.getLightColour();
            String lp = this.getLightPeriod();
            if (lp != "" && lp != " ") {
                c = c + " " + lp + "s";
            }
            this.dlg.tfM01FireMark.setText(c);
        } else {
            this.dlg.tfM01RepeatTime.setEnabled(false);
            this.dlg.cbM01Kennung.setEnabled(false);
            this.dlg.tfM01FireMark.setText("");
        }
        this.dlg.bM01Save.setEnabled(true);
        this.dlg.lM01Icon01.setIcon(null);
    }

    public void saveSign(String type) {
        this.delSeaMarkKeys(this.Node);
        String str = this.dlg.tfM01Name.getText();
        if (str.compareTo("") != 0) {
            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:name", str));
        }
        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:type", type));
    }

    protected void saveLightData(String colour) {
        if (colour.equals("")) {
            return;
        }
        if (this.dlg.cM01Fired.isSelected()) {
            if (colour.equals("red")) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:colour", "red"));
                this.setLightColour("R");
            } else if (colour.equals("green")) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:colour", "green"));
                this.setLightColour("G");
            } else if (colour.equals("white")) {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:colour", "white"));
                this.setLightColour("W");
            }
            if (this.LightPeriod != "" && this.LightPeriod != " " && this.LightChar != "Q") {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:period", this.LightPeriod));
            }
            if (this.LightChar != "") {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:character", this.LightChar));
            }
            if (this.LightGroup != "") {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:light:group", this.LightGroup));
            }
        }
    }

    protected void saveTopMarkData(String shape, String colour) {
        if (this.dlg.cM01TopMark.isSelected()) {
            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:topmark:shape", shape));
            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)this.Node, "seamark:topmark:colour", colour));
        }
    }

    public void refreshStyles() {
    }

    public void refreshLights() {
    }
}

