/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Hash;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateNode
extends Test {
    protected static int DUPLICATE_NODE = 1;
    protected static int DUPLICATE_NODE_MIXED = 2;
    protected static int DUPLICATE_NODE_HIGHWAY = 3;
    protected static int DUPLICATE_NODE_RAILWAY = 3;
    protected static int DUPLICATE_NODE_WATERWAY = 4;
    protected static int DUPLICATE_NODE_BOUNDARY = 5;
    protected static int DUPLICATE_NODE_POWER = 6;
    Storage<Object> potentialDuplicates;

    public DuplicateNode() {
        super(I18n.tr((String)"Duplicated nodes") + ".", I18n.tr((String)"This test checks that there are no nodes at the very same location."));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.potentialDuplicates = new Storage((Hash)new NodeHash());
    }

    @Override
    public void endTest() {
        for (Object v : this.potentialDuplicates) {
            if (v instanceof Node) continue;
            List nodes = (List)v;
            this.errors.addAll(this.buildTestErrors(this, nodes));
        }
        super.endTest();
        this.potentialDuplicates = null;
    }

    public List<TestError> buildTestErrors(Test parentTest, List<Node> nodes) {
        ArrayList<TestError> errors = new ArrayList<TestError>();
        Bag<Map, Node> bag = new Bag<Map, Node>();
        for (Node n : nodes) {
            bag.add(n.getKeys(), n);
        }
        HashMap<String, Boolean> typeMap = new HashMap<String, Boolean>();
        String[] types = new String[]{"none", "highway", "railway", "waterway", "boundary", "power"};
        Iterator it = bag.keySet().iterator();
        while (it.hasNext()) {
            String msg;
            Map tagSet = (Map)it.next();
            if (bag.get(tagSet).size() <= 1) continue;
            for (String type : types) {
                typeMap.put(type, false);
            }
            for (OsmPrimitive p : bag.get(tagSet)) {
                if (p.getType() != OsmPrimitiveType.NODE) continue;
                Node n = (Node)p;
                List lp = n.getReferrers();
                for (OsmPrimitive sp : lp) {
                    if (sp.getType() != OsmPrimitiveType.WAY) continue;
                    boolean typed = false;
                    Way w = (Way)sp;
                    Map keys = w.getKeys();
                    for (String type : typeMap.keySet()) {
                        if (!keys.containsKey(type)) continue;
                        typeMap.put(type, true);
                        typed = true;
                    }
                    if (typed) continue;
                    typeMap.put("none", true);
                }
            }
            int nbType = 0;
            for (String type : typeMap.keySet()) {
                if (!((Boolean)typeMap.get(type)).booleanValue()) continue;
                ++nbType;
            }
            if (nbType > 1) {
                msg = I18n.marktr((String)"Mixed type duplicated nodes");
                errors.add(new TestError(parentTest, Severity.ERROR, I18n.tr((String)"Duplicated nodes"), I18n.tr((String)msg), msg, DUPLICATE_NODE_MIXED, bag.get(tagSet)));
            } else if (((Boolean)typeMap.get("highway")).booleanValue()) {
                msg = I18n.marktr((String)"Highway duplicated nodes");
                errors.add(new TestError(parentTest, Severity.ERROR, I18n.tr((String)"Duplicated nodes"), I18n.tr((String)msg), msg, DUPLICATE_NODE_HIGHWAY, bag.get(tagSet)));
            } else if (((Boolean)typeMap.get("railway")).booleanValue()) {
                msg = I18n.marktr((String)"Railway duplicated nodes");
                errors.add(new TestError(parentTest, Severity.ERROR, I18n.tr((String)"Duplicated nodes"), I18n.tr((String)msg), msg, DUPLICATE_NODE_RAILWAY, bag.get(tagSet)));
            } else if (((Boolean)typeMap.get("waterway")).booleanValue()) {
                msg = I18n.marktr((String)"Waterway duplicated nodes");
                errors.add(new TestError(parentTest, Severity.ERROR, I18n.tr((String)"Duplicated nodes"), I18n.tr((String)msg), msg, DUPLICATE_NODE_WATERWAY, bag.get(tagSet)));
            } else if (((Boolean)typeMap.get("boundary")).booleanValue()) {
                msg = I18n.marktr((String)"Boundary duplicated nodes");
                errors.add(new TestError(parentTest, Severity.ERROR, I18n.tr((String)"Duplicated nodes"), I18n.tr((String)msg), msg, DUPLICATE_NODE_BOUNDARY, bag.get(tagSet)));
            } else if (((Boolean)typeMap.get("power")).booleanValue()) {
                msg = I18n.marktr((String)"Power duplicated nodes");
                errors.add(new TestError(parentTest, Severity.ERROR, I18n.tr((String)"Duplicated nodes"), I18n.tr((String)msg), msg, DUPLICATE_NODE_POWER, bag.get(tagSet)));
            } else {
                errors.add(new TestError(parentTest, Severity.ERROR, I18n.tr((String)"Duplicated nodes"), DUPLICATE_NODE, bag.get(tagSet)));
            }
            it.remove();
        }
        if (!bag.isEmpty()) {
            ArrayList duplicates = new ArrayList();
            for (List l : bag.values()) {
                duplicates.addAll(l);
            }
            if (duplicates.size() > 1) {
                errors.add(new TestError(parentTest, Severity.WARNING, I18n.tr((String)"Nodes at same position"), DUPLICATE_NODE, duplicates));
            }
        }
        return errors;
    }

    @Override
    public void visit(Node n) {
        if (n.isUsable()) {
            if (this.potentialDuplicates.get((Object)n) == null) {
                this.potentialDuplicates.put((Object)n);
            } else if (this.potentialDuplicates.get((Object)n) instanceof Node) {
                Node n1 = (Node)this.potentialDuplicates.get((Object)n);
                ArrayList<Node> nodes = new ArrayList<Node>(2);
                nodes.add(n1);
                nodes.add(n);
                this.potentialDuplicates.put(nodes);
            } else if (this.potentialDuplicates.get((Object)n) instanceof List) {
                List nodes = (List)this.potentialDuplicates.get((Object)n);
                nodes.add(n);
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        LinkedList<? extends OsmPrimitive> sel = new LinkedList<OsmPrimitive>(testError.getPrimitives());
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>(OsmPrimitive.getFilteredList(sel, Node.class));
        Node target = null;
        for (Node n : nodes) {
            if (n.isNew()) continue;
            target = n;
            break;
        }
        if (target == null) {
            target = (Node)nodes.iterator().next();
        }
        if (DuplicateNode.checkAndConfirmOutlyingDeletes(nodes)) {
            return MergeNodesAction.mergeNodes((OsmDataLayer)Main.main.getEditLayer(), nodes, (Node)target);
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        return testError.getTester() instanceof DuplicateNode;
    }

    private static boolean checkAndConfirmOutlyingDeletes(LinkedHashSet<Node> del) {
        Area a = Main.main.getCurrentDataSet().getDataSourceArea();
        if (a != null) {
            for (Node osm : del) {
                Node n;
                if (!(osm instanceof Node) || osm.isNew() || a.contains((Point2D)(n = osm).getCoor())) continue;
                JPanel msg = new JPanel(new GridBagLayout());
                msg.add(new JLabel("<html>" + I18n.tr((String)"You are about to delete nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you do not see) might use them.<br>Do you really want to delete?") + "</html>"));
                return ConditionalOptionPaneUtil.showConfirmationDialog((String)"delete_outside_nodes", (Component)Main.parent, (Object)msg, (String)I18n.tr((String)"Delete confirmation"), (int)0, (int)3, (int)0);
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeHash
    implements Hash<Object, Object> {
        private NodeHash() {
        }

        private LatLon getLatLon(Object o) {
            if (o instanceof Node) {
                return ((Node)o).getCoor().getRoundedToOsmPrecision();
            }
            if (o instanceof List) {
                return ((Node)((List)o).get(0)).getCoor().getRoundedToOsmPrecision();
            }
            throw new AssertionError();
        }

        public boolean equals(Object k, Object t) {
            return this.getLatLon(k).equals((Object)this.getLatLon(t));
        }

        public int getHashCode(Object k) {
            return this.getLatLon(k).hashCode();
        }
    }
}

