/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui.databaseeditors;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.gui.databaseeditors.EditorFactory;
import org.openstreetmap.josm.plugins.czechaddress.gui.utils.UniversalListRenderer;
import org.openstreetmap.josm.tools.ImageProvider;

public class StreetEditor
extends ExtendedDialog {
    Street street = null;
    AddressElement parent = null;
    private House selectedHouse = null;
    private JButton houseEditButton;
    private JList houseList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JPanel mainPanel;
    private JTextField nameField;
    private JButton parentEditButton;
    private JTextField parentField;

    public StreetEditor(Street street) {
        super(Main.parent, "Upravit ulici", new String[]{"OK", "Zru\u0161it"}, true);
        this.initComponents();
        this.street = street;
        this.parent = street.getParent();
        if (this.parent != null) {
            this.parentField.setText(this.parent.getName());
        } else {
            this.parentField.setEnabled(false);
        }
        this.parentEditButton.setIcon(ImageProvider.get((String)"actions", (String)"edit.png"));
        this.parentEditButton.setText("");
        this.parentEditButton.setEnabled(EditorFactory.isEditable(this.parent));
        this.nameField.setText(street.getName());
        this.houseList.setModel(new DefaultComboBoxModel<Object>(street.getHouses().toArray()));
        this.houseList.setCellRenderer(new UniversalListRenderer());
        this.houseEditButton.setIcon(ImageProvider.get((String)"actions", (String)"edit.png"));
        this.houseEditButton.setText("");
        this.houseListChanged(null);
        this.setContent(this.mainPanel);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setupDialog();
    }

    public String getStreetName() {
        return this.nameField.getText();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.parentField = new JTextField();
        this.jLabel2 = new JLabel();
        this.nameField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.houseList = new JList();
        this.parentEditButton = new JButton();
        this.houseEditButton = new JButton();
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.jLabel1.setText("Rodi\u010d:");
        this.jTextField1.setText("jTextField1");
        this.parentField.setEditable(false);
        this.jLabel2.setText("Jm\u00e9no:");
        this.jLabel3.setText("Domy:");
        this.houseList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                StreetEditor.this.houseListChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.houseList);
        this.parentEditButton.setText("    ");
        this.parentEditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StreetEditor.this.parentEditButtonActionPerformed(evt);
            }
        });
        this.houseEditButton.setText("    ");
        this.houseEditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StreetEditor.this.houseEditButtonActionPerformed(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.nameField, GroupLayout.Alignment.LEADING, -1, 344, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, mainPanelLayout.createSequentialGroup().addComponent(this.parentField, -1, 310, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parentEditButton)).addGroup(GroupLayout.Alignment.LEADING, mainPanelLayout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 308, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.houseEditButton).addGap(2, 2, 2)))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.parentField, -2, -1, -2).addComponent(this.parentEditButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameField, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.houseEditButton).addComponent(this.jScrollPane1, -2, 77, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add(this.mainPanel);
    }

    private void houseListChanged(ListSelectionEvent evt) {
        this.selectedHouse = (House)this.houseList.getSelectedValue();
        this.houseEditButton.setEnabled(EditorFactory.isEditable(this.selectedHouse));
    }

    private void houseEditButtonActionPerformed(ActionEvent evt) {
        assert (this.selectedHouse != null);
        if (EditorFactory.editHouse(this.selectedHouse)) {
            this.houseList.setModel(new DefaultComboBoxModel<Object>(this.street.getHouses().toArray()));
        }
    }

    private void parentEditButtonActionPerformed(ActionEvent evt) {
        assert (this.parent != null);
        if (EditorFactory.edit(this.parent)) {
            this.parentField.setText(this.parent.getName());
        }
    }
}

