/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui.databaseeditors;

import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Suburb;
import org.openstreetmap.josm.plugins.czechaddress.gui.databaseeditors.HouseEditor;
import org.openstreetmap.josm.plugins.czechaddress.gui.databaseeditors.StreetEditor;
import org.openstreetmap.josm.plugins.czechaddress.gui.databaseeditors.SuburbEditor;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;

public abstract class EditorFactory {
    public static boolean isEditable(AddressElement elem) {
        return elem instanceof House || elem instanceof Street || elem instanceof Suburb;
    }

    public static boolean edit(AddressElement elem) {
        if (elem instanceof House) {
            return EditorFactory.editHouse((House)elem);
        }
        if (elem instanceof Street) {
            return EditorFactory.editStreet((Street)elem);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean editStreet(Street street) {
        StreetEditor dialog = new StreetEditor(street);
        dialog.setVisible(true);
        if (dialog.getValue() == 1) {
            Reasoner r;
            Reasoner reasoner = r = Reasoner.getInstance();
            synchronized (reasoner) {
                r.openTransaction();
                street.setName(dialog.getStreetName());
                for (House house : street.getHouses()) {
                    r.update(house);
                }
                r.update(street);
                r.closeTransaction();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean editHouse(House house) {
        HouseEditor dialog = new HouseEditor(house);
        dialog.setVisible(true);
        if (dialog.getValue() == 1) {
            Reasoner r;
            Reasoner reasoner = r = Reasoner.getInstance();
            synchronized (reasoner) {
                r.openTransaction();
                house.setCP(dialog.getCP());
                house.setCO(dialog.getCO());
                r.update(house);
                r.closeTransaction();
            }
            return true;
        }
        return false;
    }

    public static boolean editSuburb(Suburb suburb) {
        SuburbEditor dialog = new SuburbEditor(suburb);
        dialog.setVisible(true);
        if (dialog.getValue() == 1) {
            suburb.setName(dialog.getSuburbName());
            return true;
        }
        return false;
    }
}

