/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.addressdatabase;

import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.czechaddress.StringUtils;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ParentResolver;
import org.openstreetmap.josm.plugins.czechaddress.proposal.Proposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddressElement
implements Comparable<AddressElement> {
    protected String name;
    protected AddressElement parent = null;

    public AddressElement(String name) {
        if (name == null) {
            throw new NullPointerException("You must specify the name of this AddressElement");
        }
        this.name = name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public static String getName(Object o) {
        if (o instanceof OsmPrimitive) {
            return AddressElement.getName((OsmPrimitive)o);
        }
        if (o instanceof AddressElement) {
            return ((AddressElement)o).getName();
        }
        return null;
    }

    public static String getName(OsmPrimitive prim) {
        String cp = prim.get("addr:conscriptionnumber");
        String co = prim.get("addr:streetnumber");
        String street = prim.get("addr:street");
        String city = prim.get("addr:city");
        String name = prim.get("name");
        String result = "";
        if (name != null) {
            result = result + name;
        }
        if (street != null) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + street;
        } else if (city != null) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + city;
        }
        if (cp != null) {
            if (result.length() > 0) {
                result = result + " ";
            }
            result = result + cp;
        }
        if (co != null) {
            if (co != null) {
                result = result + "/";
            }
            result = result + co;
        }
        if (prim instanceof Node) {
            Node node = (Node)prim;
            result = result + " " + StringUtils.latLonToString(node.getCoor());
        } else if (prim instanceof Way) {
            Way way = (Way)prim;
            result = way.getNodesCount() > 0 ? result + " " + StringUtils.latLonToString(way.firstNode().getCoor()) : result + " empty way";
        }
        if (prim.isDeleted()) {
            result = result + " DEL";
        }
        return result;
    }

    public void setParent(AddressElement parent) {
        this.parent = parent;
    }

    public AddressElement getParent() {
        return this.parent;
    }

    public boolean equals(AddressElement elem) {
        if (elem == null) {
            return false;
        }
        return this.name.equals(elem.name) && this.parent == elem.parent;
    }

    public String toString() {
        return this.parent == null ? this.getName() : this.getName() + ", " + this.parent.toString();
    }

    public static int matchField(String elemValue, String primValue) {
        if (elemValue == null) {
            return 0;
        }
        if (primValue == null) {
            return -1;
        }
        return primValue.trim().toUpperCase().equals(elemValue.trim().toUpperCase()) ? 1 : -1;
    }

    public static int matchFieldAbbrev(String elemValue, String primValue) {
        if (elemValue == null) {
            return 0;
        }
        if (primValue == null) {
            return -1;
        }
        return StringUtils.matchAbbrev(primValue, elemValue) ? 1 : -1;
    }

    protected int[] getFieldMatchList(OsmPrimitive primitive) {
        int[] result = new int[]{0};
        return result;
    }

    protected int[] getAdditionalFieldMatchList(OsmPrimitive primitive) {
        int[] result = new int[]{0};
        return result;
    }

    public List<Proposal> getDiff(OsmPrimitive prim) {
        return null;
    }

    public int getQ(OsmPrimitive primitive) {
        int[] fieldMatches = this.getFieldMatchList(primitive);
        assert (fieldMatches.length > 0);
        int minVal = fieldMatches[0];
        int maxVal = fieldMatches[0];
        for (int i = 1; i < fieldMatches.length; ++i) {
            if (minVal > fieldMatches[i]) {
                minVal = fieldMatches[i];
            }
            if (maxVal >= fieldMatches[i]) continue;
            maxVal = fieldMatches[i];
        }
        assert (Math.abs(minVal) <= 1);
        assert (Math.abs(maxVal) <= 1);
        if (maxVal <= 0) {
            return 0;
        }
        switch (minVal * maxVal) {
            case -1: {
                return 1;
            }
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public int compareTo(AddressElement elem) {
        ParentResolver r1 = new ParentResolver(this);
        ParentResolver r2 = new ParentResolver(elem);
        int retVal = r1.compareTo(r2);
        if (retVal != 0) {
            return retVal;
        }
        return this.toString().compareTo(elem.toString());
    }
}

