/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ohe.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.ohe.OpeningTimeUtils;
import org.openstreetmap.josm.plugins.ohe.gui.OheDialogPanel;
import org.openstreetmap.josm.plugins.ohe.gui.TimeRect;
import org.openstreetmap.josm.plugins.ohe.parser.OpeningTimeCompiler;

public class OheEditor
extends JPanel
implements MouseListener,
MouseMotionListener {
    final OheDialogPanel dialog;
    private final JScrollPane scrollPane;
    final JPanel contentPanel;
    ArrayList<TimeRect> timeRects;
    private final int dayAxisHeight = 20;
    private final int timeAxisWidth = 45;
    private int day0 = -1;
    private int minute0;
    private int day1;
    private int minute1;
    private int xDragStart;
    private int yDragStart;

    public OheEditor(OheDialogPanel oheDialogPanel) {
        this.dialog = oheDialogPanel;
        this.contentPanel = new JPanel(){

            public void setSize(Dimension d) {
                super.setSize(d);
                OheEditor.this.repositionTimeRects();
            }

            public void paintComponent(Graphics g) {
                if (OheEditor.this.isEnabled()) {
                    int i;
                    g.setColor(Color.WHITE);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    for (i = 1; i < 24; ++i) {
                        if (i % 3 == 0) {
                            g.setColor(Color.BLACK);
                        } else {
                            g.setColor(Color.LIGHT_GRAY);
                        }
                        g.drawLine(0, OheEditor.this.getMinutePosition(i * 60), this.getWidth(), OheEditor.this.getMinutePosition(i * 60));
                    }
                    g.setColor(Color.BLACK);
                    for (i = 1; i < 7; ++i) {
                        g.drawLine(OheEditor.this.getDayPosition(i), 0, OheEditor.this.getDayPosition(i), this.getHeight());
                    }
                    if (OheEditor.this.day0 >= 0) {
                        Graphics2D g2D = (Graphics2D)g;
                        int day2 = Math.min(OheEditor.this.day0, OheEditor.this.day1);
                        int day3 = Math.max(OheEditor.this.day0, OheEditor.this.day1);
                        int minute2 = Math.min(OheEditor.this.minute0, OheEditor.this.minute1);
                        int minute3 = Math.max(OheEditor.this.minute0, OheEditor.this.minute1);
                        Rectangle bounds = OheEditor.this.getPanelBoundsForTimeinterval(day2, day3 + 1, minute2, minute3);
                        TimeRect.drawTimeRect(g2D, bounds, minute2 == minute3, false);
                    }
                } else {
                    g.setColor(Color.LIGHT_GRAY);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            }
        };
        this.contentPanel.addMouseListener(this);
        this.contentPanel.addMouseMotionListener(this);
        this.contentPanel.setLayout(null);
        this.contentPanel.setPreferredSize(new Dimension(180, 384));
        this.initTimeRects();
        this.scrollPane = new JScrollPane(20, 30);
        this.scrollPane.setViewportView(this.contentPanel);
        this.scrollPane.setColumnHeaderView(new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(OheEditor.this.contentPanel.getWidth(), 20);
            }

            public void paintComponent(Graphics g) {
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.BLACK);
                for (int i = 0; i < 7; ++i) {
                    if (i > 0) {
                        g.drawLine(OheEditor.this.getDayPosition(i) + 1, 0, OheEditor.this.getDayPosition(i) + 1, this.getHeight());
                    }
                    String text = OpeningTimeCompiler.WEEKDAYS[i];
                    g.drawString(text, (int)((double)OheEditor.this.getDayPosition((double)i + 0.5) - (double)g.getFontMetrics().stringWidth(text) * 0.5), (int)(10.0 + (double)g.getFontMetrics().getHeight() * 0.35));
                }
            }
        });
        this.scrollPane.setRowHeaderView(new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(45, OheEditor.this.contentPanel.getHeight());
            }

            public void paintComponent(Graphics g) {
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                for (int i = 1; i < 24; ++i) {
                    if (i % 3 == 0) {
                        g.setColor(Color.BLACK);
                        String text = (i < 10 ? "0" + i : Integer.valueOf(i)) + ":00";
                        g.drawString(text, 35 - g.getFontMetrics().stringWidth(text), OheEditor.this.getMinutePosition(i * 60) + (int)((double)g.getFontMetrics().getHeight() * 0.35));
                    } else {
                        g.setColor(Color.LIGHT_GRAY);
                    }
                    g.drawLine(this.getWidth() - 4, OheEditor.this.getMinutePosition(i * 60) + 1, this.getWidth(), OheEditor.this.getMinutePosition(i * 60) + 1);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
    }

    public void initTimeRects() {
        ArrayList<int[]> time;
        this.contentPanel.removeAll();
        try {
            time = this.dialog.getTime();
        }
        catch (Exception exc) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        this.timeRects = new ArrayList();
        if (time != null) {
            for (int[] timeRectValues : time) {
                int day0 = timeRectValues[0];
                int day1 = timeRectValues[1];
                int minute0 = timeRectValues[2];
                int minute1 = timeRectValues[3];
                TimeRect timeRect = new TimeRect(this, day0, day1, minute0, minute1);
                this.timeRects.add(timeRect);
                this.contentPanel.add(timeRect);
            }
        }
        this.repositionTimeRects();
        this.repaint();
    }

    protected void repositionTimeRects() {
        if (this.timeRects != null) {
            for (TimeRect timeRect : this.timeRects) {
                timeRect.reposition();
            }
        }
    }

    public Rectangle getPanelBoundsForTimeinterval(int dayStart, int dayEnd, int minutesStart, int minutesEnd) {
        int x = this.getDayPosition(dayStart);
        int y = this.getMinutePosition(minutesStart);
        int width = this.getDayPosition(dayEnd) - this.getDayPosition(dayStart);
        int height = this.getMinutePosition(minutesEnd) - this.getMinutePosition(minutesStart);
        if (Main.isOpenjdk) {
            ++x;
            ++y;
        }
        if (minutesStart == minutesEnd) {
            return new Rectangle(x, y - 2 - 5, width, height + 5 + 10);
        }
        return new Rectangle(x, y, width, height + 1);
    }

    public double getDayWidth() {
        return (double)(this.contentPanel.getWidth() - 1) / 7.0;
    }

    public int getDayPosition(double d) {
        return (int)(d * this.getDayWidth());
    }

    public double getMinuteHeight() {
        return (double)(this.contentPanel.getHeight() - 1) / 1440.0;
    }

    public int getMinutePosition(int minute) {
        return (int)((double)minute * this.getMinuteHeight());
    }

    public void removeTimeRect(TimeRect timeRectToRemove) {
        this.timeRects.remove(timeRectToRemove);
        this.contentPanel.remove(timeRectToRemove);
        this.dialog.updateValueField(this.timeRects);
        this.repaint();
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        this.day0 = (int)Math.floor((double)evt.getX() / this.getDayWidth());
        this.minute0 = (int)Math.floor((double)evt.getY() / (this.getMinuteHeight() * 15.0)) * 15;
        this.day1 = this.day0;
        this.minute1 = this.minute0;
        this.xDragStart = evt.getX();
        this.yDragStart = evt.getY();
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.xDragStart == -1 || Math.abs(evt.getX() - this.xDragStart) + Math.abs(evt.getY() - this.yDragStart) > 5) {
            int day2 = Math.min(this.day0, this.day1);
            int day3 = Math.max(this.day0, this.day1);
            int minute2 = Math.min(this.minute0, this.minute1);
            int minute3 = Math.max(this.minute0, this.minute1);
            TimeRect timeRect = new TimeRect(this, day2, day3, minute2, minute3);
            this.timeRects.add(timeRect);
            this.contentPanel.add(timeRect);
            timeRect.reposition();
            this.dialog.updateValueField(this.timeRects);
            this.day0 = -1;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.xDragStart == -1 || Math.abs(evt.getX() - this.xDragStart) + Math.abs(evt.getY() - this.yDragStart) > 5) {
            this.xDragStart = -1;
            this.day1 = (int)Math.floor((double)evt.getX() / this.getDayWidth());
            this.minute1 = (int)Math.floor((double)evt.getY() / (this.getMinuteHeight() * 15.0)) * 15;
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent evt) {
        this.mousePositionChanged(evt.getX(), evt.getY());
    }

    public void mousePositionChanged(int x, int y) {
        int actualDay = (int)Math.floor((double)x / this.getDayWidth());
        int minutes = (int)Math.floor((double)y / (this.getMinuteHeight() * 15.0)) * 15;
        actualDay = Math.max(0, Math.min(6, actualDay));
        minutes = Math.max(0, Math.min(1440, minutes));
        this.dialog.setMousePositionText(OpeningTimeCompiler.WEEKDAYS[actualDay] + " " + OpeningTimeUtils.timeString(minutes));
    }
}

