/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ohe;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.ohe.gui.OheDialogPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OhePlugin
extends Plugin {
    private final String[][] TAG_EDIT_STRINGS = new String[][]{{"opening_hours", ".*", "opening_hours"}, {"collection_times", ".*", "collection_times"}, {"collection_times:local", ".*", "collection_times:local"}, {"lit", ".*", "lit"}, {"amenity", "post_box", "collection_times"}, {"amenity", ".*", "opening_hours"}, {"shop", ".*", "opening_hours"}, {"highway", ".*", "lit"}};

    public OhePlugin(PluginInformation info) {
        super(info);
        Main.main.menu.toolsMenu.add((Action)((Object)new OheMenuAction()));
    }

    private String[] editTimeTags(Map<String, String> keyValueMap) {
        String selectedKey = "";
        selectedKey = this.tagChooseDialog(keyValueMap);
        if (selectedKey == null) {
            return null;
        }
        String value = keyValueMap.containsKey(selectedKey) ? keyValueMap.get(selectedKey) : "";
        OheDialogPanel panel = new OheDialogPanel(this, selectedKey, value);
        JOptionPane optionPane = new JOptionPane(panel, -1, 2);
        JDialog dlg = optionPane.createDialog(Main.parent, I18n.tr((String)"Edit"));
        dlg.setResizable(true);
        dlg.setVisible(true);
        Object answer = optionPane.getValue();
        if (!(answer == null || answer == JOptionPane.UNINITIALIZED_VALUE || answer instanceof Integer && (Integer)answer != 0)) {
            return panel.getChangedKeyValuePair();
        }
        return null;
    }

    private String tagChooseDialog(Map<String, String> keyValueMap) {
        String preSelectedKey = this.getPreSelectedKey(keyValueMap);
        int preSelectedRow = -1;
        Object[][] rowData = new String[keyValueMap.size()][2];
        int cnt = 0;
        for (Object key : keyValueMap.keySet().toArray()) {
            rowData[cnt][0] = key.toString();
            rowData[cnt][1] = keyValueMap.get(key);
            if (key.toString().equals(preSelectedKey)) {
                preSelectedRow = cnt;
            }
            ++cnt;
        }
        final JTable table = new JTable(rowData, new String[]{"key", "value"}){

            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;
            }
        };
        table.setSelectionMode(0);
        JScrollPane sp = new JScrollPane(20, 30);
        sp.setViewportView(table);
        final JTextField tf = new JTextField();
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("edit")) {
                    table.setEnabled(true);
                    tf.setEnabled(false);
                } else if (e.getActionCommand().equals("new")) {
                    table.setEnabled(false);
                    tf.setEnabled(true);
                }
            }
        };
        JRadioButton editButton = new JRadioButton("edit existing tag");
        editButton.setActionCommand("edit");
        editButton.addActionListener(al);
        JRadioButton newButton = new JRadioButton("edit new tag");
        newButton.setActionCommand("new");
        newButton.addActionListener(al);
        ButtonGroup group = new ButtonGroup();
        group.add(newButton);
        group.add(editButton);
        if (preSelectedRow != -1) {
            table.setEnabled(true);
            tf.setEnabled(false);
            table.setRowSelectionInterval(preSelectedRow, preSelectedRow);
            editButton.setSelected(true);
        } else {
            table.setEnabled(false);
            tf.setEnabled(true);
            tf.setText(preSelectedKey);
            newButton.setSelected(true);
        }
        JPanel dlgPanel = new JPanel(new GridBagLayout());
        dlgPanel.add((Component)editButton, GBC.std().anchor(10));
        dlgPanel.add((Component)sp, GBC.eol().fill(1));
        dlgPanel.add((Component)newButton, GBC.std().anchor(10));
        dlgPanel.add((Component)tf, GBC.eol().fill(2));
        JOptionPane optionPane = new JOptionPane(dlgPanel, 3, 2);
        JDialog dlg = optionPane.createDialog(Main.parent, I18n.tr((String)"Choose key"));
        dlg.pack();
        dlg.setResizable(true);
        dlg.setVisible(true);
        Object answer = optionPane.getValue();
        if (answer != null && answer != JOptionPane.UNINITIALIZED_VALUE && answer instanceof Integer && (Integer)answer == 0) {
            if (editButton.isSelected() && table.getSelectedRow() != -1) {
                return rowData[table.getSelectedRow()][0];
            }
            if (newButton.isSelected()) {
                return tf.getText();
            }
        }
        return null;
    }

    private String getPreSelectedKey(Map<String, String> keyValueMap) {
        for (String[] pattern : this.TAG_EDIT_STRINGS) {
            Pattern keyPattern = Pattern.compile(pattern[0]);
            Pattern valuePattern = Pattern.compile(pattern[1]);
            for (Object key : keyValueMap.keySet().toArray()) {
                Matcher valueMatcher;
                Matcher keyMatcher = keyPattern.matcher(key.toString());
                if (!keyMatcher.matches() || !(valueMatcher = valuePattern.matcher(keyValueMap.get(key))).matches()) continue;
                return pattern[2];
            }
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OheMenuAction
    extends JosmAction {
        public OheMenuAction() {
            super(I18n.tr((String)"edit opening_hours"), "opening_hours.png", I18n.tr((String)"edit time-tag of selcted Element in a graphical interface"), Shortcut.registerShortcut((String)"tools:opening_hourseditor", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"edit opening_hours")}), (int)84, (int)2), false);
        }

        protected void updateEnabledState() {
            if (this.getCurrentDataSet() == null) {
                this.setEnabled(false);
            } else {
                this.updateEnabledState(this.getCurrentDataSet().getSelected());
            }
        }

        protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
            this.setEnabled(selection != null && !selection.isEmpty());
        }

        public void actionPerformed(ActionEvent evt) {
            OsmDataLayer osmlayer = Main.main.getEditLayer();
            if (osmlayer != null) {
                Collection selection = osmlayer.data.getSelected();
                if (selection.size() == 1) {
                    OsmPrimitive object = (OsmPrimitive)selection.iterator().next();
                    String[] keyValuePair = OhePlugin.this.editTimeTags(object.getKeys());
                    if (keyValuePair != null) {
                        String key = keyValuePair[0].trim();
                        String newkey = keyValuePair[1].trim();
                        String value = keyValuePair[2].trim();
                        if (value.equals("")) {
                            value = null;
                        }
                        if (newkey.equals("")) {
                            newkey = key;
                            value = null;
                        }
                        if (key.equals(newkey) && I18n.tr((String)"<different>").equals(value)) {
                            return;
                        }
                        if (key.equals(newkey) || value == null) {
                            Main.main.undoRedo.add((Command)new ChangePropertyCommand(object, newkey, value));
                        } else {
                            Vector<ChangePropertyCommand> commands = new Vector<ChangePropertyCommand>();
                            commands.add(new ChangePropertyCommand(object, key, null));
                            commands.add(new ChangePropertyCommand(object, newkey, value));
                            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Change properties of 1 object"), commands));
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"You have {0} Elements selected. But you can edit only one element!", (Object[])new Object[]{selection.size()}), "openingHoursEditor Warning", 0);
                }
            }
        }
    }
}

