/* Generated By:JavaCC: Do not edit this line. OpeningTimeCompiler.java */
package org.openstreetmap.josm.plugins.ohe.parser;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.openstreetmap.josm.plugins.ohe.OpeningTimeUtils.DaySpan;
import org.openstreetmap.josm.plugins.ohe.OpeningTimeUtils.DaytimeSpan;
import org.openstreetmap.josm.plugins.ohe.OpeningTimeUtils.DateTime;

public class OpeningTimeCompiler implements OpeningTimeCompilerConstants {
  public static final String[] WEEKDAYS = new String[] {"Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"};

  public OpeningTimeCompiler(String time)
  {
    this(new ByteArrayInputStream(time.getBytes()), null);
  }

// returns a list of times
  final public ArrayList<DateTime> startCompile() throws ParseException, ParseException, SyntaxException {
  Vector<Token> usedTokens = new Vector<Token>();
  ArrayList<DateTime> time = new ArrayList<DateTime>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT:
    case WEEKDAY:
    case OFF:
      time = timespanlist(usedTokens);
      break;
    case 5:
      jj_consume_token(5);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(0);
    if (time.size() == 0) {
                ArrayList<DaySpan> daySpans = new ArrayList<DaySpan>();
        daySpans.add(new DaySpan(0,6));
                ArrayList<DaytimeSpan> timeSpans = new ArrayList<DaytimeSpan>();
        timeSpans.add(new DaytimeSpan(0, 24 * 60));
        time.add(new DateTime(daySpans, timeSpans));
        }

    {if (true) return time;}
    throw new Error("Missing return statement in function");
  }

//
  final public ArrayList<DateTime> timespanlist(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
  ArrayList<DateTime> list = new ArrayList<DateTime>();
  DateTime first = null;
  ArrayList<DateTime> second = null;
    first = timespan(usedTokens);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 6:
      jj_consume_token(6);
      second = timespanlist(usedTokens);
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    list.add(first);
    if(second != null)
        list.addAll(second);
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

//
  final public DateTime timespan(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
  ArrayList<DaySpan> dayspanlist = new ArrayList<DaySpan>();
  dayspanlist.add(new DaySpan(0, 6)); // if no days are given the timespan is applied to day 0-6
  ArrayList<DaytimeSpan> daytimespanlist = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WEEKDAY:
      dayspanlist = dayspanlist(usedTokens);
      jj_consume_token(7);
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    daytimespanlist = daytimespanlist(usedTokens);
    {if (true) return new DateTime(dayspanlist, daytimespanlist);}
    throw new Error("Missing return statement in function");
  }

// returns a list of daytimes as ArrayList<int[2]>
  final public ArrayList<DaytimeSpan> daytimespanlist(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
  ArrayList<DaytimeSpan> list = new ArrayList<DaytimeSpan>();
  DaytimeSpan first;
  ArrayList<DaytimeSpan> second = new ArrayList<DaytimeSpan>();
    first = daytimespan(usedTokens);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 8:
      jj_consume_token(8);
      second = daytimespanlist(usedTokens);
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    list.add(first);
    if(second != null)
        list.addAll(second);
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

// returns the minutes from 00:00 of a daytimespan as integer[2]
// int[0] == int[1] means it is just one daytime
// int[0] == int[1] == -1 means off
//           int[1] == 24*60+1 means openend
  final public DaytimeSpan daytimespan(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
  int start, end =-1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OFF:
      start = off(usedTokens);
      break;
    case DIGIT:
      start = daytime(usedTokens);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        end = openend(usedTokens);
        break;
      default:
        jj_la1[5] = jj_gen;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 9:
          jj_consume_token(9);
          end = daytime(usedTokens);
          break;
        default:
          jj_la1[4] = jj_gen;
          ;
        }
      }
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (end < 0)
        end = start;
    else if(end < start)
        {if (true) throw new SyntaxException(null, usedTokens.lastElement().beginColumn - 1, usedTokens.lastElement().endColumn + 1);}

    {if (true) return new DaytimeSpan(start, end);}
    throw new Error("Missing return statement in function");
  }

// returns the minutes from 00:00 as integer
  final public int daytime(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
  Token th0, th1, tm0, tm1;
    th1 = jj_consume_token(DIGIT);
    th0 = jj_consume_token(DIGIT);
    jj_consume_token(10);
    tm1 = jj_consume_token(DIGIT);
    tm0 = jj_consume_token(DIGIT);
    usedTokens.add(th1);
    usedTokens.add(th0);
    usedTokens.add(tm1);
    usedTokens.add(tm0);
    int hour = Integer.parseInt(th1.image) * 10 + Integer.parseInt(th0.image);
    int minute = Integer.parseInt(tm1.image) * 10 + Integer.parseInt(tm0.image);

    if (hour > 24)
        {if (true) throw new SyntaxException(null, th1.beginColumn - 1, th0.endColumn + 1);}
    if (minute >= 60 || (hour == 24 && minute != 0))
        {if (true) throw new SyntaxException(null, tm1.beginColumn - 1, tm0.endColumn + 1);}

    {if (true) return hour * 60 + minute;}
    throw new Error("Missing return statement in function");
  }

//
  final public int openend(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
  Token plus;
    plus = jj_consume_token(PLUS);
    usedTokens.add(plus);
    {if (true) return 24 * 60 + 1;}
    throw new Error("Missing return statement in function");
  }

//
  final public int off(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
  Token off;
    off = jj_consume_token(OFF);
    usedTokens.add(off);
    {if (true) return -1;}
    throw new Error("Missing return statement in function");
  }

// returns a list of days as ArrayList<int[2]>
  final public ArrayList<DaySpan> dayspanlist(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
  ArrayList<DaySpan> list = new ArrayList<DaySpan>();
  DaySpan first;
  ArrayList<DaySpan> second = null;
    first = dayspan(usedTokens);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 8:
      jj_consume_token(8);
      second = dayspanlist(usedTokens);
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    if (second == null) {
      //second dayspanlist is empty, only the first is returned
      list.add(first);
    } else {
      if (first.endDay + 1 == second.get(0).startDay) {
        //the second dayspanlist and the first are coherent, both are joined and returned
        list.addAll(second);
        list.set(0, new DaySpan(first.startDay, second.get(0).endDay));
      } else {
        //the first and the second dayspans are not coherent, both are added to the returnStatement
        list.add(first);
        list.addAll(second);
      }
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

// returns the span of two days as int[2]
// int[0] == int[1] means it is just one day
  final public DaySpan dayspan(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
  int start, end = -1;
    start = day(usedTokens);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 9:
      jj_consume_token(9);
      end = day(usedTokens);
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    if(end < 0)
        end = start;
    else if(end < start)
        {if (true) throw new SyntaxException(null, usedTokens.lastElement().beginColumn - 1, usedTokens.lastElement().endColumn + 1);}

    {if (true) return new DaySpan(start, end);}
    throw new Error("Missing return statement in function");
  }

// returns the weekday as integer
  final public int day(Vector<Token> usedTokens) throws ParseException, ParseException, SyntaxException {
  Token t;
    t = jj_consume_token(WEEKDAY);
    usedTokens.add(t);
    for (int i = 0; i < WEEKDAYS.length; ++i)
      if (WEEKDAYS[i].equals(t.image))
        {if (true) return i;}

    {if (true) throw new SyntaxException(null, t.beginColumn - 1, t.endColumn + 1);}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public OpeningTimeCompilerTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[9];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x36,0x40,0x4,0x100,0x200,0x8,0x12,0x100,0x200,};
   }

  /** Constructor with InputStream. */
  public OpeningTimeCompiler(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public OpeningTimeCompiler(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new OpeningTimeCompilerTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 9; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 9; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public OpeningTimeCompiler(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new OpeningTimeCompilerTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 9; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 9; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public OpeningTimeCompiler(OpeningTimeCompilerTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 9; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(OpeningTimeCompilerTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 9; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[11];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 9; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 11; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
