/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.WMSLayer;

public class GeorefImage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final WMSLayer layer;
    private State state;
    private BufferedImage image;
    private BufferedImage reImg = null;
    private int xIndex;
    private int yIndex;

    public EastNorth getMin() {
        return this.layer.getEastNorth(this.xIndex, this.yIndex);
    }

    public EastNorth getMax() {
        return this.layer.getEastNorth(this.xIndex + 1, this.yIndex + 1);
    }

    public GeorefImage(WMSLayer layer) {
        this.layer = layer;
    }

    public void changePosition(int xIndex, int yIndex) {
        if (!this.equalPosition(xIndex, yIndex)) {
            this.xIndex = xIndex;
            this.yIndex = yIndex;
            this.image = null;
            this.reImg = null;
        }
    }

    public boolean equalPosition(int xIndex, int yIndex) {
        return this.xIndex == xIndex && this.yIndex == yIndex;
    }

    public void changeImage(State state, BufferedImage image) {
        this.image = image;
        this.reImg = null;
        this.state = state;
        switch (state) {
            case FAILED: {
                BufferedImage img = this.createImage();
                Graphics g = img.getGraphics();
                g.setColor(Color.RED);
                g.fillRect(0, 0, img.getWidth(), img.getHeight());
                g.setFont(g.getFont().deriveFont(0).deriveFont(36.0f));
                g.setColor(Color.BLACK);
                g.drawString(I18n.tr((String)"Exception occurred"), 10, img.getHeight() / 2);
                this.image = img;
                break;
            }
            case NOT_IN_CACHE: {
                BufferedImage img = this.createImage();
                Graphics g = img.getGraphics();
                g.setColor(Color.GRAY);
                g.fillRect(0, 0, img.getWidth(), img.getHeight());
                Font font = g.getFont();
                Font tempFont = font.deriveFont(0).deriveFont(36.0f);
                g.setFont(tempFont);
                g.setColor(Color.BLACK);
                g.drawString(I18n.tr((String)"Not in cache"), 10, img.getHeight() / 2);
                g.setFont(font);
                this.image = img;
                break;
            }
        }
    }

    private BufferedImage createImage() {
        int left = this.layer.getImageX(this.xIndex);
        int bottom = this.layer.getImageY(this.yIndex);
        int width = this.layer.getImageX(this.xIndex + 1) - left;
        int height = this.layer.getImageY(this.yIndex + 1) - bottom;
        return new BufferedImage(width, height, 1);
    }

    public boolean paint(Graphics g, NavigatableComponent nc, int xIndex, int yIndex, int leftEdge, int bottomEdge) {
        if (this.image == null) {
            return false;
        }
        if (this.xIndex != xIndex || this.yIndex != yIndex) {
            return false;
        }
        int left = this.layer.getImageX(xIndex);
        int bottom = this.layer.getImageY(yIndex);
        int width = this.layer.getImageX(xIndex + 1) - left;
        int height = this.layer.getImageY(yIndex + 1) - bottom;
        int x = left - leftEdge;
        int y = nc.getHeight() - (bottom - bottomEdge) - height;
        if (width == 0 || height == 0) {
            return false;
        }
        if (this.reImg != null && this.reImg.getWidth() == width && this.reImg.getHeight() == height) {
            g.drawImage(this.reImg, x, y, null);
            return true;
        }
        boolean alphaChannel = WMSLayer.PROP_ALPHA_CHANNEL.get() && this.getImage().getTransparency() != 1;
        try {
            int multipl;
            if (this.reImg != null) {
                this.reImg.flush();
            }
            long freeMem = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory();
            int n = multipl = alphaChannel ? 4 : 3;
            if (width > 2000 || height > 2000 || (long)(width * height * multipl) > freeMem) {
                this.fallbackDraw(g, this.getImage(), x, y, width, height);
            } else {
                this.reImg = new BufferedImage(width, height, alphaChannel ? 2 : 5);
                this.reImg.getGraphics().drawImage(this.getImage(), 0, 0, width, height, 0, 0, this.getImage().getWidth(null), this.getImage().getHeight(null), null);
                this.reImg.getGraphics().dispose();
                g.drawImage(this.reImg, x, y, null);
            }
        }
        catch (Exception e) {
            this.fallbackDraw(g, this.getImage(), x, y, width, height);
        }
        return true;
    }

    private void fallbackDraw(Graphics g, Image img, int x, int y, int width, int height) {
        if (this.reImg != null) {
            this.reImg.flush();
            this.reImg = null;
        }
        g.drawImage(img, x, y, x + width, y + height, 0, 0, img.getWidth(null), img.getHeight(null), null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean hasImage = in.readBoolean();
        if (hasImage) {
            this.image = ImageIO.read(ImageIO.createImageInputStream(in));
        } else {
            in.readObject();
            this.image = null;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.getImage() == null) {
            out.writeBoolean(false);
            out.writeObject(null);
        } else {
            out.writeBoolean(true);
            ImageIO.write((RenderedImage)this.getImage(), "png", ImageIO.createImageOutputStream(out));
        }
    }

    public void flushedResizedCachedInstance() {
        this.reImg = null;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public State getState() {
        return this.state;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        IMAGE,
        NOT_IN_CACHE,
        FAILED;

    }
}

