/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.remotecontrol.handler;

import java.util.HashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.plugins.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddNodeHandler
extends RequestHandler {
    public static final String command = "add_node";
    public static final String permissionKey = "remotecontrol.permission.create-objects";
    public static final boolean permissionDefault = false;

    @Override
    protected void handleRequest() {
        this.addNode(this.args);
    }

    @Override
    protected String[] getMandatoryParams() {
        return new String[]{"lat", "lon"};
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr((String)"Remote Control has been asked to create a new node.");
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return new PermissionPrefWithDefault(permissionKey, false, "RemoteControl: creating objects forbidden by preferences");
    }

    private void addNode(HashMap<String, String> args) {
        double lat = Double.parseDouble(args.get("lat"));
        double lon = Double.parseDouble(args.get("lon"));
        System.out.println("Adding node at (" + lat + ", " + lon + ")");
        LatLon ll = new LatLon(lat, lon);
        Node nnew = new Node(ll);
        Main.main.undoRedo.add((Command)new AddCommand((OsmPrimitive)nnew));
        Main.main.getCurrentDataSet().setSelected(new PrimitiveId[]{nnew});
        Main.map.mapView.repaint();
    }
}

