/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.remotecontrol;

import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.remotecontrol.PermissionPref;
import org.openstreetmap.josm.plugins.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandlerBadRequestException;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandlerErrorException;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandlerForbiddenException;
import org.openstreetmap.josm.tools.I18n;

public abstract class RequestHandler {
    public static final String globalConfirmationKey = "remotecontrol.always-confirm";
    public static final boolean globalConfirmationDefault = false;
    protected HashMap<String, String> args;
    protected String request;
    protected String content = "OK\r\n";
    protected String contentType = "text/plain";
    protected String myCommand;

    final void handle() throws RequestHandlerForbiddenException, RequestHandlerBadRequestException, RequestHandlerErrorException {
        this.checkPermission();
        this.checkMandatoryParams();
        this.handleRequest();
    }

    protected abstract void handleRequest() throws RequestHandlerErrorException, RequestHandlerBadRequestException;

    public abstract String getPermissionMessage();

    public PermissionPref getPermissionPref() {
        return null;
    }

    protected String[] getMandatoryParams() {
        return null;
    }

    public final void checkPermission() throws RequestHandlerForbiddenException {
        PermissionPref permissionPref = this.getPermissionPref();
        if (permissionPref != null && permissionPref.pref != null) {
            PermissionPrefWithDefault permissionPrefWithDefault = permissionPref instanceof PermissionPrefWithDefault ? (PermissionPrefWithDefault)permissionPref : new PermissionPrefWithDefault(permissionPref);
            if (!Main.pref.getBoolean(permissionPrefWithDefault.pref, permissionPrefWithDefault.defaultVal)) {
                System.out.println(permissionPrefWithDefault.message);
                throw new RequestHandlerForbiddenException();
            }
        }
        if (Main.pref.getBoolean(globalConfirmationKey, false) && JOptionPane.showConfirmDialog(Main.parent, "<html>" + this.getPermissionMessage() + "<br>" + I18n.tr((String)"Do you want to allow this?"), I18n.tr((String)"Confirm Remote Control action"), 0) != 0) {
            throw new RequestHandlerForbiddenException();
        }
    }

    public void setUrl(String url) {
        this.request = url;
        this.parseArgs();
    }

    protected void parseArgs() {
        StringTokenizer st = new StringTokenizer(this.request, "&?");
        HashMap<String, String> args = new HashMap<String, String>();
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            int eq = param.indexOf("=");
            if (eq <= -1) continue;
            args.put(param.substring(0, eq), param.substring(eq + 1));
        }
        this.args = args;
    }

    void checkMandatoryParams() throws RequestHandlerBadRequestException {
        String[] mandatory = this.getMandatoryParams();
        if (mandatory == null) {
            return;
        }
        boolean error = false;
        for (int i = 0; i < mandatory.length; ++i) {
            String key = mandatory[i];
            String value = this.args.get(key);
            if (value != null && value.length() != 0) continue;
            error = true;
            System.out.println("'" + this.myCommand + "' remote control request must have '" + key + "' parameter");
        }
        if (error) {
            throw new RequestHandlerBadRequestException();
        }
    }

    public void setCommand(String command) {
        if (command.charAt(0) == '/') {
            command = command.substring(1);
        }
        this.myCommand = command;
    }
}

