/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.remotecontrol;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class RemoteControlPreferences
implements PreferenceSetting {
    private JCheckBox permissionLoadData = new JCheckBox(I18n.tr((String)"load data from API"));
    private JCheckBox permissionImportData = new JCheckBox(I18n.tr((String)"import data from URL"));
    private JCheckBox permissionCreateObjects = new JCheckBox(I18n.tr((String)"create new objects"));
    private JCheckBox permissionChangeSelection = new JCheckBox(I18n.tr((String)"change the selection"));
    private JCheckBox permissionChangeViewport = new JCheckBox(I18n.tr((String)"change the viewport"));
    private JCheckBox permissionReadProtocolversion = new JCheckBox(I18n.tr((String)"read protocol version"));
    private JCheckBox alwaysAskUserConfirm = new JCheckBox(I18n.tr((String)"confirm all Remote Control actions manually"));

    public void addGui(PreferenceTabbedPane gui) {
        String description = I18n.tr((String)"A plugin that allows JOSM to be controlled from other applications.");
        JPanel remote = gui.createPreferenceTab("remotecontrol.gif", I18n.tr((String)"Remote Control"), I18n.tr((String)"Settings for the Remote Control plugin."));
        remote.add((Component)new JLabel("<html>" + I18n.tr((String)"The Remote Control plugin will always listen on port 8111 on localhost.The port is not variable because it is referenced by external applications talking to the plugin.") + "</html>"), GBC.eol().insets(0, 5, 0, 10).fill(2));
        JPanel perms = new JPanel();
        perms.setLayout(new GridBagLayout());
        perms.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), I18n.tr((String)"Permitted actions")));
        perms.add((Component)this.permissionLoadData, GBC.eol().insets(0, 5, 0, 0).fill(2));
        perms.add((Component)this.permissionImportData, GBC.eol().insets(0, 5, 0, 0).fill(2));
        perms.add((Component)this.permissionChangeSelection, GBC.eol().insets(0, 5, 0, 0).fill(2));
        perms.add((Component)this.permissionChangeViewport, GBC.eol().insets(0, 5, 0, 0).fill(2));
        perms.add((Component)this.permissionCreateObjects, GBC.eol().insets(0, 5, 0, 0).fill(2));
        perms.add((Component)this.permissionReadProtocolversion, GBC.eol().insets(0, 5, 0, 0).fill(2));
        remote.add((Component)perms, GBC.eol().fill(2));
        remote.add((Component)this.alwaysAskUserConfirm, GBC.eol().insets(0, 5, 0, 0).fill(2));
        remote.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.permissionLoadData.setSelected(Main.pref.getBoolean("remotecontrol.permission.load-data", true));
        this.permissionImportData.setSelected(Main.pref.getBoolean("remotecontrol.permission.import", true));
        this.permissionChangeSelection.setSelected(Main.pref.getBoolean("remotecontrol.permission.change-selection", true));
        this.permissionChangeViewport.setSelected(Main.pref.getBoolean("remotecontrol.permission.change-viewport", true));
        this.permissionCreateObjects.setSelected(Main.pref.getBoolean("remotecontrol.permission.create-objects", false));
        this.permissionReadProtocolversion.setSelected(Main.pref.getBoolean("remotecontrol.permission.read-protocolversion", true));
        this.alwaysAskUserConfirm.setSelected(Main.pref.getBoolean("remotecontrol.always-confirm", false));
    }

    public boolean ok() {
        Main.pref.put("remotecontrol.permission.load-data", this.permissionLoadData.isSelected());
        Main.pref.put("remotecontrol.permission.import", this.permissionImportData.isSelected());
        Main.pref.put("remotecontrol.permission.change-selection", this.permissionChangeSelection.isSelected());
        Main.pref.put("remotecontrol.permission.change-viewport", this.permissionChangeViewport.isSelected());
        Main.pref.put("remotecontrol.permission.create-objects", this.permissionCreateObjects.isSelected());
        Main.pref.put("remotecontrol.permission.read-protocolversion", this.permissionReadProtocolversion.isSelected());
        Main.pref.put("remotecontrol.always-confirm", this.alwaysAskUserConfirm.isSelected());
        return false;
    }
}

