/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded;

import java.awt.Canvas;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.log.Logger;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;

public abstract class EmbeddedMediaPlayer
extends MediaPlayer {
    private final FullScreenStrategy fullScreenStrategy;
    private final OverlayAdapter overlayAdapter;
    private Canvas videoSurface;
    private Window overlay;

    public EmbeddedMediaPlayer(libvlc_instance_t instance) {
        this(instance, null);
    }

    public EmbeddedMediaPlayer(libvlc_instance_t instance, FullScreenStrategy fullScreenStrategy) {
        super(instance);
        this.fullScreenStrategy = fullScreenStrategy;
        this.overlayAdapter = new OverlayAdapter();
    }

    public void setVideoSurface(Canvas videoSurface) {
        Logger.debug("setVideoSurface(videoSurface={})", videoSurface);
        this.videoSurface = videoSurface;
        this.nativeSetVideoSurface(this.mediaPlayerInstance(), videoSurface);
    }

    public void toggleFullScreen() {
        Logger.debug("toggleFullScreen()", new Object[0]);
        if (this.fullScreenStrategy != null) {
            this.setFullScreen(!this.fullScreenStrategy.isFullScreenMode());
        }
    }

    public void setFullScreen(boolean fullScreen) {
        Logger.debug("setFullScreen(fullScreen={})", fullScreen);
        if (this.fullScreenStrategy != null) {
            if (fullScreen) {
                this.fullScreenStrategy.enterFullScreenMode();
            } else {
                this.fullScreenStrategy.exitFullScreenMode();
            }
        }
    }

    public boolean isFullScreen() {
        Logger.debug("isFullScreen()", new Object[0]);
        if (this.fullScreenStrategy != null) {
            return this.fullScreenStrategy.isFullScreenMode();
        }
        return false;
    }

    public BufferedImage getVideoSurfaceContents() {
        Logger.debug("getVideoSurfaceContents()", new Object[0]);
        try {
            Rectangle bounds = this.videoSurface.getBounds();
            bounds.setLocation(this.videoSurface.getLocationOnScreen());
            return new Robot().createScreenCapture(bounds);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get video surface contents", e);
        }
    }

    public Window getOverlay() {
        Logger.debug("getOverlay()", new Object[0]);
        return this.overlay;
    }

    public void setOverlay(Window overlay) {
        Logger.debug("setOverlay(overlay={})", overlay);
        if (this.videoSurface == null) {
            throw new IllegalStateException("Can't set an overlay when there's no video surface");
        }
        this.enableOverlay(false);
        this.overlay = overlay;
    }

    public void enableOverlay(boolean enable) {
        Logger.debug("enableOverlay(enable={})", enable);
        if (this.overlay != null) {
            if (enable) {
                if (!this.overlay.isVisible()) {
                    this.overlay.setLocation(this.videoSurface.getLocationOnScreen());
                    this.overlay.setSize(this.videoSurface.getSize());
                    Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.videoSurface);
                    window.addComponentListener(this.overlayAdapter);
                    this.overlay.setVisible(true);
                }
            } else if (this.overlay.isVisible()) {
                this.overlay.setVisible(false);
                Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.videoSurface);
                window.removeComponentListener(this.overlayAdapter);
            }
        }
    }

    public boolean overlayEnabled() {
        Logger.debug("overlayEnabled()", new Object[0]);
        return this.overlay != null && this.overlay.isVisible();
    }

    protected abstract void nativeSetVideoSurface(libvlc_media_player_t var1, Canvas var2);

    private final class OverlayAdapter
    extends ComponentAdapter {
        private OverlayAdapter() {
        }

        public void componentResized(ComponentEvent e) {
            Logger.trace("componentResized(e={})", e);
            EmbeddedMediaPlayer.this.overlay.setSize(EmbeddedMediaPlayer.this.videoSurface.getSize());
        }

        public void componentMoved(ComponentEvent e) {
            Logger.trace("componentMoved(e={})", e);
            EmbeddedMediaPlayer.this.overlay.setLocation(EmbeddedMediaPlayer.this.videoSurface.getLocationOnScreen());
        }
    }
}

