/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.direct;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.util.concurrent.Semaphore;
import uk.co.caprica.vlcj.binding.internal.libvlc_display_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_lock_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_unlock_callback_t;
import uk.co.caprica.vlcj.log.Logger;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;

public class DirectMediaPlayer
extends MediaPlayer {
    private final Semaphore semaphore = new Semaphore(1);
    private final int width;
    private final int height;
    private final RenderCallback renderCallback;
    private final Memory nativeBuffer;
    private final libvlc_lock_callback_t lock;
    private final libvlc_unlock_callback_t unlock;
    private final libvlc_display_callback_t display;

    public DirectMediaPlayer(libvlc_instance_t instance, int width, int height, RenderCallback renderCallback) {
        super(instance);
        this.width = width;
        this.height = height;
        this.renderCallback = renderCallback;
        this.nativeBuffer = new Memory((long)(width * height * 4 + 32)).align(32);
        this.lock = new libvlc_lock_callback_t(){

            public Pointer lock(Pointer opaque, Pointer plane) {
                Logger.trace("lock", new Object[0]);
                Logger.trace("acquire", new Object[0]);
                DirectMediaPlayer.this.semaphore.acquireUninterruptibly();
                Logger.trace("acquired", new Object[0]);
                plane.setPointer(0L, (Pointer)DirectMediaPlayer.this.nativeBuffer);
                Logger.trace("lock finished", new Object[0]);
                return null;
            }
        };
        this.unlock = new libvlc_unlock_callback_t(){

            public void unlock(Pointer opaque, Pointer picture, Pointer plane) {
                Logger.trace("unlock", new Object[0]);
                Logger.trace("release", new Object[0]);
                DirectMediaPlayer.this.semaphore.release();
                Logger.trace("released", new Object[0]);
                Logger.trace("unlock finished", new Object[0]);
            }
        };
        this.display = new libvlc_display_callback_t(){

            public void display(Pointer opaque, Pointer picture) {
                Logger.trace("display", new Object[0]);
                DirectMediaPlayer.this.renderCallback.display(DirectMediaPlayer.this.nativeBuffer);
                Logger.trace("display finished", new Object[0]);
            }
        };
        this.libvlc.libvlc_video_set_format(this.mediaPlayerInstance(), "RV32", width, height, width * 4);
        this.libvlc.libvlc_video_set_callbacks(this.mediaPlayerInstance(), this.lock, this.unlock, this.display, null);
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }
}

