/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.util.Arrays;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.log.Log;
import uk.co.caprica.vlcj.log.LogLevel;
import uk.co.caprica.vlcj.log.Logger;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.linux.LinuxEmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.mac.MacEmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.windows.WindowsEmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.headless.HeadlessMediaPlayer;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

public class MediaPlayerFactory {
    private final LibVlc libvlc = LibVlc.SYNC_INSTANCE;
    private libvlc_instance_t instance;
    private boolean released;

    public MediaPlayerFactory(String[] libvlcArgs) {
        Logger.debug("MediaPlayerFactory(libvlcArgs={})", Arrays.toString(libvlcArgs));
        this.instance = this.libvlc.libvlc_new(libvlcArgs.length, libvlcArgs);
        Logger.debug("instance={}", new Object[]{this.instance});
        if (this.instance == null) {
            Logger.error("Failed to initialise libvlc", new Object[0]);
            throw new IllegalStateException("Unable to initialise libvlc, check your libvlc options and/or check the console for error messages");
        }
    }

    public void setUserAgent(String userAgent) {
        Logger.debug("setUserAgent(userAgent={})", userAgent);
        this.setUserAgent(userAgent, null);
    }

    public void setUserAgent(String userAgent, String httpUserAgent) {
        Logger.debug("setUserAgent(userAgent={},httpUserAgent={})", userAgent, httpUserAgent);
        this.libvlc.libvlc_set_user_agent(this.instance, userAgent, userAgent);
    }

    public int getLogVerbosity() {
        Logger.debug("getLogVerbosity()", new Object[0]);
        return this.libvlc.libvlc_get_log_verbosity(this.instance);
    }

    public void setLogLevel(LogLevel level) {
        Logger.debug("setLogVerbosity(level={})", new Object[]{level});
        this.libvlc.libvlc_set_log_verbosity(this.instance, level.intValue());
    }

    public void release() {
        Logger.debug("release()", new Object[0]);
        if (!this.released) {
            if (this.instance != null) {
                this.libvlc.libvlc_release(this.instance);
            }
            this.released = true;
        }
    }

    public EmbeddedMediaPlayer newMediaPlayer(FullScreenStrategy fullScreenStrategy) {
        EmbeddedMediaPlayer mediaPlayer;
        Logger.debug("newMediaPlayer(fullScreenStrategy={})", fullScreenStrategy);
        if (RuntimeUtil.isNix()) {
            mediaPlayer = new LinuxEmbeddedMediaPlayer(this.instance, fullScreenStrategy);
        } else if (RuntimeUtil.isWindows()) {
            mediaPlayer = new WindowsEmbeddedMediaPlayer(this.instance, fullScreenStrategy);
        } else if (RuntimeUtil.isMac()) {
            mediaPlayer = new MacEmbeddedMediaPlayer(this.instance, fullScreenStrategy);
        } else {
            throw new RuntimeException("Unable to create a media player - failed to detect a supported operating system");
        }
        Logger.debug("mediaPlayer={}", mediaPlayer);
        return mediaPlayer;
    }

    public DirectMediaPlayer newMediaPlayer(int width, int height, RenderCallback renderCallback) {
        Logger.debug("newMediaPlayer(width={},height={},renderCallback={})", width, height, renderCallback);
        DirectMediaPlayer mediaPlayer = new DirectMediaPlayer(this.instance, width, height, renderCallback);
        return mediaPlayer;
    }

    public HeadlessMediaPlayer newMediaPlayer() {
        Logger.debug("newMediaPlayer()", new Object[0]);
        HeadlessMediaPlayer mediaPlayer = new HeadlessMediaPlayer(this.instance);
        return mediaPlayer;
    }

    public Log newLog() {
        Logger.debug("newLog()", new Object[0]);
        Log log = new Log(this.libvlc, this.instance);
        log.open();
        return log;
    }
}

