/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.log;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import uk.co.caprica.vlcj.log.Logger;

public class LoggingProxy
implements InvocationHandler {
    private final Object target;

    public LoggingProxy(Object target) {
        this.target = target;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        try {
            this.before(method, args);
            result = method.invoke(this.target, args);
            this.after(method, result);
        }
        catch (InvocationTargetException e) {
            this.exception(method, e.getCause());
            throw e;
        }
        return result;
    }

    private void before(Method method, Object[] args) {
        Logger.trace("call {}: {}", method.getName(), Arrays.toString(args));
    }

    private void after(Method method, Object result) {
        if (!method.getReturnType().equals(Void.TYPE)) {
            Logger.trace("return {}: {}", method.getName(), result);
        } else {
            Logger.trace("return {}: void", method.getName());
        }
    }

    private void exception(Method method, Throwable t) {
        Logger.trace("exception {}: {}", method.getName(), t);
    }
}

