/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.remotecontrol.handler;

import java.net.URLDecoder;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.plugins.remotecontrol.PermissionPref;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandler;
import org.openstreetmap.josm.plugins.remotecontrol.RequestHandlerErrorException;
import org.openstreetmap.josm.tools.I18n;

public class ImportHandler
extends RequestHandler {
    public static final String command = "/import";

    protected void handleRequest() throws RequestHandlerErrorException {
        try {
            DownloadOsmTask osmTask = new DownloadOsmTask();
            osmTask.loadUrl(false, URLDecoder.decode((String)this.args.get("url"), "UTF-8"), null);
        }
        catch (Exception ex) {
            System.out.println("RemoteControl: Error parsing import remote control request:");
            ex.printStackTrace();
            throw new RequestHandlerErrorException();
        }
    }

    protected String[] getMandatoryParams() {
        return new String[]{"url"};
    }

    public String getPermissionMessage() {
        return I18n.tr((String)"Remote Control has been asked to import data from the following URL:") + "<br>" + this.request;
    }

    public PermissionPref getPermissionPref() {
        return new PermissionPref("remotecontrol.permission.import", "RemoteControl: import forbidden by preferences");
    }
}

