/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.waypointSearch;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.plugins.waypointSearch.Engine;

public class SelectMarkerDialog
extends JFrame
implements ActionListener,
MouseListener {
    private JTextField searchPattern = new JTextField(20);
    private DefaultListModel listModel = new DefaultListModel();
    private JList searchResult = new JList(this.listModel);
    private Engine engine = new Engine();
    private List<Marker> SearchResultObjectCache = new ArrayList<Marker>();
    private boolean first_time_search = true;

    public void showFrame() {
        JFrame frame = new JFrame("Search for waypoint");
        frame.setSize(200, 400);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(1);
        frame.setLayout(new BorderLayout());
        this.searchPattern.setText("Enter search expression here..");
        this.searchPattern.addActionListener(this);
        frame.add("North", this.searchPattern);
        this.updateSearchResults();
        this.searchResult.setLayoutOrientation(0);
        this.searchResult.setSelectionMode(0);
        this.searchResult.addMouseListener(this);
        JScrollPane scrollPane = new JScrollPane(this.searchResult);
        scrollPane.setHorizontalScrollBarPolicy(31);
        frame.add("Center", scrollPane);
        frame.add("South", new JLabel("click on waypoint to move map."));
        frame.setVisible(true);
    }

    private void updateSearchResults() {
        String searchfor;
        this.listModel.clear();
        this.SearchResultObjectCache.clear();
        if (this.first_time_search) {
            searchfor = ".*";
            this.first_time_search = false;
        } else {
            searchfor = this.searchPattern.getText();
        }
        for (Marker marker : this.engine.searchGpxWaypoints(searchfor)) {
            this.listModel.addElement(marker.getText());
            this.SearchResultObjectCache.add(marker);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateSearchResults();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Marker marker = this.SearchResultObjectCache.get(this.searchResult.getSelectedIndex());
        Main.map.mapView.zoomTo(marker.getCoor());
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

