/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ywms;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.UnsupportedEncodingException;

public class PPM {
    protected Dimension dim = new Dimension();
    protected int[] data;

    public PPM(String filename) throws IOException, UnsupportedEncodingException {
        FileInputStream fis = new FileInputStream(filename);
        StreamTokenizer st = new StreamTokenizer(fis);
        st.commentChar(35);
        st.nextToken();
        if (!st.sval.equals("P6")) {
            throw new UnsupportedEncodingException("Not a P6 (binary) PPM");
        }
        st.nextToken();
        this.dim.width = (int)Math.round(st.nval);
        st.nextToken();
        this.dim.height = (int)Math.round(st.nval);
        this.data = new int[this.dim.width * this.dim.height];
        st.nextToken();
        int maxVal = (int)Math.round(st.nval);
        if (maxVal != 255) {
            throw new UnsupportedEncodingException("Not a 255 color PPM");
        }
        BufferedInputStream in = new BufferedInputStream(fis);
        int numPixels = this.dim.width * this.dim.height;
        for (int i = 0; i < numPixels; ++i) {
            int r = ((InputStream)in).read();
            int g = ((InputStream)in).read();
            int b = ((InputStream)in).read();
            if (r == -1 || g == -1 || b == -1) {
                throw new IOException("EOF:" + r + " " + g + " " + b);
            }
            this.data[i] = PPM.rgb(r, g, b);
        }
        ((InputStream)in).close();
    }

    public Image getImage() {
        MemoryImageSource memoryImageSource = new MemoryImageSource(this.dim.width, this.dim.height, this.data, 0, this.dim.width);
        return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    private static int rgb(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

