/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.routes;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.routes.ConvertedWay;
import org.openstreetmap.josm.plugins.routes.RouteDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathBuilder {
    private Map<Way, BitSet> wayRoutes = new HashMap<Way, BitSet>();
    private Collection<ConvertedWay> convertedWays;

    public void addWay(Way way, RouteDefinition route) {
        if (way.getNodesCount() >= 2) {
            BitSet routes = this.wayRoutes.get(way);
            if (routes == null) {
                routes = new BitSet();
                this.wayRoutes.put(way, routes);
            }
            routes.set(route.getIndex());
        }
    }

    public Collection<ConvertedWay> getConvertedWays() {
        if (this.convertedWays == null) {
            HashMap<ConvertedWay.WayEnd, ConvertedWay> ways = new HashMap<ConvertedWay.WayEnd, ConvertedWay>();
            for (Map.Entry<Way, BitSet> wayEntry : this.wayRoutes.entrySet()) {
                ConvertedWay way = new ConvertedWay(wayEntry.getValue(), wayEntry.getKey());
                ConvertedWay wayBefore = (ConvertedWay)ways.get(way.getStart());
                ConvertedWay wayAfter = (ConvertedWay)ways.get(way.getStop());
                if (wayBefore != null) {
                    this.removeWay(ways, wayBefore);
                    way.connect(wayBefore);
                }
                if (wayAfter != null) {
                    this.removeWay(ways, wayAfter);
                    way.connect(wayAfter);
                }
                ways.put(way.getStart(), way);
                ways.put(way.getStop(), way);
            }
            HashSet<ConvertedWay> uniqueWays = new HashSet<ConvertedWay>();
            uniqueWays.addAll(ways.values());
            this.convertedWays = uniqueWays;
        }
        return this.convertedWays;
    }

    private void removeWay(Map<ConvertedWay.WayEnd, ConvertedWay> map, ConvertedWay wayInMap) {
        map.remove(wayInMap.getStart());
        map.remove(wayInMap.getStop());
    }

    public void clear() {
        this.convertedWays = null;
        this.wayRoutes.clear();
    }
}

