/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.WMSInfo;
import wmsplugin.WMSPlugin;

public class WMSPreferenceEditor
implements PreferenceSetting {
    private DefaultTableModel model;
    private JComboBox browser;
    private HashMap<Integer, WMSInfo> oldValues = new HashMap();
    JCheckBox overlapCheckBox;
    JSpinner spinEast;
    JSpinner spinNorth;
    JSpinner spinSimConn;

    public void addGui(final PreferenceTabbedPane gui) {
        JPanel p = gui.createPreferenceTab("wms", I18n.tr((String)"WMS Plugin Preferences"), I18n.tr((String)"Modify list of WMS servers displayed in the WMS plugin menu"));
        this.model = new DefaultTableModel(new String[]{I18n.tr((String)"Menu Name"), I18n.tr((String)"WMS URL")}, 0);
        final JTable list = new JTable(this.model);
        JScrollPane scroll = new JScrollPane(list);
        p.add((Component)scroll, GBC.eol().fill(1));
        scroll.setPreferredSize(new Dimension(200, 200));
        for (WMSInfo i : WMSPlugin.wmsList) {
            this.oldValues.put(i.prefid, i);
            this.model.addRow(new String[]{i.name, i.url});
        }
        final DefaultTableModel modeldef = new DefaultTableModel(new String[]{I18n.tr((String)"Menu Name (Default)"), I18n.tr((String)"WMS URL (Default)")}, 0);
        final JTable listdef = new JTable(modeldef){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        JScrollPane scrolldef = new JScrollPane(listdef);
        scrolldef.setPreferredSize(new Dimension(200, 200));
        for (Map.Entry<String, String> i : WMSPlugin.wmsListDefault.entrySet()) {
            modeldef.addRow(new String[]{i.getKey(), i.getValue()});
        }
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton add = new JButton(I18n.tr((String)"Add"));
        buttonPanel.add((Component)add, GBC.std().insets(0, 5, 0, 0));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPanel p = new JPanel(new GridBagLayout());
                p.add((Component)new JLabel(I18n.tr((String)"Menu Name")), GBC.std().insets(0, 0, 5, 0));
                JTextField key = new JTextField(40);
                JTextField value = new JTextField(40);
                p.add((Component)key, GBC.eop().insets(5, 0, 0, 0).fill(2));
                p.add((Component)new JLabel(I18n.tr((String)"WMS URL")), GBC.std().insets(0, 0, 5, 0));
                p.add((Component)value, GBC.eol().insets(5, 0, 0, 0).fill(2));
                int answer = JOptionPane.showConfirmDialog((Component)gui, p, I18n.tr((String)"Enter a menu name and WMS URL"), 2, 3);
                if (answer == 0) {
                    WMSPreferenceEditor.this.model.addRow(new String[]{key.getText(), value.getText()});
                }
            }
        });
        JButton delete = new JButton(I18n.tr((String)"Delete"));
        buttonPanel.add((Component)delete, GBC.std().insets(0, 5, 0, 0));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (list.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select the row to delete."));
                } else {
                    Integer i;
                    while ((i = Integer.valueOf(list.getSelectedRow())) != -1) {
                        WMSPreferenceEditor.this.model.removeRow(i);
                    }
                }
            }
        });
        JButton copy = new JButton(I18n.tr((String)"Copy Selected Default(s)"));
        buttonPanel.add((Component)copy, GBC.std().insets(0, 5, 0, 0));
        copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] lines = listdef.getSelectedRows();
                if (lines.length == 0) {
                    JOptionPane.showMessageDialog((Component)gui, I18n.tr((String)"Please select at least one row to copy."), I18n.tr((String)"Information"), 1);
                    return;
                }
                block0: for (int i = 0; i < lines.length; ++i) {
                    String c1 = modeldef.getValueAt(lines[i], 0).toString();
                    String c2 = modeldef.getValueAt(lines[i], 1).toString();
                    for (int j = 0; j < WMSPreferenceEditor.this.model.getRowCount(); ++j) {
                        if (!c1.equals(WMSPreferenceEditor.this.model.getValueAt(j, 0).toString()) || !c2.equals(WMSPreferenceEditor.this.model.getValueAt(j, 1).toString())) continue;
                        list.getSelectionModel().setSelectionInterval(j, j);
                        list.scrollRectToVisible(list.getCellRect(j, 0, true));
                        continue block0;
                    }
                    WMSPreferenceEditor.this.model.addRow(new String[]{c1, c2});
                    int lastLine = WMSPreferenceEditor.this.model.getRowCount() - 1;
                    list.getSelectionModel().setSelectionInterval(lastLine, lastLine);
                    list.scrollRectToVisible(list.getCellRect(lastLine, 0, true));
                }
            }
        });
        p.add(buttonPanel);
        p.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        p.add((Component)scrolldef, GBC.eol().insets(0, 5, 0, 0).fill(1));
        this.browser = new JComboBox<String>(new String[]{"webkit-image {0}", "gnome-web-photo --mode=photo --format=png {0} /dev/stdout", "gnome-web-photo-fixed {0}", "webkit-image-gtk {0}"});
        this.browser.setEditable(true);
        this.browser.setSelectedItem(Main.pref.get("wmsplugin.browser", "webkit-image {0}"));
        p.add((Component)new JLabel(I18n.tr((String)"Downloader:")), GBC.eol().fill(2));
        p.add(this.browser);
        p.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        this.overlapCheckBox = new JCheckBox(I18n.tr((String)"Overlap tiles"), WMSPlugin.doOverlap);
        JLabel labelEast = new JLabel(I18n.tr((String)"% of east:"));
        JLabel labelNorth = new JLabel(I18n.tr((String)"% of north:"));
        this.spinEast = new JSpinner(new SpinnerNumberModel(WMSPlugin.overlapEast, 1, 50, 1));
        this.spinNorth = new JSpinner(new SpinnerNumberModel(WMSPlugin.overlapNorth, 1, 50, 1));
        JPanel overlapPanel = new JPanel(new FlowLayout());
        overlapPanel.add(this.overlapCheckBox);
        overlapPanel.add(labelEast);
        overlapPanel.add(this.spinEast);
        overlapPanel.add(labelNorth);
        overlapPanel.add(this.spinNorth);
        p.add(overlapPanel);
        p.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        JLabel labelSimConn = new JLabel(I18n.tr((String)"Simultaneous connections"));
        this.spinSimConn = new JSpinner(new SpinnerNumberModel(WMSPlugin.simultaneousConnections, 1, 30, 1));
        JPanel overlapPanelSimConn = new JPanel(new FlowLayout());
        overlapPanelSimConn.add(labelSimConn);
        overlapPanelSimConn.add(this.spinSimConn);
        p.add(overlapPanelSimConn);
    }

    public boolean ok() {
        boolean change = false;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            String name = this.model.getValueAt(i, 0).toString();
            String url = this.model.getValueAt(i, 1).toString();
            WMSInfo origValue = this.oldValues.get(i);
            if (origValue == null) {
                new WMSInfo(name, url, i).save();
                change = true;
                continue;
            }
            if (!origValue.name.equals(name) || !origValue.url.equals(url)) {
                origValue.name = name;
                origValue.url = url;
                origValue.save();
                change = true;
            }
            this.oldValues.remove(i);
        }
        for (WMSInfo i : this.oldValues.values()) {
            i.url = null;
            i.name = null;
            i.save();
            change = true;
        }
        if (change) {
            WMSPlugin.refreshMenu();
        }
        WMSPlugin.doOverlap = this.overlapCheckBox.getModel().isSelected();
        WMSPlugin.overlapEast = (Integer)this.spinEast.getModel().getValue();
        WMSPlugin.overlapNorth = (Integer)this.spinNorth.getModel().getValue();
        WMSPlugin.simultaneousConnections = (Integer)this.spinSimConn.getModel().getValue();
        Main.pref.put("wmsplugin.url.overlap", String.valueOf(WMSPlugin.doOverlap));
        Main.pref.put("wmsplugin.url.overlapEast", String.valueOf(WMSPlugin.overlapEast));
        Main.pref.put("wmsplugin.url.overlapNorth", String.valueOf(WMSPlugin.overlapNorth));
        Main.pref.put("wmsplugin.browser", this.browser.getEditor().getItem().toString());
        Main.pref.put("wmsplugin.simultaneousConnections", String.valueOf(WMSPlugin.simultaneousConnections));
        return false;
    }

    public void setServerUrl(String server, String url) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!server.equals(this.model.getValueAt(i, 0).toString())) continue;
            this.model.setValueAt(url, i, 1);
            return;
        }
        this.model.addRow(new String[]{server, url});
    }

    public String getServerUrl(String server) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!server.equals(this.model.getValueAt(i, 0).toString())) continue;
            return this.model.getValueAt(i, 1).toString();
        }
        return null;
    }
}

