/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import wmsplugin.GeorefImage;
import wmsplugin.WMSLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSAdjustAction
extends MapMode
implements MouseListener,
MouseMotionListener {
    GeorefImage selectedImage;
    boolean mouseDown;
    EastNorth prevEastNorth;
    private WMSLayer adjustingLayer;

    public WMSAdjustAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Adjust WMS"), "adjustwms", I18n.tr((String)"Adjust the position of the selected WMS layer"), mapFrame, ImageProvider.getCursor((String)"normal", (String)"move"));
    }

    public void enterMode() {
        super.enterMode();
        if (!this.hasWMSLayersToAdjust()) {
            this.warnNoWMSLayers();
            return;
        }
        List wmsLayers = Main.map.mapView.getLayersOfType(WMSLayer.class);
        this.adjustingLayer = wmsLayers.size() == 1 ? (WMSLayer)((Object)wmsLayers.get(0)) : (WMSLayer)this.askAdjustLayer(Main.map.mapView.getLayersOfType(WMSLayer.class));
        if (this.adjustingLayer == null) {
            return;
        }
        if (!this.adjustingLayer.isVisible()) {
            this.adjustingLayer.setVisible(true);
        }
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
        this.adjustingLayer = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (this.adjustingLayer.isVisible()) {
            this.prevEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            this.selectedImage = this.adjustingLayer.findImage(this.prevEastNorth);
            if (this.selectedImage != null) {
                Main.map.mapView.setCursor(Cursor.getPredefinedCursor(13));
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selectedImage != null) {
            EastNorth eastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            this.adjustingLayer.displace(eastNorth.east() - this.prevEastNorth.east(), eastNorth.north() - this.prevEastNorth.north());
            this.prevEastNorth = eastNorth;
            Main.map.mapView.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Main.map.mapView.repaint();
        Main.map.mapView.setCursor(Cursor.getDefaultCursor());
        this.selectedImage = null;
        this.prevEastNorth = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof WMSLayer && l.isVisible();
    }

    protected Layer askAdjustLayer(List<? extends Layer> adjustableLayers) {
        JComboBox<Object> layerList = new JComboBox<Object>();
        layerList.setRenderer(new LayerListCellRenderer());
        layerList.setModel(new DefaultComboBoxModel<Object>(adjustableLayers.toArray()));
        layerList.setSelectedIndex(0);
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        pnl.add((Component)new JLabel(I18n.tr((String)"Please select the WMS layer to adjust.")), GBC.eol());
        pnl.add(layerList, GBC.eol());
        ExtendedDialog diag = new ExtendedDialog(Main.parent, I18n.tr((String)"Select WMS layer"), new String[]{I18n.tr((String)"Start adjusting"), I18n.tr((String)"Cancel")});
        diag.setContent((Component)pnl);
        diag.setButtonIcons(new String[]{"mapmode/adjustwms", "cancel"});
        diag.showDialog();
        int decision = diag.getValue();
        if (decision != 1) {
            return null;
        }
        Layer adjustLayer = (Layer)layerList.getSelectedItem();
        return adjustLayer;
    }

    protected void warnNoWMSLayers() {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"There are currently no WMS layer to adjust."), I18n.tr((String)"No layers to adjust"), 2);
    }

    protected boolean hasWMSLayersToAdjust() {
        if (Main.map == null) {
            return false;
        }
        if (Main.map.mapView == null) {
            return false;
        }
        return !Main.map.mapView.getLayersOfType(WMSLayer.class).isEmpty();
    }

    protected void updateEnabledState() {
        this.setEnabled(this.hasWMSLayersToAdjust());
    }

    public static class LayerListCellRenderer
    extends DefaultListCellRenderer {
        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Layer layer = (Layer)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, layer.getName(), index, isSelected, cellHasFocus);
            Icon icon = layer.getIcon();
            label.setIcon(icon);
            label.setToolTipText(layer.getToolTipText());
            return label;
        }
    }
}

