/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoyCard
extends Buoy {
    public BuoyCard(SmpDialogAction dia, int type) {
        super(dia);
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem("Not set");
        this.dlg.cbM01StyleOfMark.addItem("Pillar Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Spar Buoy");
        this.dlg.cbM01StyleOfMark.addItem("Beacon");
        this.dlg.cbM01StyleOfMark.addItem("Tower");
        this.dlg.cbM01StyleOfMark.addItem("Float");
        this.dlg.cbM01Colour.removeAllItems();
        this.dlg.cbM01Colour.addItem("W");
        this.dlg.cbM01Colour.setSelectedIndex(0);
        this.dlg.cbM01Colour.setEnabled(false);
        this.dlg.cM01Fired.setSelected(false);
        this.dlg.cM01TopMark.setSelected(false);
        this.setStyleIndex(0);
        this.setBuoyIndex(type);
        this.setLightColour("W");
        switch (type) {
            case 6: {
                this.setColour(6);
                break;
            }
            case 7: {
                this.setColour(7);
                break;
            }
            case 8: {
                this.setColour(8);
                break;
            }
            case 9: {
                this.setColour(9);
                break;
            }
        }
        this.refreshLights();
        this.paintSign();
    }

    public void refreshLights() {
        int type = this.getBuoyIndex();
        this.dlg.cbM01Kennung.removeAllItems();
        this.dlg.cbM01Kennung.addItem("Not set");
        this.dlg.cbM01Kennung.setSelectedIndex(0);
        switch (type) {
            case 6: {
                this.dlg.cbM01Kennung.addItem("Q");
                this.dlg.cbM01Kennung.addItem("VQ");
                break;
            }
            case 7: {
                this.dlg.cbM01Kennung.addItem("Q(3)");
                this.dlg.cbM01Kennung.addItem("VQ(3)");
                break;
            }
            case 8: {
                this.dlg.cbM01Kennung.addItem("Q(6)+LFl");
                this.dlg.cbM01Kennung.addItem("VQ(6)+LFl");
                break;
            }
            case 9: {
                this.dlg.cbM01Kennung.addItem("Q(9)");
                this.dlg.cbM01Kennung.addItem("VQ(9)");
                break;
            }
        }
    }

    public void paintSign() {
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        this.dlg.tfM01Name.setEnabled(true);
        this.dlg.tfM01Name.setText(this.getName());
        this.dlg.cM01TopMark.setSelected(true);
        this.dlg.cM01TopMark.setEnabled(false);
        this.dlg.cM01Fired.setEnabled(true);
        block0 : switch (this.getBuoyIndex()) {
            case 6: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Pillar_North.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/North_Top_Buoy.png")));
                        break block0;
                    }
                    case 2: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Spar_North.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/North_Top_Buoy.png")));
                        break block0;
                    }
                    case 3: {
                        if (this.isFired()) {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Beacon_Lit_North.png")));
                        } else {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Beacon_North.png")));
                        }
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/North_Top_Post.png")));
                        break block0;
                    }
                    case 4: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Tower_North.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/North_Top_Post.png")));
                        break block0;
                    }
                    case 5: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Float_North.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/North_Top_Post.png")));
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Pillar_East.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/East_Top_Buoy.png")));
                        break block0;
                    }
                    case 2: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Spar_East.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/East_Top_Buoy.png")));
                        break block0;
                    }
                    case 3: {
                        if (this.isFired()) {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Beacon_Lit_East.png")));
                        } else {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Beacon_East.png")));
                        }
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/East_Top_Post.png")));
                        break block0;
                    }
                    case 4: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Tower_East.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/East_Top_Post.png")));
                        break block0;
                    }
                    case 5: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Float_East.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/East_Top_Post.png")));
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Pillar_South.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/South_Top_Buoy.png")));
                        break block0;
                    }
                    case 2: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Spar_South.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/South_Top_Buoy.png")));
                        break block0;
                    }
                    case 3: {
                        if (this.isFired()) {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Beacon_Lit_South.png")));
                        } else {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Beacon_South.png")));
                        }
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/South_Top_Post.png")));
                        break block0;
                    }
                    case 4: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Tower_South.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/South_Top_Post.png")));
                        break block0;
                    }
                    case 5: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Float_South.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/South_Top_Post.png")));
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                switch (this.getStyleIndex()) {
                    case 1: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Pillar_West.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/West_Top_Buoy.png")));
                        break block0;
                    }
                    case 2: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Spar_West.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/West_Top_Buoy.png")));
                        break block0;
                    }
                    case 3: {
                        if (this.isFired()) {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Beacon_Lit_West.png")));
                        } else {
                            this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Beacon_Lit_West.png")));
                        }
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/West_Top_Post.png")));
                        break block0;
                    }
                    case 4: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Tower_West.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/West_Top_Post.png")));
                        break block0;
                    }
                    case 5: {
                        this.dlg.lM01Icon01.setIcon(new ImageIcon(this.getClass().getResource("/images/Cardinal_Float_West.png")));
                        this.dlg.lM01Icon02.setIcon(new ImageIcon(this.getClass().getResource("/images/West_Top_Post.png")));
                        break block0;
                    }
                }
                break;
            }
        }
        if (this.getLightChar() != "") {
            String tmp = null;
            String c = this.getLightChar();
            if (c.contains("+")) {
                int i1 = c.indexOf("+");
                tmp = c.substring(i1, c.length());
                c = c.substring(0, i1);
            }
            if (this.getLightGroup() != "") {
                c = c + "(" + this.getLightGroup() + ")";
            }
            if (tmp != null) {
                c = c + tmp;
            }
            this.dlg.cbM01Kennung.setSelectedItem(c);
            if (this.dlg.cbM01Kennung.getSelectedItem() == "Not set") {
                String string = "";
            }
        }
        this.Checker(null, "/images/Light_White.png");
    }

    public boolean parseLight(Node node) {
        boolean ret = true;
        this.setFired(false);
        Map keys = node.getKeys();
        if (keys.containsKey("seamark:light:colour")) {
            String str = (String)keys.get("seamark:light:colour");
            if (keys.containsKey("seamark:light:character")) {
                String tmp = null;
                this.setLightGroup(keys);
                String c = (String)keys.get("seamark:light:character");
                if (c.contains("+")) {
                    int i1 = c.indexOf("+");
                    tmp = c.substring(i1, c.length());
                    c = c.substring(0, i1);
                }
                if (this.getLightGroup() != "" && tmp != null) {
                    c = c + tmp;
                }
                this.setLightChar(c);
                this.setLightPeriod(keys);
            }
            if (str.compareTo("white") == 0) {
                this.setFired(true);
                this.setLightColour("W");
            } else {
                if (this.getErrMsg() == null) {
                    this.setErrMsg("Parse-Error: Licht falsch");
                } else {
                    this.setErrMsg(this.getErrMsg() + " / Licht falsch");
                }
                ret = false;
            }
        }
        return ret;
    }

    public void setLightColour() {
        super.setLightColour("W");
    }

    public boolean parseShape(Node node) {
        boolean ret = true;
        Map keys = node.getKeys();
        if (keys.containsKey("seamark:buoy_cardinal:shape")) {
            String str = (String)keys.get("seamark:buoy_cardinal:shape");
            if (str.compareTo("pillar") == 0) {
                this.setStyleIndex(1);
            } else if (str.compareTo("spar") == 0) {
                this.setStyleIndex(2);
            } else if (str.compareTo("float") == 0) {
                this.setStyleIndex(5);
            } else {
                ret = false;
            }
        } else if (keys.containsKey("seamark:beacon_cardinal:shape")) {
            String str = (String)keys.get("seamark:beacon_cardinal:shape");
            if (str.compareTo("stake") == 0) {
                this.setStyleIndex(3);
            } else if (str.compareTo("tower") == 0) {
                this.setStyleIndex(4);
            } else {
                ret = false;
            }
        }
        return ret;
    }

    public boolean parseTopMark(Node node) {
        return false;
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        switch (this.getStyleIndex()) {
            case 1: {
                super.saveSign("buoy_cardinal");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:shape", "pillar"));
                break;
            }
            case 2: {
                super.saveSign("buoy_cardinal");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:shape", "spar"));
                break;
            }
            case 3: {
                super.saveSign("beacon_cardinal");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:shape", "stake"));
                break;
            }
            case 4: {
                super.saveSign("beacon_cardinal");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:shape", "tower"));
                break;
            }
            case 5: {
                super.saveSign("buoy_cardinal");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:shape", "float"));
                break;
            }
        }
        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour_pattern", "horizontal stripes"));
        block7 : switch (this.getStyleIndex()) {
            case 1: 
            case 2: 
            case 5: {
                switch (this.getBuoyIndex()) {
                    case 6: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:category", "north"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour", "black;yellow"));
                        break;
                    }
                    case 7: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:category", "east"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour", "black;yellow;black"));
                        break;
                    }
                    case 8: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:category", "south"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour", "yellow;black"));
                        break;
                    }
                    case 9: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:category", "west"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour", "yellow;black;yellow"));
                    }
                }
            }
            case 3: 
            case 4: {
                switch (this.getBuoyIndex()) {
                    case 6: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:category", "north"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour", "black;yellow"));
                        break block7;
                    }
                    case 7: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:category", "east"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour", "black;yellow;black"));
                        break block7;
                    }
                    case 8: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:category", "south"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour", "yellow;black"));
                        break block7;
                    }
                    case 9: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:category", "west"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour", "yellow;black;yellow"));
                    }
                }
            }
        }
        this.saveLightData("white");
    }
}

